/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import org.apache.iotdb.db.mpp.aggregation.LastValueAccumulator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.column.Column;

public class LastValueDescAccumulator
extends LastValueAccumulator {
    public LastValueDescAccumulator(TSDataType seriesDataType) {
        super(seriesDataType);
    }

    @Override
    public boolean hasFinalResult() {
        return this.initResult;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    protected int addIntInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateIntLastValue(column[1].getInt(i), curTime);
            return i;
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addLongInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateLongLastValue(column[1].getLong(i), curTime);
            return i;
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addFloatInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateFloatLastValue(column[1].getFloat(i), curTime);
            return i;
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addDoubleInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateDoubleLastValue(column[1].getDouble(i), curTime);
            return i;
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addBooleanInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateBooleanLastValue(column[1].getBoolean(i), curTime);
            return i;
        }
        return column[0].getPositionCount();
    }

    @Override
    protected int addBinaryInput(Column[] column, TimeRange timeRange) {
        for (int i = 0; i < column[0].getPositionCount(); ++i) {
            long curTime = column[0].getLong(i);
            if (curTime > timeRange.getMax() || curTime < timeRange.getMin()) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateBinaryLastValue(column[1].getBinary(i), curTime);
            return i;
        }
        return column[0].getPositionCount();
    }
}

