/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;

public class Aggregator {
    protected final Accumulator accumulator;
    protected List<InputLocation[]> inputLocationList;
    protected final AggregationStep step;
    protected TimeRange curTimeRange = new TimeRange(0L, Long.MAX_VALUE);

    public Aggregator(Accumulator accumulator, AggregationStep step) {
        this.accumulator = accumulator;
        this.step = step;
        this.inputLocationList = Collections.singletonList(new InputLocation[]{new InputLocation(0, 0)});
    }

    public Aggregator(Accumulator accumulator, AggregationStep step, List<InputLocation[]> inputLocationList) {
        this.accumulator = accumulator;
        this.step = step;
        this.inputLocationList = inputLocationList;
    }

    public int processTsBlock(TsBlock tsBlock) {
        Preconditions.checkArgument((boolean)this.step.isInputRaw(), (Object)"Step in SeriesAggregateScanOperator and RawDataAggregateOperator can only process raw input");
        if (this.inputLocationList == null) {
            return this.accumulator.addInput(tsBlock.getTimeAndValueColumn(0), this.curTimeRange);
        }
        int lastReadReadIndex = 0;
        for (InputLocation[] inputLocations : this.inputLocationList) {
            Preconditions.checkArgument((inputLocations[0].getTsBlockIndex() == 0 ? 1 : 0) != 0, (Object)"RawDataAggregateOperator can only process one tsBlock input.");
            Column[] timeValueColumn = new Column[]{tsBlock.getTimeColumn(), tsBlock.getColumn(inputLocations[0].getValueColumnIndex())};
            lastReadReadIndex = Math.max(lastReadReadIndex, this.accumulator.addInput(timeValueColumn, this.curTimeRange));
        }
        return lastReadReadIndex;
    }

    public void processTsBlocks(TsBlock[] tsBlock) {
        Preconditions.checkArgument((!this.step.isInputRaw() ? 1 : 0) != 0, (Object)"Step in AggregateOperator cannot process raw input");
        if (this.step.isInputFinal()) {
            Preconditions.checkArgument((this.inputLocationList.size() == 1 ? 1 : 0) != 0, (Object)"Final output can only be single column");
            Column finalResult = tsBlock[this.inputLocationList.get(0)[0].getTsBlockIndex()].getColumn(this.inputLocationList.get(0)[0].getValueColumnIndex());
            this.accumulator.setFinal(finalResult);
        } else {
            for (InputLocation[] inputLocations : this.inputLocationList) {
                Column[] columns = new Column[inputLocations.length];
                for (int i = 0; i < inputLocations.length; ++i) {
                    columns[i] = tsBlock[inputLocations[i].getTsBlockIndex()].getColumn(inputLocations[i].getValueColumnIndex());
                }
                this.accumulator.addIntermediate(columns);
            }
        }
    }

    public void outputResult(ColumnBuilder[] columnBuilder) {
        if (this.step.isOutputPartial()) {
            this.accumulator.outputIntermediate(columnBuilder);
        } else {
            this.accumulator.outputFinal(columnBuilder[0]);
        }
    }

    public void processStatistics(Statistics[] statistics) {
        for (InputLocation[] inputLocations : this.inputLocationList) {
            int valueIndex = inputLocations[0].getValueColumnIndex();
            this.accumulator.addStatistics(statistics[valueIndex]);
        }
    }

    public TSDataType[] getOutputType() {
        if (this.step.isOutputPartial()) {
            return this.accumulator.getIntermediateType();
        }
        return new TSDataType[]{this.accumulator.getFinalType()};
    }

    public void reset() {
        this.curTimeRange = new TimeRange(0L, Long.MAX_VALUE);
        this.accumulator.reset();
    }

    public boolean hasFinalResult() {
        return this.accumulator.hasFinalResult();
    }

    public void updateTimeRange(TimeRange curTimeRange) {
        this.reset();
        this.curTimeRange = curTimeRange;
    }

    public TimeRange getCurTimeRange() {
        return this.curTimeRange;
    }
}

