/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.counter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.CounterTraverser;

public class MNodeLevelCounter
extends CounterTraverser {
    protected int targetLevel;
    private Set<IMNode> processedNodes = new HashSet<IMNode>();

    public MNodeLevelCounter(IMNode startNode, PartialPath path, IMTreeStore store, int targetLevel) throws MetadataException {
        super(startNode, path, store);
        this.targetLevel = targetLevel;
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
        return this.processLevelMatchedMNode(node, level);
    }

    private boolean processLevelMatchedMNode(IMNode node, int level) {
        if (level < this.targetLevel) {
            return false;
        }
        IMNode levelMatchedAncestor = this.getLevelMatchedAncestor(node, level);
        if (!this.processedNodes.contains(levelMatchedAncestor)) {
            this.processedNodes.add(levelMatchedAncestor);
            ++this.count;
        }
        return true;
    }

    private IMNode getLevelMatchedAncestor(IMNode node, int level) {
        Iterator iterator = this.traverseContext.iterator();
        while (level > this.targetLevel && iterator.hasNext()) {
            node = (IMNode)iterator.next();
            --level;
        }
        return node;
    }
}

