/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.metadata.MNodeTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.template.TemplateImcompatibeException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.lastCache.LastCacheManager;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mtree.IMTreeBelowSG;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.MemMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.CollectorTraverser;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.EntityCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.MeasurementCollector;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.EntityCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MNodeLevelCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MeasurementCounter;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.MeasurementGroupByLevelCounter;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaFormatUtils;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MTreeBelowSGMemoryImpl
implements IMTreeBelowSG {
    private MemMTreeStore store;
    private volatile IStorageGroupMNode storageGroupMNode;
    private int levelOfSG;

    public MTreeBelowSGMemoryImpl(IStorageGroupMNode storageGroupMNode, int schemaRegionId) {
        PartialPath storageGroup = storageGroupMNode.getPartialPath();
        this.store = new MemMTreeStore(storageGroup, true);
        this.storageGroupMNode = this.store.getRoot().getAsStorageGroupMNode();
        this.storageGroupMNode.setParent(storageGroupMNode.getParent());
        this.levelOfSG = storageGroup.getNodeLength() - 1;
    }

    private MTreeBelowSGMemoryImpl(MemMTreeStore store, IStorageGroupMNode storageGroupMNode, int schemaRegionId) {
        this.store = store;
        this.storageGroupMNode = store.getRoot().getAsStorageGroupMNode();
        this.storageGroupMNode.setParent(storageGroupMNode.getParent());
        this.levelOfSG = storageGroupMNode.getPartialPath().getNodeLength() - 1;
    }

    @Override
    public void clear() {
        this.store.clear();
        this.storageGroupMNode = null;
    }

    public synchronized boolean createSnapshot(File snapshotDir) {
        return this.store.createSnapshot(snapshotDir);
    }

    public static MTreeBelowSGMemoryImpl loadFromSnapshot(File snapshotDir, IStorageGroupMNode storageGroupMNode, int schemaRegionId, Consumer<IMeasurementMNode> measurementProcess) throws IOException {
        return new MTreeBelowSGMemoryImpl(MemMTreeStore.loadFromSnapshot(snapshotDir, measurementProcess), storageGroupMNode, schemaRegionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMeasurementMNode createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        Pair<IMNode, Template> pair = this.checkAndAutoCreateInternalPath(path.getDevicePath());
        IMNode device = (IMNode)pair.left;
        Template upperTemplate = (Template)pair.right;
        MetaFormatUtils.checkTimeseriesProps(path.getFullPath(), props);
        String leafName = path.getMeasurement();
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IEntityMNode entityMNode;
            if (alias != null && device.hasChild(alias)) {
                throw new AliasAlreadyExistException(path.getFullPath(), alias);
            }
            if (device.hasChild(leafName)) {
                IMNode node = device.getChild(leafName);
                if (node.isMeasurement()) {
                    throw new MeasurementAlreadyExistException(path.getFullPath(), node.getAsMeasurementMNode().getMeasurementPath());
                }
                throw new PathAlreadyExistException(path.getFullPath());
            }
            if (upperTemplate != null && (upperTemplate.getDirectNode(leafName) != null || upperTemplate.getDirectNode(alias) != null)) {
                throw new TemplateImcompatibeException(path.getFullPath(), upperTemplate.getName());
            }
            if (device.isEntity() && device.getAsEntityMNode().isAligned()) {
                throw new AlignedTimeseriesException("Timeseries under this entity is aligned, please use createAlignedTimeseries or change entity.", device.getFullPath());
            }
            if (device.isEntity()) {
                entityMNode = device.getAsEntityMNode();
            } else {
                entityMNode = this.store.setToEntity(device);
                if (entityMNode.isStorageGroup()) {
                    this.storageGroupMNode = entityMNode.getAsStorageGroupMNode();
                }
            }
            IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, leafName, (IMeasurementSchema)new MeasurementSchema(leafName, dataType, encoding, compressor, props), alias);
            this.store.addChild(entityMNode, leafName, measurementMNode);
            if (alias != null) {
                entityMNode.addAlias(alias, measurementMNode);
            }
            return measurementMNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMeasurementMNode> createAlignedTimeseries(PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList) throws MetadataException {
        IEntityMNode entityMNode;
        int i;
        ArrayList<IMeasurementMNode> measurementMNodeList = new ArrayList<IMeasurementMNode>();
        MetaFormatUtils.checkSchemaMeasurementNames(measurements);
        Pair<IMNode, Template> pair = this.checkAndAutoCreateInternalPath(devicePath);
        IMNode device = (IMNode)pair.left;
        Template upperTemplate = (Template)pair.right;
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            for (i = 0; i < measurements.size(); ++i) {
                if (device.hasChild(measurements.get(i))) {
                    IMNode node = device.getChild(measurements.get(i));
                    if (node.isMeasurement()) {
                        throw new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), node.getAsMeasurementMNode().getMeasurementPath());
                    }
                    throw new PathAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i));
                }
                if (aliasList == null || aliasList.get(i) == null || !device.hasChild(aliasList.get(i))) continue;
                throw new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), aliasList.get(i));
            }
        }
        if (upperTemplate != null) {
            for (String measurement : measurements) {
                if (upperTemplate.getDirectNode(measurement) == null) continue;
                throw new TemplateImcompatibeException(devicePath.concatNode(measurement).getFullPath(), upperTemplate.getName());
            }
        }
        if (device.isEntity() && !device.getAsEntityMNode().isAligned()) {
            throw new AlignedTimeseriesException("Timeseries under this entity is not aligned, please use createTimeseries or change entity.", devicePath.getFullPath());
        }
        if (device.isEntity()) {
            entityMNode = device.getAsEntityMNode();
        } else {
            entityMNode = this.store.setToEntity(device);
            entityMNode.setAligned(true);
            if (entityMNode.isStorageGroup()) {
                this.storageGroupMNode = entityMNode.getAsStorageGroupMNode();
            }
        }
        for (i = 0; i < measurements.size(); ++i) {
            IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(entityMNode, measurements.get(i), (IMeasurementSchema)new MeasurementSchema(measurements.get(i), dataTypes.get(i), encodings.get(i), compressors.get(i)), aliasList == null ? null : aliasList.get(i));
            this.store.addChild(entityMNode, measurements.get(i), measurementMNode);
            if (aliasList != null && aliasList.get(i) != null) {
                entityMNode.addAlias(aliasList.get(i), measurementMNode);
            }
            measurementMNodeList.add(measurementMNode);
        }
        return measurementMNodeList;
    }

    private Pair<IMNode, Template> checkAndAutoCreateInternalPath(PartialPath devicePath) throws MetadataException {
        String[] nodeNames = devicePath.getNodes();
        MetaFormatUtils.checkTimeseries(devicePath);
        IMNode cur = this.storageGroupMNode;
        Template upperTemplate = cur.getSchemaTemplate();
        for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
            String childName = nodeNames[i];
            IMNode child = cur.getChild(childName);
            if (child == null) {
                if (upperTemplate != null && upperTemplate.getDirectNode(childName) != null) {
                    throw new TemplateImcompatibeException(devicePath.getFullPath(), upperTemplate.getName(), childName);
                }
                child = this.store.addChild(cur, childName, new InternalMNode(cur, childName));
            }
            if ((cur = child).isMeasurement()) {
                throw new PathAlreadyExistException(cur.getFullPath());
            }
            if (cur.getSchemaTemplate() == null) continue;
            upperTemplate = cur.getSchemaTemplate();
        }
        return new Pair((Object)cur, (Object)upperTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<PartialPath, IMeasurementMNode> deleteTimeseriesAndReturnEmptyStorageGroup(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0) {
            throw new IllegalPathException(path.getFullPath());
        }
        if (this.isPathExistsWithinTemplate(path)) {
            throw new MetadataException("Cannot delete a timeseries inside a template: " + path);
        }
        IMeasurementMNode deletedNode = this.getMeasurementMNode(path);
        IEntityMNode parent = deletedNode.getParent();
        this.store.deleteChild(parent, path.getMeasurement());
        if (deletedNode.getAlias() != null) {
            parent.addAlias(deletedNode.getAlias(), deletedNode);
        }
        IMNode curNode = parent;
        if (!parent.isUseTemplate()) {
            boolean hasMeasurement = false;
            IMNodeIterator iterator = this.store.getChildrenIterator(parent);
            while (iterator.hasNext()) {
                IMNode child = (IMNode)iterator.next();
                if (!child.isMeasurement()) continue;
                hasMeasurement = true;
                break;
            }
            if (!hasMeasurement) {
                MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
                synchronized (mTreeBelowSGMemoryImpl) {
                    curNode = this.store.setToInternal(parent);
                    if (curNode.isStorageGroup()) {
                        this.storageGroupMNode = curNode.getAsStorageGroupMNode();
                    }
                }
            }
        }
        while (this.isEmptyInternalMNode(curNode)) {
            if (curNode.isStorageGroup()) {
                return new Pair((Object)curNode.getPartialPath(), (Object)deletedNode);
            }
            this.store.deleteChild(curNode.getParent(), curNode.getName());
            curNode = curNode.getParent();
        }
        return new Pair(null, (Object)deletedNode);
    }

    @Override
    public boolean isEmptyInternalMNode(IMNode node) {
        return !"root".equals(node.getName()) && !node.isMeasurement() && node.getSchemaTemplate() == null && !node.isUseTemplate() && node.getChildren().isEmpty();
    }

    @Override
    public void setAlias(IMeasurementMNode measurementMNode, String alias) throws MetadataException {
        this.store.setAlias(measurementMNode, alias);
    }

    @Override
    public IMNode getDeviceNodeWithAutoCreating(PartialPath deviceId) throws MetadataException {
        MetaFormatUtils.checkTimeseries(deviceId);
        String[] nodeNames = deviceId.getNodes();
        IMNode cur = this.storageGroupMNode;
        Template upperTemplate = cur.getSchemaTemplate();
        for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
            IMNode child = cur.getChild(nodeNames[i]);
            if (child == null) {
                if (cur.isUseTemplate() && upperTemplate != null && upperTemplate.getDirectNode(nodeNames[i]) != null) {
                    throw new PathAlreadyExistException(cur.getPartialPath().concatNode(nodeNames[i]).getFullPath());
                }
                child = this.store.addChild(cur, nodeNames[i], new InternalMNode(cur, nodeNames[i]));
            }
            upperTemplate = (cur = child).getSchemaTemplate() == null ? upperTemplate : cur.getSchemaTemplate();
        }
        return cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IEntityMNode setToEntity(IMNode node) throws MetadataException {
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IEntityMNode entityMNode = this.store.setToEntity(node);
            if (entityMNode.isStorageGroup()) {
                this.storageGroupMNode = entityMNode.getAsStorageGroupMNode();
            }
            return entityMNode;
        }
    }

    @Override
    public boolean isPathExist(PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.storageGroupMNode;
        Template upperTemplate = cur.getSchemaTemplate();
        boolean isInTemplate = false;
        for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
            IMNode child;
            if (isInTemplate) {
                child = cur.getChild(nodeNames[i]);
                if (child == null) {
                    return false;
                }
                if (child.isMeasurement()) {
                    return i == nodeNames.length - 1;
                }
            } else {
                upperTemplate = cur.getSchemaTemplate() == null ? upperTemplate : cur.getSchemaTemplate();
                child = cur.getChild(nodeNames[i]);
                if (child == null) {
                    if (upperTemplate == null || !cur.isUseTemplate() || upperTemplate.getDirectNode(nodeNames[i]) == null) {
                        return false;
                    }
                    child = upperTemplate.getDirectNode(nodeNames[i]);
                    isInTemplate = true;
                    if (child.isMeasurement()) {
                        return i == nodeNames.length - 1;
                    }
                } else if (child.isMeasurement()) {
                    return i == nodeNames.length - 1;
                }
            }
            cur = child;
        }
        return true;
    }

    @Override
    public Set<PartialPath> getDevices(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        final TreeSet<PartialPath> result = new TreeSet<PartialPath>();
        EntityCollector<Set<PartialPath>> collector = new EntityCollector<Set<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectEntity(IEntityMNode node) {
                result.add(this.getCurrentPartialPath(node));
            }
        };
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        return result;
    }

    @Override
    public Pair<List<ShowDevicesResult>, Integer> getDevices(final ShowDevicesPlan plan) throws MetadataException {
        final ArrayList res = new ArrayList();
        EntityCollector<List<ShowDevicesResult>> collector = new EntityCollector<List<ShowDevicesResult>>((IMNode)this.storageGroupMNode, plan.getPath(), (IMTreeStore)this.store, plan.getLimit(), plan.getOffset()){

            @Override
            protected void collectEntity(IEntityMNode node) {
                PartialPath device = this.getCurrentPartialPath(node);
                if (plan.hasSgCol()) {
                    res.add(new ShowDevicesResult(device.getFullPath(), node.isAligned(), this.getStorageGroupNodeInTraversePath(node).getFullPath()));
                } else {
                    res.add(new ShowDevicesResult(device.getFullPath(), node.isAligned()));
                }
            }
        };
        collector.setPrefixMatch(plan.isPrefixMatch());
        collector.traverse();
        return new Pair(res, (Object)(collector.getCurOffset() + 1));
    }

    @Override
    public Set<PartialPath> getDevicesByTimeseries(PartialPath timeseries) throws MetadataException {
        final HashSet<PartialPath> result = new HashSet<PartialPath>();
        MeasurementCollector<Set<PartialPath>> collector = new MeasurementCollector<Set<PartialPath>>((IMNode)this.storageGroupMNode, timeseries, (IMTreeStore)this.store){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                result.add(this.getCurrentPartialPath(node).getDevicePath());
            }
        };
        collector.traverse();
        return result;
    }

    @Override
    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return (List)this.getMeasurementPathsWithAlias((PartialPath)pathPattern, (int)0, (int)0, (boolean)isPrefixMatch).left;
    }

    @Override
    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern) throws MetadataException {
        return this.getMeasurementPaths(pathPattern, false);
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath pathPattern, int limit, int offset, boolean isPrefixMatch) throws MetadataException {
        final LinkedList result = new LinkedList();
        MeasurementCollector<List<PartialPath>> collector = new MeasurementCollector<List<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store, limit, offset){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                if (this.nodes[this.nodes.length - 1].equals(node.getAlias())) {
                    path.setMeasurementAlias(node.getAlias());
                }
                result.add(path);
            }
        };
        collector.setPrefixMatch(isPrefixMatch);
        collector.traverse();
        offset = collector.getCurOffset() + 1;
        return new Pair(result, (Object)offset);
    }

    public List<MeasurementPath> fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap) throws MetadataException {
        final LinkedList<MeasurementPath> result = new LinkedList<MeasurementPath>();
        MeasurementCollector<List<PartialPath>> collector = new MeasurementCollector<List<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                if (this.nodes[this.nodes.length - 1].equals(node.getAlias())) {
                    path.setMeasurementAlias(node.getAlias());
                }
                result.add(path);
            }
        };
        collector.setTemplateMap(templateMap);
        collector.traverse();
        return result;
    }

    @Override
    public Pair<List<Pair<PartialPath, String[]>>, Integer> getAllMeasurementSchema(ShowTimeSeriesPlan plan, final QueryContext queryContext) throws MetadataException {
        final boolean needLast = plan.isOrderByHeat();
        int limit = needLast ? 0 : plan.getLimit();
        int offset = needLast ? 0 : plan.getOffset();
        MeasurementCollector<List<Pair<PartialPath, String[]>>> collector = new MeasurementCollector<List<Pair<PartialPath, String[]>>>((IMNode)this.storageGroupMNode, plan.getPath(), (IMTreeStore)this.store, limit, offset){

            @Override
            protected void collectMeasurement(IMeasurementMNode node) {
                IMeasurementSchema measurementSchema = node.getSchema();
                String[] tsRow = new String[]{node.getAlias(), this.getStorageGroupNodeInTraversePath(node).getFullPath(), measurementSchema.getType().toString(), measurementSchema.getEncodingType().toString(), measurementSchema.getCompressor().toString(), String.valueOf(node.getOffset()), needLast ? String.valueOf(LastCacheManager.getLastTimeStamp(node, queryContext)) : null};
                Pair temp = new Pair((Object)this.getCurrentPartialPath(node), (Object)tsRow);
                ((List)this.resultSet).add(temp);
            }
        };
        collector.setPrefixMatch(plan.isPrefixMatch());
        collector.setTemplateMap(plan.getRelatedTemplate());
        collector.setResultSet(new LinkedList());
        collector.traverse();
        List result = (List)collector.getResult();
        if (needLast) {
            Stream<Object> stream = result.stream();
            limit = plan.getLimit();
            offset = plan.getOffset();
            stream = stream.sorted(Comparator.comparingLong(p -> Long.parseLong(((String[])p.right)[6])).reversed().thenComparing(p -> (PartialPath)p.left));
            if (limit != 0) {
                stream = stream.skip(offset).limit(limit);
            }
            result = stream.collect(Collectors.toList());
        }
        return new Pair((Object)result, (Object)(collector.getCurOffset() + 1));
    }

    @Override
    public Set<TSchemaNode> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        try {
            MNodeCollector<Set<TSchemaNode>> collector = new MNodeCollector<Set<TSchemaNode>>((IMNode)this.storageGroupMNode, pathPattern.concatNode("*"), (IMTreeStore)this.store){

                @Override
                protected void transferToResult(IMNode node) {
                    ((Set)this.resultSet).add(new TSchemaNode(this.getCurrentPartialPath(node).getFullPath(), node.getMNodeType(false).getNodeType()));
                }
            };
            collector.setResultSet(new TreeSet());
            collector.traverse();
            return (Set)collector.getResult();
        }
        catch (IllegalPathException e) {
            throw new IllegalPathException(pathPattern.getFullPath());
        }
    }

    @Override
    public Set<String> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        try {
            MNodeCollector<Set<String>> collector = new MNodeCollector<Set<String>>((IMNode)this.storageGroupMNode, pathPattern.concatNode("*"), (IMTreeStore)this.store){

                @Override
                protected void transferToResult(IMNode node) {
                    ((Set)this.resultSet).add(node.getName());
                }
            };
            collector.setResultSet(new TreeSet());
            collector.traverse();
            return (Set)collector.getResult();
        }
        catch (IllegalPathException e) {
            throw new IllegalPathException(pathPattern.getFullPath());
        }
    }

    @Override
    public List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch, LocalSchemaProcessor.StorageGroupFilter filter) throws MetadataException {
        MNodeCollector<List<PartialPath>> collector = new MNodeCollector<List<PartialPath>>((IMNode)this.storageGroupMNode, pathPattern, (IMTreeStore)this.store){

            @Override
            protected void transferToResult(IMNode node) {
                ((List)this.resultSet).add(this.getCurrentPartialPath(node));
            }
        };
        collector.setResultSet(new LinkedList());
        collector.setTargetLevel(nodeLevel);
        collector.setPrefixMatch(isPrefixMatch);
        collector.setStorageGroupFilter(filter);
        collector.traverse();
        return (List)collector.getResult();
    }

    @Override
    public int getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        MeasurementCounter counter = new MeasurementCounter(this.storageGroupMNode, pathPattern, this.store);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    public int getAllTimeseriesCount(PartialPath pathPattern, Map<Integer, Template> templateMap, boolean isPrefixMatch) throws MetadataException {
        MeasurementCounter counter = new MeasurementCounter(this.storageGroupMNode, pathPattern, this.store);
        counter.setPrefixMatch(isPrefixMatch);
        counter.setTemplateMap(templateMap);
        counter.traverse();
        return counter.getCount();
    }

    @Override
    public int getAllTimeseriesCount(PartialPath pathPattern) throws MetadataException {
        return this.getAllTimeseriesCount(pathPattern, false);
    }

    @Override
    public int getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch, List<String> timeseries, boolean hasTag) throws MetadataException {
        MeasurementCounter counter = new MeasurementCounter(this.storageGroupMNode, pathPattern, this.store, timeseries, hasTag);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    @Override
    public int getDevicesNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        EntityCounter counter = new EntityCounter(this.storageGroupMNode, pathPattern, this.store);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    @Override
    public int getDevicesNum(PartialPath pathPattern) throws MetadataException {
        return this.getDevicesNum(pathPattern, false);
    }

    @Override
    public int getNodesCountInGivenLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        MNodeLevelCounter counter = new MNodeLevelCounter(this.storageGroupMNode, pathPattern, this.store, level);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getCount();
    }

    @Override
    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        MeasurementGroupByLevelCounter counter = new MeasurementGroupByLevelCounter(this.storageGroupMNode, pathPattern, this.store, level);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getResult();
    }

    @Override
    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch, List<String> timeseries, boolean hasTag) throws MetadataException {
        MeasurementGroupByLevelCounter counter = new MeasurementGroupByLevelCounter(this.storageGroupMNode, pathPattern, this.store, level, timeseries, hasTag);
        counter.setPrefixMatch(isPrefixMatch);
        counter.traverse();
        return counter.getResult();
    }

    @Override
    public IMNode getNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        IMNode cur = this.storageGroupMNode;
        Template upperTemplate = cur.getSchemaTemplate();
        boolean isInTemplate = false;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            IMNode next;
            if (isInTemplate) {
                next = cur.getChild(nodes[i]);
                if (next == null) {
                    throw new PathNotExistException(path.getFullPath(), true);
                }
                if (next.isMeasurement()) {
                    if (i == nodes.length - 1) {
                        return next;
                    }
                    throw new PathNotExistException(path.getFullPath(), true);
                }
            } else {
                if (cur.getSchemaTemplate() != null) {
                    upperTemplate = cur.getSchemaTemplate();
                }
                if ((next = cur.getChild(nodes[i])) == null) {
                    if (upperTemplate == null || !cur.isUseTemplate() || upperTemplate.getDirectNode(nodes[i]) == null) {
                        throw new PathNotExistException(path.getFullPath(), true);
                    }
                    next = upperTemplate.getDirectNode(nodes[i]);
                    isInTemplate = true;
                } else if (next.isMeasurement()) {
                    if (i == nodes.length - 1) {
                        return next;
                    }
                    throw new PathNotExistException(path.getFullPath(), true);
                }
            }
            cur = next;
        }
        return cur;
    }

    @Override
    public IMeasurementMNode getMeasurementMNode(PartialPath path) throws MetadataException {
        IMNode node = this.getNodeByPath(path);
        if (node.isMeasurement()) {
            return node.getAsMeasurementMNode();
        }
        throw new MNodeTypeMismatchException(path.getFullPath(), 2);
    }

    @Override
    public List<IMeasurementMNode> getAllMeasurementMNode() throws MetadataException {
        IStorageGroupMNode cur = this.storageGroupMNode;
        LinkedList<IMeasurementMNode> leafMNodes = new LinkedList<IMeasurementMNode>();
        LinkedList<IMNode> queue = new LinkedList<IMNode>();
        queue.add(cur);
        while (!queue.isEmpty()) {
            IMNode node = (IMNode)queue.poll();
            IMNodeIterator iterator = this.store.getChildrenIterator(node);
            while (iterator.hasNext()) {
                IMNode child = (IMNode)iterator.next();
                if (child.isMeasurement()) {
                    leafMNodes.add(child.getAsMeasurementMNode());
                    continue;
                }
                queue.add(child);
            }
        }
        return leafMNodes;
    }

    @Override
    public void checkTemplateOnPath(PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IMNode cur = this.storageGroupMNode;
        if (cur.getSchemaTemplate() != null) {
            throw new MetadataException("Template already exists on " + cur.getFullPath());
        }
        for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
            IMNode child = cur.getChild(nodeNames[i]);
            if (child == null) {
                return;
            }
            cur = child;
            if (cur.getSchemaTemplate() != null) {
                throw new MetadataException("Template already exists on " + cur.getFullPath());
            }
            if (!cur.isMeasurement()) continue;
            return;
        }
        this.checkTemplateOnSubtree(cur);
    }

    @Override
    public IMNode checkTemplateAlignmentWithMountedNode(IMNode mountedNode, Template template) throws MetadataException {
        boolean hasDirectMeasurement = false;
        for (IMNode child : template.getDirectNodes()) {
            if (!child.isMeasurement()) continue;
            hasDirectMeasurement = true;
        }
        if (!hasDirectMeasurement) {
            return mountedNode;
        }
        if (!mountedNode.isEntity()) {
            return this.setToEntity(mountedNode);
        }
        IMNodeIterator iterator = this.store.getChildrenIterator(mountedNode);
        while (iterator.hasNext()) {
            IMNode child = (IMNode)iterator.next();
            if (!child.isMeasurement()) continue;
            if (template.isDirectAligned() != mountedNode.getAsEntityMNode().isAligned()) {
                throw new MetadataException("Template and mounted node has different alignment: " + template.getName() + mountedNode.getFullPath());
            }
            return mountedNode;
        }
        mountedNode.getAsEntityMNode().setAligned(template.isDirectAligned());
        return mountedNode;
    }

    private void checkTemplateOnSubtree(IMNode node) throws MetadataException {
        if (node.isMeasurement()) {
            return;
        }
        IMNodeIterator iterator = this.store.getChildrenIterator(node);
        while (iterator.hasNext()) {
            IMNode child = (IMNode)iterator.next();
            if (child.isMeasurement()) continue;
            if (child.getSchemaTemplate() != null) {
                throw new MetadataException("Template already exists on " + child.getFullPath());
            }
            this.checkTemplateOnSubtree(child);
        }
    }

    @Override
    public void checkIsTemplateCompatibleWithChild(IMNode node, Template template) throws MetadataException {
        for (String measurementPath : template.getSchemaMap().keySet()) {
            String directNodeName = PathUtils.splitPathToDetachedNodes((String)measurementPath)[0];
            if (!node.hasChild(directNodeName)) continue;
            throw new MetadataException("Node name " + directNodeName + " in template has conflict with node's child " + node.getFullPath() + "." + directNodeName);
        }
    }

    @Override
    public void checkTemplateInUseOnLowerNode(IMNode node) throws MetadataException {
        if (node.isMeasurement()) {
            return;
        }
        IMNodeIterator iterator = this.store.getChildrenIterator(node);
        while (iterator.hasNext()) {
            IMNode child = (IMNode)iterator.next();
            if (child.isMeasurement()) continue;
            if (child.isUseTemplate()) {
                throw new TemplateIsInUseException(child.getFullPath());
            }
            this.checkTemplateInUseOnLowerNode(child);
        }
    }

    @Override
    public boolean isTemplateAppendable(Template tarTemplate, List<String> appendMeasurements) throws MetadataException {
        List<String> setPaths = this.getPathsSetOnTemplate(tarTemplate.getName());
        if (setPaths.size() == 0) {
            return true;
        }
        ArrayDeque<IMNode> setNodes = new ArrayDeque<IMNode>();
        for (String string : setPaths) {
            setNodes.add(this.getNodeByPath(new PartialPath(string)));
        }
        HashSet<String> overlapSet = new HashSet<String>();
        for (String path : appendMeasurements) {
            overlapSet.add(PathUtils.splitPathToDetachedNodes((String)path)[0]);
        }
        while (setNodes.size() != 0) {
            IMNode iMNode = (IMNode)setNodes.pop();
            IMNodeIterator iterator = this.store.getChildrenIterator(iMNode);
            while (iterator.hasNext()) {
                IMNode child = (IMNode)iterator.next();
                if (overlapSet.contains(child.getName())) {
                    return false;
                }
                if (child.isMeasurement()) continue;
                setNodes.push(child);
            }
        }
        return true;
    }

    @Override
    public boolean isPathExistsWithinTemplate(PartialPath path) throws MetadataException {
        String[] pathNodes = path.getNodes();
        IMNode cur = this.storageGroupMNode;
        Template upperTemplate = cur.getUpperTemplate();
        for (int i = this.levelOfSG + 1; i < pathNodes.length; ++i) {
            IMNode child = cur.getChild(pathNodes[i]);
            if (child != null) {
                cur = child;
                if (cur.isMeasurement()) {
                    return false;
                }
            } else {
                if (upperTemplate != null) {
                    String suffixPath = new PartialPath(Arrays.copyOfRange(pathNodes, i, pathNodes.length)).toString();
                    return upperTemplate.hasSchema(suffixPath);
                }
                return false;
            }
            upperTemplate = cur.getSchemaTemplate() == null ? upperTemplate : cur.getSchemaTemplate();
        }
        return false;
    }

    @Override
    public int getMountedNodeIndexOnMeasurementPath(PartialPath devicePath, String[] measurements) throws MetadataException {
        int index;
        String[] nodes = devicePath.getNodes();
        IMNode cur = this.storageGroupMNode;
        Template upperTemplate = cur.getSchemaTemplate();
        boolean attemptToUseTemplate = false;
        for (index = this.levelOfSG + 1; index < nodes.length; ++index) {
            upperTemplate = cur.getSchemaTemplate() != null ? cur.getSchemaTemplate() : upperTemplate;
            IMNode child = cur.getChild(nodes[index]);
            if (child == null) {
                if (upperTemplate == null) {
                    return nodes.length;
                }
                attemptToUseTemplate = true;
                break;
            }
            cur = child;
        }
        if (!attemptToUseTemplate) {
            return nodes.length;
        }
        while (index < nodes.length) {
            int fullPathLength = nodes.length - index + 1;
            CharSequence[] suffixNodes = new String[fullPathLength];
            System.arraycopy(nodes, index, suffixNodes, 0, nodes.length - index);
            boolean hasAllMeasurements = true;
            String[] stringArray = measurements;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String measurement;
                suffixNodes[fullPathLength - 1] = measurement = stringArray[i];
                String suffixPath = String.join((CharSequence)String.valueOf('.'), suffixNodes);
                if (upperTemplate.hasSchema(suffixPath)) continue;
                if (upperTemplate.getDirectNode(nodes[index]) != null) {
                    throw new TemplateImcompatibeException(devicePath.concatNode(measurement).getFullPath(), upperTemplate.getName(), nodes[index]);
                }
                hasAllMeasurements = false;
            }
            if (hasAllMeasurements) {
                return index - 1;
            }
            ++index;
        }
        return nodes.length;
    }

    @Override
    public List<String> getPathsSetOnTemplate(final String templateName) throws MetadataException {
        final ArrayList<String> resSet = new ArrayList<String>();
        CollectorTraverser<Set<String>> setTemplatePaths = new CollectorTraverser<Set<String>>((IMNode)this.storageGroupMNode, new PartialPath(MetadataConstant.ALL_RESULT_NODES), (IMTreeStore)this.store){

            @Override
            protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
                return false;
            }

            @Override
            protected boolean processFullMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
                if (!node.getPartialPath().equals((Object)this.getCurrentPartialPath(node)) || node.isMeasurement()) {
                    return true;
                }
                if (node.getSchemaTemplate() != null) {
                    if (templateName.equals("*") || templateName.equals(node.getUpperTemplate().getName())) {
                        resSet.add(node.getFullPath());
                    }
                    return true;
                }
                return false;
            }
        };
        setTemplatePaths.traverse();
        return resSet;
    }

    @Override
    public List<String> getPathsUsingTemplate(final String templateName) throws MetadataException {
        final ArrayList<String> result = new ArrayList<String>();
        CollectorTraverser<Set<String>> usingTemplatePaths = new CollectorTraverser<Set<String>>((IMNode)this.storageGroupMNode, new PartialPath(MetadataConstant.ALL_RESULT_NODES), (IMTreeStore)this.store){

            @Override
            protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
                return false;
            }

            @Override
            protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
                if (!node.getPartialPath().equals((Object)this.getCurrentPartialPath(node)) || node.isMeasurement()) {
                    return true;
                }
                if (node.getUpperTemplate() != null) {
                    if (!templateName.equals("*") && !templateName.equals(node.getUpperTemplate().getName())) {
                        return true;
                    }
                    if (node.isUseTemplate()) {
                        result.add(node.getFullPath());
                    }
                }
                return false;
            }
        };
        usingTemplatePaths.traverse();
        return result;
    }

    @Override
    public String getTemplateOnPath(PartialPath path) throws MetadataException {
        String[] pathNodes = path.getNodes();
        IMNode cur = this.storageGroupMNode;
        if (cur.getSchemaTemplate() != null) {
            return cur.getSchemaTemplate().getName();
        }
        for (int i = this.levelOfSG + 1; i < pathNodes.length; ++i) {
            IMNode child = cur.getChild(pathNodes[i]);
            if (child == null) {
                return null;
            }
            cur = child;
            if (cur.isMeasurement()) {
                return null;
            }
            if (cur.getSchemaTemplate() == null) continue;
            return cur.getSchemaTemplate().getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTemplate(PartialPath activatePath, int templateSetLevel, Template template) throws MetadataException {
        IEntityMNode entityMNode;
        if (templateSetLevel <= this.levelOfSG) {
            IMNode ancestor = this.storageGroupMNode;
            for (int i = this.levelOfSG; i > templateSetLevel; --i) {
                ancestor = ancestor.getParent();
            }
            ancestor.setSchemaTemplateId(template.getId());
        }
        String[] nodes = activatePath.getNodes();
        IMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
            if (i != templateSetLevel) continue;
            cur.setSchemaTemplateId(template.getId());
        }
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            for (String measurement : template.getSchemaMap().keySet()) {
                if (!cur.hasChild(measurement)) continue;
                throw new TemplateImcompatibeException(activatePath.concatNode(measurement).getFullPath(), template.getName());
            }
            if (cur.isUseTemplate()) {
                throw new TemplateIsInUseException(cur.getFullPath());
            }
            if (cur.isEntity()) {
                entityMNode = cur.getAsEntityMNode();
            } else {
                entityMNode = this.store.setToEntity(cur);
                if (entityMNode.isStorageGroup()) {
                    this.storageGroupMNode = entityMNode.getAsStorageGroupMNode();
                }
            }
        }
        if (!entityMNode.isAligned()) {
            entityMNode.setAligned(template.isDirectAligned());
        }
        entityMNode.setUseTemplate(true);
    }

    public void activateTemplateWithoutCheck(PartialPath activatePath, int templateSetLevel, int templateId, boolean isAligned) {
        IEntityMNode entityMNode;
        String[] nodes = activatePath.getNodes();
        IMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
            if (i != templateSetLevel) continue;
            cur.setSchemaTemplateId(templateId);
        }
        if (cur.isEntity()) {
            entityMNode = cur.getAsEntityMNode();
        } else {
            entityMNode = this.store.setToEntity(cur);
            if (entityMNode.isStorageGroup()) {
                this.storageGroupMNode = entityMNode.getAsStorageGroupMNode();
            }
        }
        if (!entityMNode.isAligned()) {
            entityMNode.setAligned(isAligned);
        }
        entityMNode.setUseTemplate(true);
    }

    public List<String> getPathsUsingTemplate(final int templateId) throws MetadataException {
        final ArrayList<String> result = new ArrayList<String>();
        CollectorTraverser<Set<String>> usingTemplatePaths = new CollectorTraverser<Set<String>>((IMNode)this.storageGroupMNode, new PartialPath(MetadataConstant.ALL_RESULT_NODES), (IMTreeStore)this.store){

            @Override
            protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
                return false;
            }

            @Override
            protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
                if (node.isMeasurement()) {
                    return true;
                }
                if (node.getSchemaTemplateId() != -1 && templateId != -2 && node.getSchemaTemplateId() != templateId) {
                    return true;
                }
                if (node.isUseTemplate()) {
                    result.add(node.getFullPath());
                }
                return false;
            }
        };
        usingTemplatePaths.traverse();
        return result;
    }
}

