/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable.entry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DiskSchemaEntry {
    public static final String TOMBSTONE = "tombstone_record";
    public String deviceID;
    public String seriesKey;
    public String measurementName;
    public byte type;
    public byte encoding;
    public byte compressor;
    public boolean isAligned;
    public transient long entrySize;

    private DiskSchemaEntry() {
    }

    public DiskSchemaEntry(String deviceID, String seriesKey, String measurementName, byte type, byte encoding, byte compressor, boolean isAligned) {
        this.deviceID = deviceID;
        this.seriesKey = seriesKey;
        this.measurementName = measurementName;
        this.type = type;
        this.encoding = encoding;
        this.compressor = compressor;
        this.isAligned = isAligned;
    }

    public int serialize(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write((String)this.deviceID, (OutputStream)outputStream);
        byteLen += ReadWriteIOUtils.write((String)this.seriesKey, (OutputStream)outputStream);
        byteLen += ReadWriteIOUtils.write((String)this.measurementName, (OutputStream)outputStream);
        byteLen += ReadWriteIOUtils.write((byte)this.type, (OutputStream)outputStream);
        byteLen += ReadWriteIOUtils.write((byte)this.encoding, (OutputStream)outputStream);
        byteLen += ReadWriteIOUtils.write((byte)this.compressor, (OutputStream)outputStream);
        byteLen += ReadWriteIOUtils.write((Boolean)this.isAligned, (OutputStream)outputStream);
        byteLen += ReadWriteIOUtils.write((int)byteLen, (OutputStream)outputStream);
        this.entrySize = byteLen;
        return byteLen;
    }

    public static DiskSchemaEntry deserialize(InputStream inputStream) throws IOException {
        DiskSchemaEntry res = new DiskSchemaEntry();
        res.deviceID = ReadWriteIOUtils.readString((InputStream)inputStream);
        res.seriesKey = ReadWriteIOUtils.readString((InputStream)inputStream);
        res.measurementName = ReadWriteIOUtils.readString((InputStream)inputStream);
        res.type = ReadWriteIOUtils.readByte((InputStream)inputStream);
        res.encoding = ReadWriteIOUtils.readByte((InputStream)inputStream);
        res.compressor = ReadWriteIOUtils.readByte((InputStream)inputStream);
        res.isAligned = ReadWriteIOUtils.readBool((InputStream)inputStream);
        res.entrySize = ReadWriteIOUtils.readInt((InputStream)inputStream);
        res.entrySize += 4L;
        if (DiskSchemaEntry.isTombstone(res.deviceID).booleanValue()) {
            res.deviceID = TOMBSTONE;
        }
        return res;
    }

    private static Boolean isTombstone(String deviceID) {
        int length = deviceID.getBytes().length;
        byte[] bytes = new byte[length];
        return deviceID.equals(new String(bytes, 0, length));
    }

    public String toString() {
        return "DiskSchemaEntry{deviceID='" + this.deviceID + '\'' + ", seriesKey='" + this.seriesKey + '\'' + ", type=" + this.type + ", encoding=" + this.encoding + ", compressor=" + this.compressor + '}';
    }
}

