/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.engine.memtable.WritableMemChunk;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class WritableMemChunkGroup
implements IWritableMemChunkGroup {
    private Map<String, IWritableMemChunk> memChunkMap = new HashMap<String, IWritableMemChunk>();

    @Override
    public void writeValues(long[] times, Object[] columns, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end) {
        int emptyColumnCount = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) {
                ++emptyColumnCount;
                continue;
            }
            IWritableMemChunk memChunk = this.createMemChunkIfNotExistAndGet(schemaList.get(i - emptyColumnCount));
            memChunk.write(times, columns[i], bitMaps == null ? null : bitMaps[i], schemaList.get(i - emptyColumnCount).getType(), start, end);
        }
    }

    private IWritableMemChunk createMemChunkIfNotExistAndGet(IMeasurementSchema schema) {
        return this.memChunkMap.computeIfAbsent(schema.getMeasurementId(), k -> new WritableMemChunk(schema));
    }

    @Override
    public void release() {
        for (IWritableMemChunk memChunk : this.memChunkMap.values()) {
            memChunk.release();
        }
    }

    @Override
    public long count() {
        long count = 0L;
        for (IWritableMemChunk memChunk : this.memChunkMap.values()) {
            count += memChunk.count();
        }
        return count;
    }

    @Override
    public boolean contains(String measurement) {
        return this.memChunkMap.containsKey(measurement);
    }

    @Override
    public void write(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        int emptyColumnCount = 0;
        for (int i = 0; i < objectValue.length; ++i) {
            if (objectValue[i] == null) {
                ++emptyColumnCount;
                continue;
            }
            IWritableMemChunk memChunk = this.createMemChunkIfNotExistAndGet(schemaList.get(i - emptyColumnCount));
            memChunk.write(insertTime, objectValue[i]);
        }
    }

    @Override
    public Map<String, IWritableMemChunk> getMemChunkMap() {
        return this.memChunkMap;
    }

    @Override
    public int delete(PartialPath originalPath, PartialPath devicePath, long startTimestamp, long endTimestamp) {
        int deletedPointsNumber = 0;
        Iterator<Map.Entry<String, IWritableMemChunk>> iter = this.memChunkMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, IWritableMemChunk> entry = iter.next();
            IWritableMemChunk chunk = entry.getValue();
            PartialPath fullPath = devicePath.concatNode(entry.getKey());
            if (!originalPath.matchFullPath(fullPath)) continue;
            if (startTimestamp == Long.MIN_VALUE && endTimestamp == Long.MAX_VALUE) {
                iter.remove();
            }
            deletedPointsNumber += chunk.delete(startTimestamp, endTimestamp);
        }
        return deletedPointsNumber;
    }

    @Override
    public long getCurrentTVListSize(String measurement) {
        return this.memChunkMap.get(measurement).getTVList().rowCount();
    }

    @Override
    public int serializedSize() {
        int size = 0;
        size += 4;
        for (Map.Entry<String, IWritableMemChunk> entry : this.memChunkMap.entrySet()) {
            size += ReadWriteIOUtils.sizeToWrite((String)entry.getKey());
            size += entry.getValue().serializedSize();
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        buffer.putInt(this.memChunkMap.size());
        for (Map.Entry<String, IWritableMemChunk> entry : this.memChunkMap.entrySet()) {
            WALWriteUtils.write(entry.getKey(), buffer);
            IWritableMemChunk memChunk = entry.getValue();
            memChunk.serializeToWAL(buffer);
        }
    }

    public static WritableMemChunkGroup deserialize(DataInputStream stream) throws IOException {
        WritableMemChunkGroup memChunkGroup = new WritableMemChunkGroup();
        int memChunkMapSize = stream.readInt();
        for (int i = 0; i < memChunkMapSize; ++i) {
            String measurement = ReadWriteIOUtils.readString((InputStream)stream);
            WritableMemChunk memChunk = WritableMemChunk.deserialize(stream);
            memChunkGroup.memChunkMap.put(measurement, memChunk);
        }
        return memChunkGroup;
    }
}

