/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cq;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cq.ContinuousQueryTask;
import org.apache.iotdb.db.rescon.AbstractPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousQueryTaskPoolManager
extends AbstractPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContinuousQueryTaskPoolManager.class);
    private static final int CONTINUOUS_QUERY_THREAD_NUM = IoTDBDescriptor.getInstance().getConfig().getContinuousQueryThreadNum();

    private ContinuousQueryTaskPoolManager() {
        LOGGER.info("ContinuousQueryTaskPoolManager is initializing, thread number: {}", (Object)CONTINUOUS_QUERY_THREAD_NUM);
        this.pool = new ThreadPoolExecutor(CONTINUOUS_QUERY_THREAD_NUM, CONTINUOUS_QUERY_THREAD_NUM, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(IoTDBDescriptor.getInstance().getConfig().getMaxPendingContinuousQueryTasks()), (ThreadFactory)new IoTThreadFactory(ThreadName.CONTINUOUS_QUERY_SERVICE.getName()));
    }

    public void submit(ContinuousQueryTask task) {
        try {
            super.submit((Runnable)((Object)task));
        }
        catch (RejectedExecutionException e) {
            task.onRejection();
        }
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getName() {
        return "continuous query task";
    }

    @Override
    public void start() {
        if (this.pool != null) {
            return;
        }
        this.pool = new ThreadPoolExecutor(CONTINUOUS_QUERY_THREAD_NUM, CONTINUOUS_QUERY_THREAD_NUM, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(IoTDBDescriptor.getInstance().getConfig().getMaxPendingContinuousQueryTasks()), (ThreadFactory)new IoTThreadFactory(ThreadName.CONTINUOUS_QUERY_SERVICE.getName()));
    }

    public static ContinuousQueryTaskPoolManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final ContinuousQueryTaskPoolManager INSTANCE = new ContinuousQueryTaskPoolManager();

        private InstanceHolder() {
        }
    }
}

