/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.task;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.constant.CrossCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.cross.utils.AbstractCompactionEstimator;
import org.apache.iotdb.db.engine.compaction.cross.utils.ReadPointCrossCompactionEstimator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.utils.Pair;

public interface ICompactionSelector {
    default public List<List<TsFileResource>> selectInnerSpaceTask(List<TsFileResource> resources) {
        throw new RuntimeException("This kind of selector cannot be used to select inner space task");
    }

    default public List<Pair<List<TsFileResource>, List<TsFileResource>>> selectCrossSpaceTask(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        throw new RuntimeException("This kind of selector cannot be used to select cross space task");
    }

    default public List<Long> getCompactionMemoryCost() {
        return Collections.emptyList();
    }

    public static AbstractCompactionEstimator getCompactionEstimator(CrossCompactionPerformer compactionPerformer, boolean isInnerSpace) {
        switch (compactionPerformer) {
            case READ_POINT: {
                if (isInnerSpace) break;
                return new ReadPointCrossCompactionEstimator();
            }
        }
        throw new RuntimeException("Corresponding memory estimator for " + (Object)((Object)compactionPerformer) + " performer of " + (isInnerSpace ? "inner" : "cross") + " space compaction is not existed.");
    }
}

