/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.wal.utils.TsFileUtilsForRecoverTest;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnsealedTsFileRecoverPerformerTest {
    private static final String SG_NAME = "root.recover_sg";
    private static final String DEVICE1_NAME = "root.recover_sg".concat(".d1");
    private static final String DEVICE2_NAME = "root.recover_sg".concat(".d2");
    private static final String FILE_NAME = TsFileUtilsForRecoverTest.getTestTsFilePath("root.recover_sg", 0L, 0L, 1L);
    private TsFileResource tsFileResource;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(new File(FILE_NAME).getParent());
        EnvironmentUtils.envSetUp();
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(SG_NAME));
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE1_NAME.concat(".s1")), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE1_NAME.concat(".s2")), TSDataType.INT64, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE2_NAME.concat(".s1")), TSDataType.FLOAT, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE2_NAME.concat(".s2")), TSDataType.DOUBLE, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
    }

    @After
    public void tearDown() throws Exception {
        if (this.tsFileResource != null) {
            this.tsFileResource.close();
        }
        EnvironmentUtils.cleanDir(new File(FILE_NAME).getParent());
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testRedoInsertPlan() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCrashedFile(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".resource")).exists());
        long time = 4L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.DOUBLE};
        String[] columns = new String[]{"1", "1.0"};
        InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath(DEVICE2_NAME), time, new String[]{"s1", "s2"}, dataTypes, columns);
        int fakeMemTableId = 1;
        WALInfoEntry walEntry = new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)insertRowPlan);
        this.tsFileResource = new TsFileResource(file);
        try (UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileResource, true, null, performer -> Assert.assertFalse((boolean)performer.canWrite()));){
            recoverPerformer.startRecovery();
            Assert.assertTrue((boolean)recoverPerformer.hasCrashed());
            Assert.assertTrue((boolean)recoverPerformer.canWrite());
            Assert.assertEquals((long)3L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
            recoverPerformer.redoLog((WALEntry)walEntry);
            recoverPerformer.endRecovery();
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2"));
        Assert.assertNotNull((Object)chunkMetadataList);
        Assert.assertEquals((long)2L, (long)chunkMetadataList.size());
        Chunk chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(0));
        Assert.assertEquals((long)3L, (long)chunk.getChunkStatistic().getEndTime());
        chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(1));
        Assert.assertEquals((long)4L, (long)chunk.getChunkStatistic().getEndTime());
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)4L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
    }

    @Test
    public void testRedoDeletePlan() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCrashedFile(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".resource")).exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".mods")).exists());
        DeletePlan deletePlan = new DeletePlan(Long.MIN_VALUE, Long.MAX_VALUE, new PartialPath(DEVICE2_NAME));
        int fakeMemTableId = 1;
        WALInfoEntry walEntry = new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)deletePlan);
        this.tsFileResource = new TsFileResource(file);
        try (UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileResource, true, null, performer -> Assert.assertFalse((boolean)performer.canWrite()));){
            recoverPerformer.startRecovery();
            Assert.assertTrue((boolean)recoverPerformer.hasCrashed());
            Assert.assertTrue((boolean)recoverPerformer.canWrite());
            Assert.assertEquals((long)3L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
            recoverPerformer.redoLog((WALEntry)walEntry);
            recoverPerformer.endRecovery();
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2"));
        Assert.assertNotNull((Object)chunkMetadataList);
        Assert.assertEquals((long)1L, (long)chunkMetadataList.size());
        Chunk chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(0));
        Assert.assertEquals((long)3L, (long)chunk.getChunkStatistic().getEndTime());
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".mods")).exists());
    }

    private void generateCrashedFile(File tsFile) throws IOException, WriteProcessException {
        long truncateSize;
        try (TsFileWriter writer = new TsFileWriter(tsFile);){
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s1", TSDataType.FLOAT, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s2", TSDataType.DOUBLE, TSEncoding.RLE));
            writer.write(new TSRecord(1L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 1)).addTuple((DataPoint)new LongDataPoint("s2", 1L)));
            writer.write(new TSRecord(2L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 2)).addTuple((DataPoint)new LongDataPoint("s2", 2L)));
            writer.write(new TSRecord(3L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 3.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 3.0)));
            writer.flushAllChunkGroups();
            try (FileChannel channel = new FileInputStream(tsFile).getChannel();){
                truncateSize = channel.size();
            }
            writer.write(new TSRecord(4L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 4.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 4.0)));
            writer.flushAllChunkGroups();
            channel = new FileInputStream(tsFile).getChannel();
            try {
                truncateSize = (truncateSize + channel.size()) / 2L;
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
        }
        try (FileChannel channel = new FileOutputStream(tsFile, true).getChannel();){
            channel.truncate(truncateSize);
        }
    }

    @Test
    public void testRecoverNullInsertRowPlan() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCrashedFile(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".resource")).exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".mods")).exists());
        long time = 4L;
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId("plannode 1"), new PartialPath(DEVICE2_NAME), false, new String[]{"s1"}, new TSDataType[]{TSDataType.INT64}, time, (Object[])new Integer[]{1}, false);
        insertRowNode.markFailedMeasurement(0, new Exception());
        time = 5L;
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId("plannode 2"), new PartialPath(DEVICE2_NAME), false, new String[]{"s1"}, new TSDataType[]{TSDataType.INT64}, new long[]{time}, null, (Object[])new Integer[]{1}, 1);
        insertTabletNode.markFailedMeasurement(0, new Exception());
        int fakeMemTableId = 1;
        WALInfoEntry walEntry1 = new WALInfoEntry((long)fakeMemTableId++, (WALEntryValue)insertRowNode);
        WALInfoEntry walEntry2 = new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)insertTabletNode);
        this.tsFileResource = new TsFileResource(file);
        try (UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileResource, true, null, performer -> Assert.assertFalse((boolean)performer.canWrite()));){
            recoverPerformer.startRecovery();
            Assert.assertTrue((boolean)recoverPerformer.hasCrashed());
            Assert.assertTrue((boolean)recoverPerformer.canWrite());
            recoverPerformer.redoLog((WALEntry)walEntry1);
            recoverPerformer.redoLog((WALEntry)walEntry2);
            recoverPerformer.endRecovery();
        }
    }
}

