/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.wal.buffer.IWALBuffer;
import org.apache.iotdb.db.wal.buffer.WALBuffer;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.wal.checkpoint.CheckpointManager;
import org.apache.iotdb.db.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.wal.recover.WALRecoverManager;
import org.apache.iotdb.db.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.wal.utils.TsFileUtilsForRecoverTest;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.db.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.wal.utils.listener.WALRecoverListener;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WALRecoverManagerTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String SG_NAME = "root.recover_sg";
    private static final String DEVICE1_NAME = "root.recover_sg".concat(".d1");
    private static final String DEVICE2_NAME = "root.recover_sg".concat(".d2");
    private static final String FILE_WITH_WAL_NAME = TsFileUtilsForRecoverTest.getTestTsFilePath("root.recover_sg", 0L, 0L, 1L);
    private static final String FILE_WITHOUT_WAL_NAME = TsFileUtilsForRecoverTest.getTestTsFilePath("root.recover_sg", 0L, 1L, 1L);
    private static final String WAL_NODE_IDENTIFIER = String.valueOf(Integer.MAX_VALUE);
    private static final String WAL_NODE_FOLDER = config.getWalDirs()[0].concat(File.separator + WAL_NODE_IDENTIFIER);
    private static final WALRecoverManager recoverManager = WALRecoverManager.getInstance();
    private WALMode prevMode;
    private IWALBuffer walBuffer;
    private CheckpointManager checkpointManager;
    private TsFileResource tsFileWithWALResource;
    private TsFileResource tsFileWithoutWALResource;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(new File(FILE_WITH_WAL_NAME).getParent());
        EnvironmentUtils.envSetUp();
        this.prevMode = config.getWalMode();
        config.setWalMode(WALMode.SYNC);
        this.walBuffer = new WALBuffer(WAL_NODE_IDENTIFIER, WAL_NODE_FOLDER);
        this.checkpointManager = new CheckpointManager(WAL_NODE_IDENTIFIER, WAL_NODE_FOLDER);
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(SG_NAME));
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE1_NAME.concat(".s1")), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE1_NAME.concat(".s2")), TSDataType.INT64, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE2_NAME.concat(".s1")), TSDataType.FLOAT, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.schemaProcessor.createTimeseries(new PartialPath(DEVICE2_NAME.concat(".s2")), TSDataType.DOUBLE, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
    }

    @After
    public void tearDown() throws Exception {
        if (this.tsFileWithWALResource != null) {
            this.tsFileWithWALResource.close();
        }
        if (this.tsFileWithoutWALResource != null) {
            this.tsFileWithoutWALResource.close();
        }
        this.checkpointManager.close();
        this.walBuffer.close();
        config.setWalMode(this.prevMode);
        EnvironmentUtils.cleanDir(new File(FILE_WITH_WAL_NAME).getParent());
        EnvironmentUtils.cleanDir(new File(FILE_WITHOUT_WAL_NAME).getParent());
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testNormalProcedure() throws Exception {
        this.prepareCheckpointAndWALFileForNormal();
        WALRecoverManager.getInstance().clear();
        this.recoverAndCheck();
    }

    private void prepareCheckpointAndWALFileForNormal() throws MetadataException, ExecutionException, InterruptedException {
        int threadsNum = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        long firstWALVersionId = this.walBuffer.getCurrentWALFileVersion();
        for (int i = 0; i < threadsNum; ++i) {
            PrimitiveMemTable primitiveMemTable = new PrimitiveMemTable();
            long memTableId = primitiveMemTable.getMemTableId();
            Callable<Void> writeTask = () -> this.lambda$prepareCheckpointAndWALFileForNormal$0((IMemTable)primitiveMemTable, firstWALVersionId, memTableId);
            Future<Void> future = executorService.submit(writeTask);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        while (!this.walBuffer.isAllWALEntriesConsumed()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        long firstValidVersionId = this.walBuffer.getCurrentWALFileVersion();
        PrimitiveMemTable targetMemTable = new PrimitiveMemTable();
        WALInfoEntry walEntry = new WALInfoEntry(targetMemTable.getMemTableId(), (WALEntryValue)this.getInsertRowPlan(DEVICE2_NAME, 4L), true);
        this.walBuffer.write((WALEntry)walEntry);
        walEntry.getWalFlushListener().waitForResult();
        this.checkpointManager.makeCreateMemTableCP(new MemTableInfo((IMemTable)targetMemTable, FILE_WITH_WAL_NAME, firstValidVersionId));
    }

    @Test
    public void testMemTableSnapshot() throws Exception {
        this.prepareCheckpointAndWALFileForSnapshot();
        WALRecoverManager.getInstance().clear();
        this.recoverAndCheck();
    }

    private void prepareCheckpointAndWALFileForSnapshot() throws MetadataException, ExecutionException, InterruptedException {
        int threadsNum = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        long firstWALVersionId = this.walBuffer.getCurrentWALFileVersion();
        for (int i = 0; i < threadsNum; ++i) {
            PrimitiveMemTable primitiveMemTable = new PrimitiveMemTable();
            long memTableId = primitiveMemTable.getMemTableId();
            Callable<Void> writeTask = () -> this.lambda$prepareCheckpointAndWALFileForSnapshot$1((IMemTable)primitiveMemTable, firstWALVersionId, memTableId);
            Future<Void> future = executorService.submit(writeTask);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        while (!this.walBuffer.isAllWALEntriesConsumed()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        long firstValidVersionId = this.walBuffer.getCurrentWALFileVersion();
        PrimitiveMemTable targetMemTable = new PrimitiveMemTable();
        InsertRowPlan insertRowPlan = this.getInsertRowPlan(DEVICE2_NAME, 4L);
        targetMemTable.insert(insertRowPlan);
        WALInfoEntry walEntry = new WALInfoEntry(targetMemTable.getMemTableId(), (WALEntryValue)insertRowPlan, true);
        this.walBuffer.write((WALEntry)walEntry);
        walEntry.getWalFlushListener().waitForResult();
        walEntry = new WALInfoEntry(targetMemTable.getMemTableId(), (WALEntryValue)targetMemTable, true);
        this.walBuffer.write((WALEntry)walEntry);
        walEntry.getWalFlushListener().waitForResult();
        this.checkpointManager.makeCreateMemTableCP(new MemTableInfo((IMemTable)targetMemTable, FILE_WITH_WAL_NAME, firstValidVersionId));
    }

    private void recoverAndCheck() throws Exception {
        List<WALRecoverListener> recoverListeners = this.prepareCrashedTsFile();
        recoverManager.setAllDataRegionScannedLatch(new CountDownLatch(0));
        recoverManager.recover();
        try {
            for (WALRecoverListener recoverListener : recoverListeners) {
                Assert.assertEquals((Object)AbstractResultListener.Status.SUCCESS, (Object)recoverListener.waitForResult());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_WITH_WAL_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2"));
        Assert.assertNotNull((Object)chunkMetadataList);
        Assert.assertEquals((long)2L, (long)chunkMetadataList.size());
        Chunk chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(0));
        Assert.assertEquals((long)3L, (long)chunk.getChunkStatistic().getEndTime());
        chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(1));
        Assert.assertEquals((long)4L, (long)chunk.getChunkStatistic().getEndTime());
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileWithWALResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileWithWALResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileWithWALResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)4L, (long)this.tsFileWithWALResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)new File(FILE_WITH_WAL_NAME).exists());
        Assert.assertTrue((boolean)new File(FILE_WITH_WAL_NAME.concat(".resource")).exists());
        reader = new TsFileSequenceReader(FILE_WITHOUT_WAL_NAME);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1"));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2"));
        Assert.assertNotNull((Object)chunkMetadataList);
        Assert.assertEquals((long)1L, (long)chunkMetadataList.size());
        chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(0));
        Assert.assertEquals((long)3L, (long)chunk.getChunkStatistic().getEndTime());
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileWithoutWALResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileWithoutWALResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileWithoutWALResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileWithoutWALResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)new File(FILE_WITHOUT_WAL_NAME).exists());
        Assert.assertTrue((boolean)new File(FILE_WITHOUT_WAL_NAME.concat(".resource")).exists());
    }

    private InsertRowPlan getInsertRowPlan(String devicePath, long time) throws MetadataException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.DOUBLE};
        String[] columns = new String[]{"1", "1.0"};
        PartialPath path = new PartialPath(devicePath);
        String[] measurements = new String[]{"s1", "s2"};
        InsertRowPlan insertRowPlan = new InsertRowPlan(path, time, measurements, dataTypes, columns);
        insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[]{IoTDB.schemaProcessor.getMeasurementMNode(path.concatNode("s1")), IoTDB.schemaProcessor.getMeasurementMNode(path.concatNode("s2"))});
        return insertRowPlan;
    }

    private InsertTabletPlan getInsertTabletPlan(String devicePath) throws IllegalPathException {
        long[] times = new long[]{110L, 111L, 112L, 113L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.DOUBLE.ordinal());
        dataTypes.add(TSDataType.FLOAT.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.BOOLEAN.ordinal());
        dataTypes.add(TSDataType.TEXT.ordinal());
        Object[] columns = new Object[]{new double[4], new float[4], new long[4], new int[4], new boolean[4], new Binary[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 1.0 + (double)r;
            ((float[])columns[1])[r] = 2 + r;
            ((long[])columns[2])[r] = 10000 + r;
            ((int[])columns[3])[r] = 100 + r;
            ((boolean[])columns[4])[r] = r % 2 == 0;
            ((Binary[])columns[5])[r] = new Binary("hh" + r);
        }
        BitMap[] bitMaps = new BitMap[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(i % times.length);
        }
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(devicePath), new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes);
        insertTabletPlan.setTimes(times);
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setRowCount(times.length);
        insertTabletPlan.setBitMaps(bitMaps);
        return insertTabletPlan;
    }

    private List<WALRecoverListener> prepareCrashedTsFile() throws IOException, WriteProcessException {
        ArrayList<WALRecoverListener> recoverListeners = new ArrayList<WALRecoverListener>();
        File fileWithWAL = new File(FILE_WITH_WAL_NAME);
        this.generateCrashedFile(fileWithWAL);
        this.tsFileWithWALResource = new TsFileResource(fileWithWAL);
        UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileWithWALResource, true, null, performer -> Assert.assertFalse((boolean)performer.canWrite()));
        recoverManager.addRecoverPerformer(recoverPerformer);
        recoverListeners.add(recoverPerformer.getRecoverListener());
        File fileWithoutWAL = new File(FILE_WITHOUT_WAL_NAME);
        this.generateCrashedFile(fileWithoutWAL);
        this.tsFileWithoutWALResource = new TsFileResource(fileWithoutWAL);
        recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileWithoutWALResource, true, null, performer -> Assert.assertFalse((boolean)performer.canWrite()));
        recoverManager.addRecoverPerformer(recoverPerformer);
        recoverListeners.add(recoverPerformer.getRecoverListener());
        return recoverListeners;
    }

    private void generateCrashedFile(File tsFile) throws IOException, WriteProcessException {
        long truncateSize;
        try (TsFileWriter writer = new TsFileWriter(tsFile);){
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s1", TSDataType.FLOAT, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s2", TSDataType.DOUBLE, TSEncoding.RLE));
            writer.write(new TSRecord(1L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 1)).addTuple((DataPoint)new LongDataPoint("s2", 1L)));
            writer.write(new TSRecord(2L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 2)).addTuple((DataPoint)new LongDataPoint("s2", 2L)));
            writer.write(new TSRecord(3L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 3.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 3.0)));
            writer.flushAllChunkGroups();
            try (FileChannel channel = new FileInputStream(tsFile).getChannel();){
                truncateSize = channel.size();
            }
            writer.write(new TSRecord(4L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 4.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 4.0)));
            writer.flushAllChunkGroups();
            channel = new FileInputStream(tsFile).getChannel();
            try {
                truncateSize = (truncateSize + channel.size()) / 2L;
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
        }
        try (FileChannel channel = new FileOutputStream(tsFile, true).getChannel();){
            channel.truncate(truncateSize);
        }
    }

    private /* synthetic */ Void lambda$prepareCheckpointAndWALFileForSnapshot$1(IMemTable fakeMemTable, long firstWALVersionId, long memTableId) throws Exception {
        this.checkpointManager.makeCreateMemTableCP(new MemTableInfo(fakeMemTable, "fake.tsfile", 0L));
        try {
            while (this.walBuffer.getCurrentWALFileVersion() - firstWALVersionId < 2L) {
                WALInfoEntry walEntry = new WALInfoEntry(memTableId, (WALEntryValue)this.getInsertTabletPlan(SG_NAME.concat("test_d" + memTableId)));
                this.walBuffer.write((WALEntry)walEntry);
            }
        }
        catch (IllegalPathException e) {
            Assert.fail();
        }
        this.checkpointManager.makeFlushMemTableCP(fakeMemTable.getMemTableId());
        return null;
    }

    private /* synthetic */ Void lambda$prepareCheckpointAndWALFileForNormal$0(IMemTable fakeMemTable, long firstWALVersionId, long memTableId) throws Exception {
        this.checkpointManager.makeCreateMemTableCP(new MemTableInfo(fakeMemTable, "fake.tsfile", 0L));
        try {
            while (this.walBuffer.getCurrentWALFileVersion() - firstWALVersionId < 2L) {
                WALInfoEntry walEntry = new WALInfoEntry(memTableId, (WALEntryValue)this.getInsertTabletPlan(SG_NAME.concat("test_d" + memTableId)));
                this.walBuffer.write((WALEntry)walEntry);
            }
        }
        catch (IllegalPathException e) {
            Assert.fail();
        }
        this.checkpointManager.makeFlushMemTableCP(fakeMemTable.getMemTableId());
        return null;
    }
}

