/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.node;

import java.util.ArrayList;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.wal.node.IWALNode;
import org.apache.iotdb.db.wal.node.WALFakeNode;
import org.apache.iotdb.db.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.wal.utils.listener.WALFlushListener;
import org.junit.Assert;
import org.junit.Test;

public class WALFakeNodeTest {
    private IWALNode walNode;

    @Test
    public void testSuccessFakeNode() {
        this.walNode = WALFakeNode.getSuccessInstance();
        ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
        walFlushListeners.add(this.walNode.log(1L, new InsertRowPlan()));
        walFlushListeners.add(this.walNode.log(1L, new InsertTabletPlan(), 0, 0));
        walFlushListeners.add(this.walNode.log(1L, new DeletePlan()));
        try {
            for (WALFlushListener walFlushListener : walFlushListeners) {
                Assert.assertNotEquals((Object)AbstractResultListener.Status.FAILURE, (Object)walFlushListener.waitForResult());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testFailureFakeNode() {
        Exception expectedException = new Exception("test");
        this.walNode = WALFakeNode.getFailureInstance((Exception)expectedException);
        ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
        walFlushListeners.add(this.walNode.log(1L, new InsertRowPlan()));
        walFlushListeners.add(this.walNode.log(1L, new InsertTabletPlan(), 0, 0));
        walFlushListeners.add(this.walNode.log(1L, new DeletePlan()));
        try {
            for (WALFlushListener walFlushListener : walFlushListeners) {
                Assert.assertEquals((Object)AbstractResultListener.Status.FAILURE, (Object)walFlushListener.waitForResult());
                Assert.assertEquals((Object)expectedException, (Object)walFlushListener.getCause().getCause());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

