/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.node;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.multileader.wal.ConsensusReqReader;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.node.WALNode;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsensusReqReaderTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String identifier = String.valueOf(Integer.MAX_VALUE);
    private static final String logDirectory = TestConstant.BASE_OUTPUT_PATH.concat("wal-test");
    private static final String devicePath = "root.test_sg.test_d";
    private WALMode prevMode;
    private WALNode walNode;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(logDirectory);
        config.setClusterMode(true);
        this.prevMode = config.getWalMode();
        config.setWalMode(WALMode.SYNC);
        this.walNode = new WALNode(identifier, logDirectory);
    }

    @After
    public void tearDown() throws Exception {
        this.walNode.close();
        config.setWalMode(this.prevMode);
        config.setClusterMode(false);
        EnvironmentUtils.cleanDir(logDirectory);
    }

    private void simulateFileScenario01() throws IllegalPathException {
        InsertRowNode insertRowNode = ConsensusReqReaderTest.getInsertRowNode(devicePath);
        insertRowNode.setSearchIndex(1L);
        this.walNode.log(0L, insertRowNode);
        InsertTabletNode insertTabletNode = this.getInsertTabletNode(devicePath, new long[]{2L});
        this.walNode.log(0L, insertTabletNode, 0, insertTabletNode.getRowCount());
        this.walNode.rollWALFile();
        insertRowNode = ConsensusReqReaderTest.getInsertRowNode(devicePath);
        insertRowNode.setSearchIndex(2L);
        this.walNode.log(0L, insertRowNode);
        this.walNode.log(0L, insertRowNode);
        this.walNode.log(0L, insertRowNode);
        this.walNode.rollWALFile();
        insertRowNode = ConsensusReqReaderTest.getInsertRowNode(devicePath);
        insertRowNode.setSearchIndex(3L);
        this.walNode.log(0L, insertRowNode);
        this.walNode.log(0L, insertRowNode);
        this.walNode.rollWALFile();
        insertRowNode.setDevicePath(new PartialPath("root.test_sg.test_dtest"));
        this.walNode.log(0L, insertRowNode);
        insertTabletNode = this.getInsertTabletNode(devicePath, new long[]{4L});
        insertTabletNode.setSearchIndex(4L);
        this.walNode.log(0L, insertTabletNode, 0, insertTabletNode.getRowCount());
        this.walNode.rollWALFile();
        this.walNode.log(0L, insertTabletNode, 0, insertTabletNode.getRowCount());
        this.walNode.rollWALFile();
        this.walNode.log(0L, insertTabletNode, 0, insertTabletNode.getRowCount());
        this.walNode.log(0L, insertTabletNode, 0, insertTabletNode.getRowCount());
        insertTabletNode = this.getInsertTabletNode(devicePath, new long[]{5L});
        insertTabletNode.setSearchIndex(5L);
        this.walNode.log(0L, insertTabletNode, 0, insertTabletNode.getRowCount());
        this.walNode.rollWALFile();
        insertRowNode = ConsensusReqReaderTest.getInsertRowNode(devicePath);
        insertRowNode.setSearchIndex(6L);
        this.walNode.log(0L, insertRowNode);
    }

    @Test
    public void scenario01TestGetReqIterator01() throws Exception {
        PlanNode planNode;
        this.simulateFileScenario01();
        this.walNode.rollWALFile();
        ConsensusReqReader.ReqIterator iterator = this.walNode.getReqIterator(1L);
        Assert.assertTrue((boolean)iterator.hasNext());
        IndexedConsensusRequest request = iterator.next();
        Assert.assertEquals((long)1L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertRowNode));
            Assert.assertEquals((long)1L, (long)((InsertRowNode)planNode).getSearchIndex());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)3L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertRowNode));
            Assert.assertEquals((long)2L, (long)((InsertRowNode)planNode).getSearchIndex());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)3L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertRowNode));
            Assert.assertEquals((long)3L, (long)((InsertRowNode)planNode).getSearchIndex());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)4L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertTabletNode));
            Assert.assertEquals((long)4L, (long)((InsertTabletNode)planNode).getSearchIndex());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)1L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertTabletNode));
            Assert.assertEquals((long)5L, (long)((InsertTabletNode)planNode).getSearchIndex());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void scenario01TestGetReqIterator02() throws Exception {
        this.simulateFileScenario01();
        ConsensusReqReader.ReqIterator iterator = this.walNode.getReqIterator(4L);
        Assert.assertTrue((boolean)iterator.hasNext());
        IndexedConsensusRequest request = iterator.next();
        Assert.assertEquals((long)4L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            PlanNode planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertTabletNode));
            Assert.assertEquals((long)4L, (long)((InsertTabletNode)planNode).getSearchIndex());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        ExecutorService checkThread = Executors.newSingleThreadExecutor();
        Future<Boolean> future = checkThread.submit(() -> {
            iterator.waitForNextReady();
            Assert.assertTrue((boolean)iterator.hasNext());
            IndexedConsensusRequest req = iterator.next();
            Assert.assertEquals((long)1L, (long)req.getRequests().size());
            for (IConsensusRequest innerRequest : req.getRequests()) {
                PlanNode node = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
                Assert.assertTrue((boolean)(node instanceof InsertTabletNode));
                Assert.assertEquals((long)5L, (long)((InsertTabletNode)node).getSearchIndex());
            }
            return true;
        });
        Thread.sleep(500L);
        this.walNode.rollWALFile();
        InsertRowNode insertRowNode = ConsensusReqReaderTest.getInsertRowNode(devicePath);
        this.walNode.log(0L, insertRowNode);
        Assert.assertTrue((boolean)future.get());
    }

    @Test
    public void scenario01TestGetReqIterator03() throws Exception {
        this.simulateFileScenario01();
        ConsensusReqReader.ReqIterator iterator = this.walNode.getReqIterator(5L);
        Assert.assertFalse((boolean)iterator.hasNext());
        ExecutorService checkThread = Executors.newSingleThreadExecutor();
        Future<Boolean> future = checkThread.submit(() -> {
            PlanNode planNode;
            iterator.waitForNextReady();
            Assert.assertTrue((boolean)iterator.hasNext());
            IndexedConsensusRequest request = iterator.next();
            Assert.assertEquals((long)1L, (long)request.getRequests().size());
            for (IConsensusRequest innerRequest : request.getRequests()) {
                planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
                Assert.assertTrue((boolean)(planNode instanceof InsertTabletNode));
                Assert.assertEquals((long)5L, (long)((InsertTabletNode)planNode).getSearchIndex());
            }
            iterator.waitForNextReady();
            Assert.assertTrue((boolean)iterator.hasNext());
            request = iterator.next();
            Assert.assertEquals((long)1L, (long)request.getRequests().size());
            for (IConsensusRequest innerRequest : request.getRequests()) {
                planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
                Assert.assertTrue((boolean)(planNode instanceof InsertRowNode));
                Assert.assertEquals((long)6L, (long)((InsertRowNode)planNode).getSearchIndex());
            }
            return true;
        });
        Thread.sleep(500L);
        this.walNode.rollWALFile();
        InsertRowNode insertRowNode = ConsensusReqReaderTest.getInsertRowNode(devicePath);
        this.walNode.log(0L, insertRowNode);
        this.walNode.rollWALFile();
        insertRowNode = ConsensusReqReaderTest.getInsertRowNode(devicePath);
        this.walNode.log(0L, insertRowNode);
        Assert.assertTrue((boolean)future.get());
    }

    @Test
    public void scenario01TestGetReqIterator04() throws Exception {
        PlanNode planNode;
        this.simulateFileScenario01();
        this.walNode.rollWALFile();
        ConsensusReqReader.ReqIterator iterator = this.walNode.getReqIterator(1L);
        Assert.assertTrue((boolean)iterator.hasNext());
        IndexedConsensusRequest request = iterator.next();
        Assert.assertEquals((long)1L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertRowNode));
            Assert.assertEquals((long)1L, (long)((InsertRowNode)planNode).getSearchIndex());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)3L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertRowNode));
            Assert.assertEquals((long)2L, (long)((InsertRowNode)planNode).getSearchIndex());
        }
        iterator.skipTo(4L);
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)4L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertTabletNode));
            Assert.assertEquals((long)4L, (long)((InsertTabletNode)planNode).getSearchIndex());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)1L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertTabletNode));
            Assert.assertEquals((long)5L, (long)((InsertTabletNode)planNode).getSearchIndex());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void scenario01TestGetReqIterator05() throws Exception {
        PlanNode planNode;
        this.simulateFileScenario01();
        this.walNode.rollWALFile();
        ConsensusReqReader.ReqIterator iterator = this.walNode.getReqIterator(5L);
        Assert.assertTrue((boolean)iterator.hasNext());
        IndexedConsensusRequest request = iterator.next();
        Assert.assertEquals((long)1L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertTabletNode));
            Assert.assertEquals((long)5L, (long)((InsertTabletNode)planNode).getSearchIndex());
        }
        iterator.skipTo(2L);
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)3L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertRowNode));
            Assert.assertEquals((long)2L, (long)((InsertRowNode)planNode).getSearchIndex());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)3L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertRowNode));
            Assert.assertEquals((long)3L, (long)((InsertRowNode)planNode).getSearchIndex());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)4L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertTabletNode));
            Assert.assertEquals((long)4L, (long)((InsertTabletNode)planNode).getSearchIndex());
        }
        Assert.assertTrue((boolean)iterator.hasNext());
        request = iterator.next();
        Assert.assertEquals((long)1L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof InsertTabletNode));
            Assert.assertEquals((long)5L, (long)((InsertTabletNode)planNode).getSearchIndex());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void scenario01TestGetReqIterator06() throws Exception {
        this.simulateFileScenario01();
        ConsensusReqReader.ReqIterator iterator = this.walNode.getReqIterator(5L);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void scenario01TestGetReqIterator07() throws Exception {
        this.simulateFileScenario01();
        ConsensusReqReader.ReqIterator iterator = this.walNode.getReqIterator(6L);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private void simulateFileScenario02() throws IllegalPathException {
        InsertRowNode insertRowNode = ConsensusReqReaderTest.getInsertRowNode(devicePath);
        this.walNode.log(0L, insertRowNode);
        this.walNode.log(0L, insertRowNode);
        this.walNode.rollWALFile();
        this.walNode.log(0L, insertRowNode);
        this.walNode.rollWALFile();
        this.walNode.log(0L, insertRowNode);
        DeleteDataNode deleteDataNode = this.getDeleteDataNode(devicePath);
        deleteDataNode.setSearchIndex(1L);
        this.walNode.log(0L, deleteDataNode);
        this.walNode.rollWALFile();
        this.walNode.log(0L, insertRowNode);
        this.walNode.rollWALFile();
    }

    @Test
    public void scenario02TestGetReqIterator01() throws Exception {
        this.simulateFileScenario02();
        ConsensusReqReader.ReqIterator iterator = this.walNode.getReqIterator(1L);
        Assert.assertTrue((boolean)iterator.hasNext());
        IndexedConsensusRequest request = iterator.next();
        Assert.assertEquals((long)1L, (long)request.getRequests().size());
        for (IConsensusRequest innerRequest : request.getRequests()) {
            PlanNode planNode = WALEntry.deserializeForConsensus((ByteBuffer)innerRequest.serializeToByteBuffer());
            Assert.assertTrue((boolean)(planNode instanceof DeleteDataNode));
            Assert.assertEquals((long)1L, (long)((DeleteDataNode)planNode).getSearchIndex());
        }
    }

    public static InsertRowNode getInsertRowNode(String devicePath) throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false, new Binary("hh0")};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, time, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN), new MeasurementSchema("s6", TSDataType.TEXT)});
        return insertRowNode;
    }

    private InsertTabletNode getInsertTabletNode(String devicePath, long[] times) throws IllegalPathException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{new double[times.length], new float[times.length], new long[times.length], new int[times.length], new boolean[times.length], new Binary[times.length]};
        for (int r = 0; r < times.length; ++r) {
            ((double[])columns[0])[r] = 1.0 + (double)r;
            ((float[])columns[1])[r] = 2 + r;
            ((long[])columns[2])[r] = 10000 + r;
            ((int[])columns[3])[r] = 100 + r;
            ((boolean[])columns[4])[r] = r % 2 == 0;
            ((Binary[])columns[5])[r] = new Binary("hh" + r);
        }
        BitMap[] bitMaps = new BitMap[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(i % times.length);
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, times, bitMaps, columns, times.length);
        insertTabletNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN), new MeasurementSchema("s6", TSDataType.TEXT)});
        return insertTabletNode;
    }

    private DeleteDataNode getDeleteDataNode(String devicePath) throws IllegalPathException {
        return new DeleteDataNode(new PlanNodeId(""), Collections.singletonList(new PartialPath(devicePath)), Long.MIN_VALUE, Long.MAX_VALUE);
    }
}

