/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryType;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.wal.io.WALReader;
import org.apache.iotdb.db.wal.io.WALWriter;
import org.apache.iotdb.db.wal.utils.WALByteBufferForTest;
import org.apache.iotdb.db.wal.utils.WALFileStatus;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WALFileTest {
    private final File walFile = new File(TestConstant.BASE_OUTPUT_PATH.concat(WALFileUtils.getLogFileName((long)0L, (long)0L, (WALFileStatus)WALFileStatus.CONTAINS_SEARCH_INDEX)));
    private final String devicePath = "root.test_sg.test_d";

    @Before
    public void setUp() throws Exception {
        if (this.walFile.exists()) {
            Files.delete(this.walFile.toPath());
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.walFile.exists()) {
            Files.delete(this.walFile.toPath());
        }
    }

    @Test
    public void testReadNormalFile() throws IOException, IllegalPathException {
        int fakeMemTableId = 1;
        ArrayList<WALInfoEntry> expectedWALEntries = new ArrayList<WALInfoEntry>();
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertRowNode("root.test_sg.test_d")));
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertTabletNode("root.test_sg.test_d")));
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getDeleteDataNode("root.test_sg.test_d")));
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertRowPlan("root.test_sg.test_d")));
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertTabletPlan("root.test_sg.test_d")));
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getDeletePlan("root.test_sg.test_d")));
        int size = 0;
        for (WALEntry wALEntry : expectedWALEntries) {
            size += wALEntry.serializedSize();
        }
        WALByteBufferForTest buffer = new WALByteBufferForTest(ByteBuffer.allocate(size));
        for (WALEntry wALEntry : expectedWALEntries) {
            wALEntry.serialize((IWALByteBufferView)buffer);
        }
        Assert.assertEquals((long)0L, (long)buffer.getBuffer().remaining());
        try (WALWriter wALWriter = new WALWriter(this.walFile);){
            wALWriter.write(buffer.getBuffer());
        }
        ArrayList<WALEntry> arrayList = new ArrayList<WALEntry>();
        try (WALReader wALReader = new WALReader(this.walFile);){
            while (wALReader.hasNext()) {
                arrayList.add(wALReader.next());
            }
        }
        Assert.assertEquals(expectedWALEntries, arrayList);
    }

    @Test
    public void testReadNotExistFile() throws IOException {
        if (this.walFile.createNewFile()) {
            ArrayList<WALEntry> actualWALEntries = new ArrayList<WALEntry>();
            try (WALReader walReader = new WALReader(this.walFile);){
                while (walReader.hasNext()) {
                    actualWALEntries.add(walReader.next());
                }
            }
            Assert.assertEquals((long)0L, (long)actualWALEntries.size());
        }
    }

    @Test
    public void testReadBrokenFile() throws IOException, IllegalPathException {
        int fakeMemTableId = 1;
        ArrayList<WALInfoEntry> expectedWALEntries = new ArrayList<WALInfoEntry>();
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertRowNode("root.test_sg.test_d")));
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertTabletNode("root.test_sg.test_d")));
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertRowPlan("root.test_sg.test_d")));
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getInsertTabletPlan("root.test_sg.test_d")));
        expectedWALEntries.add(new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)WALFileTest.getDeletePlan("root.test_sg.test_d")));
        int size = 1;
        for (WALEntry wALEntry : expectedWALEntries) {
            size += wALEntry.serializedSize();
        }
        WALByteBufferForTest buffer = new WALByteBufferForTest(ByteBuffer.allocate(size));
        for (WALEntry wALEntry : expectedWALEntries) {
            wALEntry.serialize((IWALByteBufferView)buffer);
        }
        buffer.put(WALEntryType.DELETE_PLAN.getCode());
        Assert.assertEquals((long)0L, (long)buffer.getBuffer().remaining());
        try (WALWriter wALWriter = new WALWriter(this.walFile);){
            wALWriter.write(buffer.getBuffer());
        }
        ArrayList<WALEntry> arrayList = new ArrayList<WALEntry>();
        try (WALReader wALReader = new WALReader(this.walFile);){
            while (wALReader.hasNext()) {
                arrayList.add(wALReader.next());
            }
        }
        Assert.assertEquals(expectedWALEntries, arrayList);
    }

    public static InsertRowPlan getInsertRowPlan(String devicePath) throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        String[] columns = new String[]{"1.0", "2", "10000", "100", "false", "hh0"};
        return new InsertRowPlan(new PartialPath(devicePath), time, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, columns);
    }

    public static InsertTabletPlan getInsertTabletPlan(String devicePath) throws IllegalPathException {
        long[] times = new long[]{110L, 111L, 112L, 113L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.DOUBLE.ordinal());
        dataTypes.add(TSDataType.FLOAT.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.BOOLEAN.ordinal());
        dataTypes.add(TSDataType.TEXT.ordinal());
        Object[] columns = new Object[]{new double[4], new float[4], new long[4], new int[4], new boolean[4], new Binary[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 1.0 + (double)r;
            ((float[])columns[1])[r] = 2 + r;
            ((long[])columns[2])[r] = 10000 + r;
            ((int[])columns[3])[r] = 100 + r;
            ((boolean[])columns[4])[r] = r % 2 == 0;
            ((Binary[])columns[5])[r] = new Binary("hh" + r);
        }
        BitMap[] bitMaps = new BitMap[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(i % times.length);
        }
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(devicePath), new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes);
        insertTabletPlan.setTimes(times);
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setRowCount(times.length);
        insertTabletPlan.setBitMaps(bitMaps);
        return insertTabletPlan;
    }

    public static InsertRowNode getInsertRowNode(String devicePath) throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false, new Binary("hh0")};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, time, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[6]);
        return insertRowNode;
    }

    public static InsertTabletNode getInsertTabletNode(String devicePath) throws IllegalPathException {
        long[] times = new long[]{110L, 111L, 112L, 113L};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{new double[4], new float[4], new long[4], new int[4], new boolean[4], new Binary[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 1.0 + (double)r;
            ((float[])columns[1])[r] = 2 + r;
            ((long[])columns[2])[r] = 10000 + r;
            ((int[])columns[3])[r] = 100 + r;
            ((boolean[])columns[4])[r] = r % 2 == 0;
            ((Binary[])columns[5])[r] = new Binary("hh" + r);
        }
        BitMap[] bitMaps = new BitMap[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(i % times.length);
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, times, bitMaps, columns, times.length);
        insertTabletNode.setMeasurementSchemas(new MeasurementSchema[6]);
        return insertTabletNode;
    }

    public static DeletePlan getDeletePlan(String devicePath) throws IllegalPathException {
        return new DeletePlan(Long.MIN_VALUE, Long.MAX_VALUE, new PartialPath(devicePath));
    }

    public static DeleteDataNode getDeleteDataNode(String devicePath) throws IllegalPathException {
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId(""), Collections.singletonList(new PartialPath(devicePath)), Long.MIN_VALUE, Long.MAX_VALUE);
        deleteDataNode.setSearchIndex(100L);
        return deleteDataNode;
    }
}

