/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.wal.checkpoint.Checkpoint;
import org.apache.iotdb.db.wal.checkpoint.CheckpointType;
import org.apache.iotdb.db.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.wal.io.CheckpointReader;
import org.apache.iotdb.db.wal.io.CheckpointWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CheckpointFileTest {
    private final File checkpointFile = new File(TestConstant.BASE_OUTPUT_PATH.concat("_0.checkpoint"));

    @Before
    public void setUp() throws Exception {
        if (this.checkpointFile.exists()) {
            Files.delete(this.checkpointFile.toPath());
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.checkpointFile.exists()) {
            Files.delete(this.checkpointFile.toPath());
        }
    }

    @Test
    public void testReadNormalFile() throws IOException {
        MemTableInfo fakeMemTableInfo = new MemTableInfo((IMemTable)new PrimitiveMemTable(), "fake.tsfile", 0L);
        ArrayList<Checkpoint> expectedCheckpoints = new ArrayList<Checkpoint>();
        expectedCheckpoints.add(new Checkpoint(CheckpointType.GLOBAL_MEMORY_TABLE_INFO, Collections.emptyList()));
        expectedCheckpoints.add(new Checkpoint(CheckpointType.CREATE_MEMORY_TABLE, Collections.singletonList(fakeMemTableInfo)));
        expectedCheckpoints.add(new Checkpoint(CheckpointType.FLUSH_MEMORY_TABLE, Collections.singletonList(fakeMemTableInfo)));
        int size = 8;
        for (Checkpoint checkpoint : expectedCheckpoints) {
            size += checkpoint.serializedSize();
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putLong(0L);
        for (Checkpoint checkpoint : expectedCheckpoints) {
            checkpoint.serialize(buffer);
        }
        Assert.assertEquals((long)0L, (long)buffer.remaining());
        try (CheckpointWriter checkpointWriter = new CheckpointWriter(this.checkpointFile);){
            checkpointWriter.write(buffer);
        }
        CheckpointReader checkpointReader = new CheckpointReader(this.checkpointFile);
        List actualCheckpoints = checkpointReader.getCheckpoints();
        Assert.assertEquals(expectedCheckpoints, (Object)actualCheckpoints);
    }

    @Test
    public void testReadNotExistFile() throws IOException {
        if (this.checkpointFile.createNewFile()) {
            CheckpointReader checkpointReader = new CheckpointReader(this.checkpointFile);
            List actualCheckpoints = checkpointReader.getCheckpoints();
            Assert.assertEquals((long)0L, (long)actualCheckpoints.size());
        }
    }

    @Test
    public void testReadBrokenFile() throws IOException {
        MemTableInfo fakeMemTableInfo = new MemTableInfo((IMemTable)new PrimitiveMemTable(), "fake.tsfile", 0L);
        ArrayList<Checkpoint> expectedCheckpoints = new ArrayList<Checkpoint>();
        expectedCheckpoints.add(new Checkpoint(CheckpointType.GLOBAL_MEMORY_TABLE_INFO, Collections.emptyList()));
        expectedCheckpoints.add(new Checkpoint(CheckpointType.CREATE_MEMORY_TABLE, Collections.singletonList(fakeMemTableInfo)));
        expectedCheckpoints.add(new Checkpoint(CheckpointType.FLUSH_MEMORY_TABLE, Collections.singletonList(fakeMemTableInfo)));
        int size = 9;
        for (Checkpoint checkpoint : expectedCheckpoints) {
            size += checkpoint.serializedSize();
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putLong(0L);
        for (Checkpoint checkpoint : expectedCheckpoints) {
            checkpoint.serialize(buffer);
        }
        buffer.put(CheckpointType.CREATE_MEMORY_TABLE.getCode());
        Assert.assertEquals((long)0L, (long)buffer.remaining());
        try (CheckpointWriter checkpointWriter = new CheckpointWriter(this.checkpointFile);){
            checkpointWriter.write(buffer);
        }
        CheckpointReader checkpointReader = new CheckpointReader(this.checkpointFile);
        List actualCheckpoints = checkpointReader.getCheckpoints();
        Assert.assertEquals(expectedCheckpoints, (Object)actualCheckpoints);
    }
}

