/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.buffer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.wal.buffer.IWALBuffer;
import org.apache.iotdb.db.wal.buffer.WALBuffer;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.wal.io.WALReader;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class WALBufferCommonTest {
    protected static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected static final String identifier = String.valueOf(Integer.MAX_VALUE);
    protected static final String logDirectory = TestConstant.BASE_OUTPUT_PATH.concat("wal-test");
    protected static final String devicePath = "root.test_sg.test_d";
    protected IWALBuffer walBuffer;

    @Before
    public void setUp() throws Exception {
        this.walBuffer = new WALBuffer(identifier, logDirectory);
    }

    @After
    public void tearDown() throws Exception {
        this.walBuffer.close();
    }

    @Test
    public void testConcurrentWrite() throws Exception {
        int threadsNum = 3;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ConcurrentHashMap.KeySetView expectedInsertRowPlans = ConcurrentHashMap.newKeySet();
        int i = 0;
        while (i < threadsNum) {
            int n = i++;
            Callable<Void> writeTask = () -> {
                try {
                    this.writeInsertRowPlan(memTableId, expectedInsertRowPlans);
                }
                catch (IllegalPathException e) {
                    Assert.fail();
                }
                return null;
            };
            Future<Void> future = executorService.submit(writeTask);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        while (!this.walBuffer.isAllWALEntriesConsumed()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        File[] walFiles = WALFileUtils.listAllWALFiles((File)new File(logDirectory));
        HashSet<InsertRowPlan> hashSet = new HashSet<InsertRowPlan>();
        if (walFiles != null) {
            for (File walFile : walFiles) {
                try (WALReader walReader = new WALReader(walFile);){
                    while (walReader.hasNext()) {
                        hashSet.add((InsertRowPlan)walReader.next().getValue());
                    }
                }
            }
        }
        Assert.assertEquals(expectedInsertRowPlans, hashSet);
    }

    private void writeInsertRowPlan(int memTableId, Set<InsertRowPlan> expectedInsertRowPlans) throws IllegalPathException {
        for (int i = 0; i < 100; ++i) {
            InsertRowPlan insertRowPlan = this.getInsertRowPlan(devicePath + memTableId, i);
            expectedInsertRowPlans.add(insertRowPlan);
            WALInfoEntry walEntry = new WALInfoEntry((long)memTableId, (WALEntryValue)insertRowPlan);
            this.walBuffer.write((WALEntry)walEntry);
        }
    }

    private InsertRowPlan getInsertRowPlan(String devicePath, long time) throws IllegalPathException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        String[] columns = new String[]{"1.0", "2", "10000", "100", "false", "hh0"};
        return new InsertRowPlan(new PartialPath(devicePath), time, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, columns);
    }

    @Test
    public void testHugeWrite() throws Exception {
        int prevWalBufferSize = config.getWalBufferSize();
        config.setWalBufferSize(32);
        try {
            this.testConcurrentWrite();
        }
        finally {
            config.setWalBufferSize(prevWalBufferSize);
        }
    }
}

