/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.allocation;

import java.io.File;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.wal.allocation.RoundRobinStrategy;
import org.apache.iotdb.db.wal.node.IWALNode;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoundRobinStrategyTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final String[] walDirs = new String[]{TestConstant.BASE_OUTPUT_PATH.concat("wal_test1"), TestConstant.BASE_OUTPUT_PATH.concat("wal_test2"), TestConstant.BASE_OUTPUT_PATH.concat("wal_test3")};
    private String[] prevWalDirs;

    @Before
    public void setUp() throws Exception {
        this.prevWalDirs = config.getWalDirs();
        config.setWalDirs(this.walDirs);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        for (String walDir : this.walDirs) {
            EnvironmentUtils.cleanDir(walDir);
        }
        config.setWalDirs(this.prevWalDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllocateWALNode() throws IllegalPathException {
        RoundRobinStrategy roundRobinStrategy = new RoundRobinStrategy(6);
        IWALNode[] walNodes = new IWALNode[6];
        try {
            for (int i = 0; i < 12; ++i) {
                IWALNode walNode = roundRobinStrategy.applyForWALNode(String.valueOf(i));
                if (i < 6) {
                    walNodes[i] = walNode;
                } else {
                    Assert.assertEquals((Object)walNodes[i % 6], (Object)walNode);
                }
                walNode.log((long)i, this.getInsertRowPlan());
            }
            for (String string : this.walDirs) {
                File walDirFile = new File(string);
                Assert.assertTrue((boolean)walDirFile.exists());
                File[] nodeDirs = walDirFile.listFiles(File::isDirectory);
                Assert.assertNotNull((Object)nodeDirs);
                Assert.assertEquals((long)2L, (long)nodeDirs.length);
                for (File nodeDir : nodeDirs) {
                    Assert.assertTrue((boolean)nodeDir.exists());
                    Assert.assertNotEquals((long)0L, (long)WALFileUtils.listAllWALFiles((File)nodeDir).length);
                }
            }
        }
        finally {
            for (String string : walNodes) {
                if (string == null) continue;
                string.close();
            }
        }
    }

    private InsertRowPlan getInsertRowPlan() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        String[] columns = new String[]{"1.0", "2", "10000", "100", "false", "hh0"};
        return new InsertRowPlan(new PartialPath("root.test_sg.test_d"), time, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, columns);
    }
}

