/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.utils.windowing.configuration.SlidingTimeWindowConfiguration;
import org.apache.iotdb.db.utils.windowing.exception.WindowingException;
import org.apache.iotdb.db.utils.windowing.handler.SlidingTimeWindowEvaluationHandler;
import org.apache.iotdb.db.utils.windowing.window.EvictableBatchList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlidingTimeWindowEvaluationHandlerTest {
    @Before
    public void setUp() throws Exception {
        EvictableBatchList.setInternalBatchSize((int)2);
    }

    @After
    public void tearDown() throws Exception {
        EvictableBatchList.setInternalBatchSize((int)1000000);
    }

    @Test
    public void test00() throws WindowingException {
        this.doTest(1L, 1L, 0L);
    }

    @Test
    public void test01() throws WindowingException {
        this.doTest(1L, 1L, 1L);
    }

    @Test
    public void test02() throws WindowingException {
        this.doTest(1L, 1L, 2L);
    }

    @Test
    public void test03() throws WindowingException {
        this.doTest(1L, 1L, 5L);
    }

    @Test
    public void test04() throws WindowingException {
        this.doTest(1L, 2L, 0L);
    }

    @Test
    public void test05() throws WindowingException {
        this.doTest(1L, 2L, 1L);
    }

    @Test
    public void test06() throws WindowingException {
        this.doTest(1L, 2L, 2L);
    }

    @Test
    public void test07() throws WindowingException {
        this.doTest(1L, 2L, 5L);
    }

    @Test
    public void test08() throws WindowingException {
        this.doTest(7L, 2L, 5L);
    }

    @Test
    public void test09() throws WindowingException {
        this.doTest(7L, 3L, 7L);
    }

    @Test
    public void test10() throws WindowingException {
        this.doTest(7L, 3L, 24L);
    }

    @Test
    public void test11() throws WindowingException {
        this.doTest(7L, 10L, 75L);
    }

    @Test
    public void test12() throws WindowingException {
        this.doTest(7L, 10L, 76L);
    }

    @Test
    public void test13() throws WindowingException {
        this.doTest(7L, 10L, 77L);
    }

    @Test
    public void test14() throws WindowingException {
        this.doTest(7L, 7L, 75L);
    }

    @Test
    public void test15() throws WindowingException {
        this.doTest(7L, 7L, 76L);
    }

    @Test
    public void test16() throws WindowingException {
        this.doTest(7L, 7L, 77L);
    }

    @Test
    public void test17() throws WindowingException {
        this.doTest(7L, 33L, 77L);
    }

    @Test
    public void test18() throws WindowingException {
        this.doTest(4L, 16L, 128L);
    }

    @Test
    public void test19() throws WindowingException {
        this.doTest(1L, 100L, 101L);
    }

    private void doTest(long timeInterval, long slidingStep, long totalTime) throws WindowingException {
        AtomicInteger count = new AtomicInteger(0);
        ConcurrentHashMap actualTVMap = new ConcurrentHashMap();
        SlidingTimeWindowEvaluationHandler handler = new SlidingTimeWindowEvaluationHandler(new SlidingTimeWindowConfiguration(TSDataType.INT32, timeInterval, slidingStep), window -> {
            for (int i = 0; i < window.size(); ++i) {
                actualTVMap.put((int)window.getTime(i), window.getInt(i));
            }
            count.incrementAndGet();
        });
        int i = 0;
        while ((long)i < totalTime) {
            handler.collect((long)i, i);
            handler.collect((long)i, i);
            handler.collect((long)(i - 1), i);
            ++i;
        }
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> (totalTime < timeInterval ? 0L : 1L + (totalTime - timeInterval) / slidingStep - (long)((totalTime - timeInterval) % slidingStep == 0L ? 1 : 0)) == (long)count.get());
        ConcurrentHashMap<Integer, Integer> expectedTVMap = new ConcurrentHashMap<Integer, Integer>();
        int windowCount = count.get();
        block1: for (int i2 = 0; i2 < windowCount; ++i2) {
            int j = 0;
            while ((long)j < timeInterval) {
                int tv = (int)((long)i2 * slidingStep + (long)j);
                if (totalTime <= (long)tv) break block1;
                expectedTVMap.put(tv, tv);
                ++j;
            }
        }
        Assert.assertEquals(expectedTVMap, actualTVMap);
    }

    @Test
    public void testWithEmptyWindows() throws WindowingException {
        AtomicInteger countTotal = new AtomicInteger(0);
        AtomicInteger countEmpty = new AtomicInteger(0);
        SlidingTimeWindowEvaluationHandler handler = new SlidingTimeWindowEvaluationHandler(new SlidingTimeWindowConfiguration(TSDataType.INT32, 3L, 7L), window -> {
            Assert.assertTrue((window.size() == 0 || window.size() == 1 ? 1 : 0) != 0);
            countTotal.incrementAndGet();
            if (window.size() == 0) {
                countEmpty.incrementAndGet();
            }
        });
        for (int i = 0; i < 10; ++i) {
            handler.collect((long)(21 * i), 21 * i);
        }
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> countTotal.get() == 27 && countEmpty.get() == 18);
    }
}

