/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.DoubleTVList;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class DoubleTVListTest {
    public static double delta = 0.001;

    @Test
    public void testDoubleTVList1() {
        int i;
        DoubleTVList tvList = new DoubleTVList();
        for (i = 0; i < 1000; ++i) {
            tvList.putDouble((long)i, (double)i);
        }
        tvList.sort();
        for (i = 0; i < tvList.rowCount; ++i) {
            Assert.assertEquals((double)i, (double)tvList.getDouble(i), (double)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testDoubleTVList2() {
        int i;
        DoubleTVList tvList = new DoubleTVList();
        for (i = 1000; i >= 0; --i) {
            tvList.putDouble((long)i, (double)i);
        }
        tvList.sort();
        for (i = 0; i < tvList.rowCount; ++i) {
            Assert.assertEquals((double)i, (double)tvList.getDouble(i), (double)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testPutDoublesWithoutBitMap() {
        long i;
        DoubleTVList tvList = new DoubleTVList();
        ArrayList<Double> doubleList = new ArrayList<Double>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            doubleList.add(Double.valueOf(i));
        }
        tvList.putDoubles(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Double[])doubleList.toArray(new Double[0]), (double)0.0), null, 0, 1000);
        for (i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((double)((double)tvList.rowCount - (double)i), (double)tvList.getDouble((int)i), (double)delta);
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testPutDoublesWithBitMap() {
        DoubleTVList tvList = new DoubleTVList();
        ArrayList<Double> doubleList = new ArrayList<Double>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (long i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            doubleList.add(Double.valueOf(i));
            if (i % 100L != 0L) continue;
            bitMap.mark((int)i);
        }
        tvList.putDoubles(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Double[])doubleList.toArray(new Double[0]), (double)0.0), bitMap, 0, 1000);
        tvList.sort();
        int nullCnt = 0;
        for (long i = 1L; i < (long)doubleList.size(); ++i) {
            if (i % 100L == 0L) {
                ++nullCnt;
                continue;
            }
            Assert.assertEquals((double)i, (double)tvList.getDouble((int)i - nullCnt - 1), (double)delta);
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i - nullCnt - 1));
        }
    }

    @Test
    public void testClone() {
        DoubleTVList tvList = new DoubleTVList();
        ArrayList<Double> doubleList = new ArrayList<Double>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (long i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            doubleList.add(Double.valueOf(i));
            if (i % 100L != 0L) continue;
            bitMap.mark((int)i);
        }
        tvList.putDoubles(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Double[])doubleList.toArray(new Double[0]), (double)0.0), bitMap, 0, 1000);
        tvList.sort();
        DoubleTVList clonedTvList = tvList.clone();
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((double)tvList.getDouble((int)i), (double)clonedTvList.getDouble((int)i), (double)delta);
            Assert.assertEquals((long)tvList.getTime((int)i), (long)clonedTvList.getTime((int)i));
        }
    }
}

