/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.BinaryTVList;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class BinaryTVListTest {
    @Test
    public void testBinaryTVList() {
        int i;
        BinaryTVList tvList = new BinaryTVList();
        for (i = 0; i < 1000; ++i) {
            tvList.putBinary((long)i, Binary.valueOf((String)String.valueOf(i)));
        }
        for (i = 0; i < tvList.rowCount; ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)tvList.getBinary(i).toString());
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testPutBinariesWithoutBitMap() {
        BinaryTVList tvList = new BinaryTVList();
        Binary[] binaryList = new Binary[1001];
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            binaryList[1000 - i] = Binary.valueOf((String)String.valueOf(i));
        }
        tvList.putBinaries(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), binaryList, null, 0, 1000);
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testPutBinariesWithBitMap() {
        BinaryTVList tvList = new BinaryTVList();
        Binary[] binaryList = new Binary[1001];
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            binaryList[1000 - i] = Binary.valueOf((String)String.valueOf(i));
            if (i % 100 != 0) continue;
            bitMap.mark(i);
        }
        tvList.putBinaries(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), binaryList, bitMap, 0, 1000);
        tvList.sort();
        int nullCnt = 0;
        for (long i = 1L; i < (long)binaryList.length; ++i) {
            if (i % 100L == 0L) {
                ++nullCnt;
                continue;
            }
            Assert.assertEquals((Object)Binary.valueOf((String)String.valueOf(i)), (Object)tvList.getBinary((int)i - nullCnt - 1));
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i - nullCnt - 1));
        }
    }

    @Test
    public void testClone() {
        BinaryTVList tvList = new BinaryTVList();
        Binary[] binaryList = new Binary[1001];
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            binaryList[i] = Binary.valueOf((String)String.valueOf(i));
            if (i % 100 != 0) continue;
            bitMap.mark(i);
        }
        tvList.putBinaries(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), binaryList, bitMap, 0, 1000);
        tvList.sort();
        BinaryTVList clonedTvList = tvList.clone();
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((Object)tvList.getBinary((int)i), (Object)clonedTvList.getBinary((int)i));
            Assert.assertEquals((long)tvList.getTime((int)i), (long)clonedTvList.getTime((int)i));
        }
    }
}

