/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.db.utils.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.utils.timerangeiterator.TimeRangeIteratorFactory;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.junit.Assert;
import org.junit.Test;

public class TimeRangeIteratorTest {
    @Test
    public void testNotSplitTimeRange() {
        String[] res = new String[]{"[ 0 : 4 ]", "[ 3 : 7 ]", "[ 6 : 10 ]", "[ 9 : 13 ]", "[ 12 : 16 ]", "[ 15 : 19 ]", "[ 18 : 22 ]", "[ 21 : 25 ]", "[ 24 : 28 ]", "[ 27 : 31 ]", "[ 30 : 32 ]"};
        long startTime = 0L;
        long endTime = 32L;
        long interval = 4L;
        long slidingStep = 3L;
        ITimeRangeIterator timeRangeIterator = TimeRangeIteratorFactory.getTimeRangeIterator((long)startTime, (long)endTime, (long)interval, (long)slidingStep, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        this.checkRes(timeRangeIterator, res);
        ITimeRangeIterator descTimeRangeIterator = TimeRangeIteratorFactory.getTimeRangeIterator((long)startTime, (long)endTime, (long)interval, (long)slidingStep, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.checkRes(descTimeRangeIterator, res);
    }

    @Test
    public void testSplitTimeRange() {
        String[] res4_1 = new String[]{"[ 0 : 1 ]", "[ 1 : 2 ]", "[ 2 : 3 ]", "[ 3 : 4 ]", "[ 4 : 5 ]", "[ 5 : 6 ]", "[ 6 : 7 ]", "[ 7 : 8 ]", "[ 8 : 9 ]", "[ 9 : 10 ]", "[ 10 : 11 ]", "[ 11 : 12 ]", "[ 12 : 13 ]", "[ 13 : 14 ]", "[ 14 : 15 ]", "[ 15 : 16 ]", "[ 16 : 17 ]", "[ 17 : 18 ]", "[ 18 : 19 ]", "[ 19 : 20 ]", "[ 20 : 21 ]", "[ 21 : 22 ]", "[ 22 : 23 ]", "[ 23 : 24 ]", "[ 24 : 25 ]", "[ 25 : 26 ]", "[ 26 : 27 ]", "[ 27 : 28 ]", "[ 28 : 29 ]", "[ 29 : 30 ]", "[ 30 : 31 ]", "[ 31 : 32 ]"};
        String[] res4_2 = new String[]{"[ 0 : 2 ]", "[ 2 : 4 ]", "[ 4 : 6 ]", "[ 6 : 8 ]", "[ 8 : 10 ]", "[ 10 : 12 ]", "[ 12 : 14 ]", "[ 14 : 16 ]", "[ 16 : 18 ]", "[ 18 : 20 ]", "[ 20 : 22 ]", "[ 22 : 24 ]", "[ 24 : 26 ]", "[ 26 : 28 ]", "[ 28 : 30 ]", "[ 30 : 32 ]"};
        String[] res4_3 = new String[]{"[ 0 : 1 ]", "[ 1 : 3 ]", "[ 3 : 4 ]", "[ 4 : 6 ]", "[ 6 : 7 ]", "[ 7 : 9 ]", "[ 9 : 10 ]", "[ 10 : 12 ]", "[ 12 : 13 ]", "[ 13 : 15 ]", "[ 15 : 16 ]", "[ 16 : 18 ]", "[ 18 : 19 ]", "[ 19 : 21 ]", "[ 21 : 22 ]", "[ 22 : 24 ]", "[ 24 : 25 ]", "[ 25 : 27 ]", "[ 27 : 28 ]", "[ 28 : 30 ]", "[ 30 : 31 ]", "[ 31 : 32 ]"};
        String[] res4_4 = new String[]{"[ 0 : 4 ]", "[ 4 : 8 ]", "[ 8 : 12 ]", "[ 12 : 16 ]", "[ 16 : 20 ]", "[ 20 : 24 ]", "[ 24 : 28 ]", "[ 28 : 32 ]"};
        String[] res4_5 = new String[]{"[ 0 : 4 ]", "[ 5 : 9 ]", "[ 10 : 14 ]", "[ 15 : 19 ]", "[ 20 : 24 ]", "[ 25 : 29 ]", "[ 30 : 32 ]"};
        String[] res4_6 = new String[]{"[ 0 : 4 ]", "[ 6 : 10 ]", "[ 12 : 16 ]", "[ 18 : 22 ]", "[ 24 : 28 ]", "[ 30 : 32 ]"};
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)1L, (boolean)true, (boolean)false, (boolean)false, (boolean)true), res4_1);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)2L, (boolean)true, (boolean)false, (boolean)false, (boolean)true), res4_2);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)3L, (boolean)true, (boolean)false, (boolean)false, (boolean)true), res4_3);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)4L, (boolean)true, (boolean)false, (boolean)false, (boolean)true), res4_4);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)5L, (boolean)true, (boolean)false, (boolean)false, (boolean)true), res4_5);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)6L, (boolean)true, (boolean)false, (boolean)false, (boolean)true), res4_6);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)1L, (boolean)false, (boolean)false, (boolean)false, (boolean)true), res4_1);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)2L, (boolean)false, (boolean)false, (boolean)false, (boolean)true), res4_2);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)3L, (boolean)false, (boolean)false, (boolean)false, (boolean)true), res4_3);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)4L, (boolean)false, (boolean)false, (boolean)false, (boolean)true), res4_4);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)5L, (boolean)false, (boolean)false, (boolean)false, (boolean)true), res4_5);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)0L, (long)32L, (long)4L, (long)6L, (boolean)false, (boolean)false, (boolean)false, (boolean)true), res4_6);
    }

    @Test
    public void testNaturalMonthTimeRange() {
        String[] res1 = new String[]{"[ 1604102400000 : 1606694400000 ]", "[ 1606694400000 : 1609372800000 ]", "[ 1609372800000 : 1612051200000 ]", "[ 1612051200000 : 1614470400000 ]", "[ 1614470400000 : 1617148800000 ]"};
        String[] res2 = new String[]{"[ 1604102400000 : 1604966400000 ]", "[ 1606694400000 : 1607558400000 ]", "[ 1609372800000 : 1610236800000 ]", "[ 1612051200000 : 1612915200000 ]", "[ 1614470400000 : 1615334400000 ]"};
        String[] res3 = new String[]{"[ 1604102400000 : 1606694400000 ]", "[ 1604966400000 : 1607558400000 ]", "[ 1605830400000 : 1608422400000 ]", "[ 1606694400000 : 1609372800000 ]", "[ 1607558400000 : 1610236800000 ]", "[ 1608422400000 : 1611100800000 ]", "[ 1609286400000 : 1611964800000 ]", "[ 1610150400000 : 1612828800000 ]", "[ 1611014400000 : 1613692800000 ]", "[ 1611878400000 : 1614470400000 ]", "[ 1612742400000 : 1615161600000 ]", "[ 1613606400000 : 1616025600000 ]", "[ 1614470400000 : 1617148800000 ]", "[ 1615334400000 : 1617148800000 ]", "[ 1616198400000 : 1617148800000 ]", "[ 1617062400000 : 1617148800000 ]"};
        String[] res4 = new String[]{"[ 1604102400000 : 1604966400000 ]", "[ 1604966400000 : 1605830400000 ]", "[ 1605830400000 : 1606694400000 ]", "[ 1606694400000 : 1607558400000 ]", "[ 1607558400000 : 1608422400000 ]", "[ 1608422400000 : 1609286400000 ]", "[ 1609286400000 : 1609372800000 ]", "[ 1609372800000 : 1610150400000 ]", "[ 1610150400000 : 1610236800000 ]", "[ 1610236800000 : 1611014400000 ]", "[ 1611014400000 : 1611100800000 ]", "[ 1611100800000 : 1611878400000 ]", "[ 1611878400000 : 1611964800000 ]", "[ 1611964800000 : 1612742400000 ]", "[ 1612742400000 : 1612828800000 ]", "[ 1612828800000 : 1613606400000 ]", "[ 1613606400000 : 1613692800000 ]", "[ 1613692800000 : 1614470400000 ]", "[ 1614470400000 : 1615161600000 ]", "[ 1615161600000 : 1615334400000 ]", "[ 1615334400000 : 1616025600000 ]", "[ 1616025600000 : 1616198400000 ]", "[ 1616198400000 : 1617062400000 ]", "[ 1617062400000 : 1617148800000 ]"};
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)1604102400000L, (long)1617148800000L, (long)1L, (long)1L, (boolean)true, (boolean)true, (boolean)true, (boolean)false), res1);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)1604102400000L, (long)1617148800000L, (long)1L, (long)1L, (boolean)true, (boolean)true, (boolean)true, (boolean)true), res1);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)1604102400000L, (long)1617148800000L, (long)864000000L, (long)1L, (boolean)true, (boolean)false, (boolean)true, (boolean)false), res2);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)1604102400000L, (long)1617148800000L, (long)864000000L, (long)1L, (boolean)true, (boolean)false, (boolean)true, (boolean)true), res2);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)1604102400000L, (long)1617148800000L, (long)1L, (long)864000000L, (boolean)true, (boolean)true, (boolean)false, (boolean)false), res3);
        this.checkRes(TimeRangeIteratorFactory.getTimeRangeIterator((long)1604102400000L, (long)1617148800000L, (long)1L, (long)864000000L, (boolean)true, (boolean)true, (boolean)false, (boolean)true), res4);
    }

    private void checkRes(ITimeRangeIterator timeRangeIterator, String[] res) {
        int cnt;
        boolean isAscending = timeRangeIterator.isAscending();
        int n = cnt = isAscending ? 0 : res.length - 1;
        while (timeRangeIterator.hasNextTimeRange()) {
            TimeRange curTimeRange = timeRangeIterator.nextTimeRange();
            Assert.assertEquals((Object)res[cnt], (Object)curTimeRange.toString());
            cnt += isAscending ? 1 : -1;
        }
    }
}

