/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.exception.TsFileTimeseriesMetadataException;
import org.apache.iotdb.db.tools.TsFileSelfCheckTool;
import org.apache.iotdb.tsfile.exception.TsFileStatisticsMistakesException;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.LongStatistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileSelfCheckToolTest {
    String path = "data".concat(File.separator).concat("data").concat(File.separator).concat("sequence").concat(File.separator).concat("root.sg1").concat(File.separator).concat("0").concat(File.separator).concat("0").concat(File.separator);
    String device = "root.device_0";
    private static final Logger logger = LoggerFactory.getLogger(TsFileSelfCheckToolTest.class);

    public void setUp(String filePath) throws Exception {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(filePath);
            if (f.exists() && !f.delete()) {
                throw new RuntimeException("can not delete " + f.getAbsolutePath());
            }
            Schema schema = new Schema();
            String sensorPrefix = "sensor_";
            int rowNum = 1000000;
            int sensorNum = 10;
            ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
            for (int i = 0; i < sensorNum; ++i) {
                MeasurementSchema measurementSchema = new MeasurementSchema(sensorPrefix + (i + 1), TSDataType.INT64, TSEncoding.TS_2DIFF);
                measurementSchemas.add(measurementSchema);
                schema.registerTimeseries(new Path(this.device), new MeasurementSchema(sensorPrefix + (i + 1), TSDataType.INT64, TSEncoding.TS_2DIFF));
            }
            try (TsFileWriter tsFileWriter = new TsFileWriter(f, schema);){
                Tablet tablet = new Tablet(this.device, measurementSchemas);
                long[] timestamps = tablet.timestamps;
                Object[] values = tablet.values;
                long timestamp = 1L;
                long value = 1000000L;
                int r = 0;
                while (r < rowNum) {
                    ++tablet.rowSize;
                    ++timestamp;
                    for (int i = 0; i < sensorNum; ++i) {
                        long[] sensor = (long[])values[i];
                        sensor[row] = value;
                    }
                    if (tablet.rowSize == tablet.getMaxRowNumber()) {
                        tsFileWriter.write(tablet);
                        tablet.reset();
                    }
                    ++r;
                    ++value;
                }
                if (tablet.rowSize != 0) {
                    tsFileWriter.write(tablet);
                    tablet.reset();
                }
            }
        }
        catch (Exception e) {
            throw new Exception("meet error in TsFileWrite with tablet", e);
        }
    }

    @Test
    public void tsFileSelfCheckToolCompleteTest() throws Exception {
        String fileName = "1-0-0-1.tsfile";
        String filePath = this.path.concat(fileName);
        this.setUp(filePath);
        TsFileSelfCheckTool tool = new TsFileSelfCheckTool();
        try {
            tool.check(filePath, false);
        }
        catch (IOException | TsFileTimeseriesMetadataException | TsFileStatisticsMistakesException e) {
            Assert.fail((String)e.getMessage());
        }
        this.tearDown(filePath);
    }

    @Test
    public void tsFileSelfCheckToolWithStatisticsModifiedTest() throws IOException, TsFileTimeseriesMetadataException, Exception {
        String fileName = "1-0-0-2.tsfile";
        String filePath = this.path.concat(fileName);
        this.setUp(filePath);
        Map timeseriesMetadataMap = new TsFileSelfCheckTool().getTimeseriesMetadataMapWithPath(filePath);
        Iterator iterator = timeseriesMetadataMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)((Pair)entry.getValue()).right;
            Long pos = (Long)entry.getKey();
            LongStatistics statistics = (LongStatistics)timeseriesMetadata.getStatistics();
            statistics.initializeStats(666L, 1999999L, 1000000L, 1999999L, 0.0);
            RandomAccessFile raf = new RandomAccessFile(filePath, "rw");
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            int serialLength = ReadWriteIOUtils.write((byte)timeseriesMetadata.getTimeSeriesMetadataType(), (OutputStream)bo);
            serialLength += ReadWriteIOUtils.writeVar((String)timeseriesMetadata.getMeasurementId(), (OutputStream)bo);
            serialLength += ReadWriteIOUtils.write((TSDataType)timeseriesMetadata.getTSDataType(), (OutputStream)bo);
            serialLength += ReadWriteForEncodingUtils.writeUnsignedVarInt((int)timeseriesMetadata.getDataSizeOfChunkMetaDataList(), (ByteArrayOutputStream)bo);
            logger.info("serialLength: " + (serialLength += statistics.serialize((OutputStream)bo)));
            byte[] serialArr = bo.toByteArray();
            raf.seek(pos);
            raf.write(serialArr, 0, serialArr.length);
            bo.close();
            raf.close();
        }
        TsFileSelfCheckTool tool = new TsFileSelfCheckTool();
        try {
            tool.check(filePath, false);
            Assert.fail((String)"No exception thrown.");
        }
        catch (TsFileStatisticsMistakesException e) {
            Assert.assertEquals((Object)"Chunk exists statistics mistakes at position 22", (Object)e.getMessage());
        }
        this.tearDown(filePath);
    }

    @Test
    public void tsFileSelfCheckToolWithRandomModifiedTest() throws IOException, Exception {
        String fileName = "1-0-0-3.tsfile";
        String filePath = this.path.concat(fileName);
        this.setUp(filePath);
        RandomAccessFile raf = new RandomAccessFile(filePath, "rw");
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ReadWriteIOUtils.write((int)100, (OutputStream)bo);
        byte[] serialArr = bo.toByteArray();
        raf.seek(878375L);
        raf.write(serialArr, 0, serialArr.length);
        bo.close();
        raf.close();
        TsFileSelfCheckTool tool = new TsFileSelfCheckTool();
        try {
            tool.check(filePath, false);
            Assert.fail((String)"No exception thrown.");
        }
        catch (TsFileTimeseriesMetadataException e) {
            Assert.assertEquals((Object)"Error occurred while getting all TimeseriesMetadata with offset in TsFile.", (Object)e.getMessage());
        }
        this.tearDown(filePath);
    }

    public void tearDown(String filePath) {
        try {
            FileUtils.forceDelete((File)new File(filePath));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

