/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupEntityMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFile;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.tools.schema.SchemaFileSketchTool;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaFileSketchTest {
    @Before
    public void setUp() {
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Schema_File.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        File sketch = new File("sketch_schemafile.txt");
        sketch.deleteOnExit();
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    private void prepareData() throws IOException, MetadataException {
        int TEST_SCHEMA_REGION_ID = 0;
        ISchemaFile sf = SchemaFile.initSchemaFile((String)"root.test.vRoot1", (int)TEST_SCHEMA_REGION_ID);
        Iterator<IMNode> ite = this.getTreeBFT(this.getFlatTree(500, "aa"));
        while (ite.hasNext()) {
            IMNode cur = ite.next();
            if (cur.isMeasurement()) continue;
            sf.writeMNode(cur);
        }
        sf.close();
    }

    @Test
    public void testSchemaFileSketch() throws Exception {
        this.prepareData();
        File file = new File("target" + File.separator + "tmp" + File.separator + "system" + File.separator + "schema" + File.separator + "root.test.vRoot1" + File.separator + "0" + File.separator + "schema_file.pst");
        File sketchFile = new File("sketch_schemafile.txt");
        SchemaFileSketchTool.sketchFile((String)file.getAbsolutePath(), (String)sketchFile.getAbsolutePath());
        ISchemaFile sf = SchemaFile.loadSchemaFile((File)file);
        String sketchString = ((SchemaFile)sf).inspect();
        Assert.assertEquals((Object)sketchString, (Object)new String(Files.readAllBytes(Paths.get(sketchFile.getAbsolutePath(), new String[0]))));
        sf.close();
    }

    private Iterator<IMNode> getTreeBFT(final IMNode root) {
        return new Iterator<IMNode>(){
            Queue<IMNode> queue = new LinkedList<IMNode>();
            {
                this.queue.add(root);
            }

            @Override
            public boolean hasNext() {
                return this.queue.size() > 0;
            }

            @Override
            public IMNode next() {
                IMNode curNode = this.queue.poll();
                if (!curNode.isMeasurement() && curNode.getChildren().size() > 0) {
                    for (IMNode child : curNode.getChildren().values()) {
                        this.queue.add(child);
                    }
                }
                return curNode;
            }
        };
    }

    private IMNode getFlatTree(int flatSize, String id) {
        InternalMNode root = new InternalMNode(null, "root");
        InternalMNode test = new InternalMNode((IMNode)root, "test");
        StorageGroupEntityMNode internalNode = new StorageGroupEntityMNode(null, "vRoot1", 0L);
        for (int idx = 0; idx < flatSize; ++idx) {
            String measurementId = id + idx;
            MeasurementSchema schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            IMeasurementMNode mNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)internalNode.getAsEntityMNode(), (String)measurementId, (IMeasurementSchema)schema, (String)(measurementId + "als"));
            internalNode.addChild((IMNode)mNode);
        }
        test.addChild((IMNode)internalNode);
        return internalNode;
    }
}

