/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.tools.schema.MLogParser;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MLogParserTest {
    private String[] storageGroups = new String[]{"root.sg0", "root.sg1", "root.sgcc", "root.sg"};
    private int[] storageGroupIndex = new int[]{0, 1, 3, 4};
    private int[] mlogLineNum = new int[]{50, 53, 0, 3};
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        File file = new File("target" + File.separator + "tmp" + File.separator + "text.mlog");
        file.deleteOnExit();
        file = new File("target" + File.separator + "tmp" + File.separator + "text.snapshot");
        file.deleteOnExit();
    }

    private void prepareData() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 10; ++k) {
                    CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan();
                    try {
                        plan.setPath(new PartialPath("root.sg" + i + ".device" + j + ".s" + k));
                        plan.setDataType(TSDataType.INT32);
                        plan.setEncoding(TSEncoding.PLAIN);
                        plan.setCompressor(CompressionType.GZIP);
                        IoTDB.schemaProcessor.createTimeseries(plan);
                        continue;
                    }
                    catch (MetadataException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.ln.cc"));
            IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.sgcc"));
            IoTDB.schemaProcessor.setTTL(new PartialPath("root.sgcc"), 1234L);
            IoTDB.schemaProcessor.deleteTimeseries(new PartialPath("root.sg1.device1.s1"));
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            paths.add(new PartialPath("root.ln.cc"));
            IoTDB.schemaProcessor.deleteStorageGroups(paths);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tag1", "value1");
            IoTDB.schemaProcessor.addTags(tags, new PartialPath("root.sg1.device1.s2"));
            IoTDB.schemaProcessor.changeAlias(new PartialPath("root.sg1.device1.s3"), "hello");
        }
        catch (IOException | MetadataException e) {
            e.printStackTrace();
        }
        try {
            IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.sg"));
            IoTDB.schemaProcessor.createSchemaTemplate(this.genCreateSchemaTemplatePlan());
            SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg");
            IoTDB.schemaProcessor.setSchemaTemplate(setTemplatePlan);
            IoTDB.schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg.d1")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    private CreateTemplatePlan genCreateSchemaTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s11"));
        measurementList.add(Collections.singletonList("s12"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Collections.singletonList(TSDataType.DOUBLE));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s11");
        schemaNames.add("s12");
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    @Test
    public void testMLogParser() throws Exception {
        this.prepareData();
        this.testNonExistingStorageGroupDir("root.ln.cc");
        IoTDB.schemaProcessor.forceMlog();
        this.testParseStorageGroupLog();
        for (int i = 0; i < this.storageGroups.length; ++i) {
            this.testParseMLog(this.storageGroups[i], this.storageGroupIndex[i], this.mlogLineNum[i]);
        }
        this.testParseTemplateLogFile();
    }

    private void testNonExistingStorageGroupDir(String storageGroup) {
        File storageGroupDir = new File(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + storageGroup);
        Assert.assertFalse((boolean)storageGroupDir.exists());
    }

    private void testParseStorageGroupLog() throws IOException {
        this.testParseLog(this.config.getSchemaDir() + File.separator + "storage_group_log.bin", 7);
    }

    private void testParseTemplateLogFile() throws IOException {
        this.testParseLog(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + "template_log.bin", 1);
    }

    private void testParseMLog(String storageGroup, int storageGroupId, int expectedLineNum) throws IOException {
        this.testParseLog(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + storageGroup + File.separator + storageGroupId + File.separator + "mlog.bin", expectedLineNum);
    }

    private void testParseLog(String path, int expectedNum) throws IOException {
        File file = new File("target" + File.separator + "tmp" + File.separator + "text.mlog");
        file.delete();
        MLogParser.parseFromFile((String)path, (String)("target" + File.separator + "tmp" + File.separator + "text.mlog"));
        try (BufferedReader reader = new BufferedReader(new FileReader("target" + File.separator + "tmp" + File.separator + "text.mlog"));){
            String line;
            int lineNum = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                lines.add(line);
            }
            if (lineNum != expectedNum) {
                for (String content : lines) {
                    System.out.println(content);
                }
            }
            Assert.assertEquals((long)expectedNum, (long)lineNum);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

