/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.recovery;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.sync.SyncPathUtil;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.qp.physical.sys.CreatePipePlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.sync.common.persistence.SyncLogReader;
import org.apache.iotdb.db.sync.common.persistence.SyncLogWriter;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.PipeInfo;
import org.apache.iotdb.db.sync.sender.pipe.PipeMessage;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyncLogTest {
    private static final String pipe1 = "pipe1";
    private static final String pipe2 = "pipe2";
    private static final String ip1 = "192.168.1.11";
    private static final String ip2 = "192.168.2.22";
    private static final long createdTime1 = System.currentTimeMillis();
    private static final long createdTime2 = System.currentTimeMillis() + 1L;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testServiceLog() {
        try {
            SyncLogWriter log = SyncLogWriter.getInstance();
            CreatePipeSinkPlan createPipeSinkPlan = new CreatePipeSinkPlan("demo", "iotdb");
            createPipeSinkPlan.addPipeSinkAttribute("ip", "127.0.0.1");
            createPipeSinkPlan.addPipeSinkAttribute("port", "6670");
            log.addPipeSink(createPipeSinkPlan);
            log.addPipe(new CreatePipePlan(pipe1, "demo"), 1L);
            log.operatePipe(pipe1, StatementType.DROP_PIPE);
            log.addPipe(new CreatePipePlan(pipe2, "demo"), 2L);
            log.operatePipe(pipe1, StatementType.STOP_PIPE);
            log.operatePipe(pipe1, StatementType.START_PIPE);
            log.close();
            SyncLogReader syncLogReader = new SyncLogReader();
            syncLogReader.recover();
            List pipes = syncLogReader.getAllPipeInfos();
            Map allPipeSinks = syncLogReader.getAllPipeSinks();
            PipeInfo runningPipe = syncLogReader.getRunningPipeInfo();
            Assert.assertEquals((long)1L, (long)allPipeSinks.size());
            Assert.assertEquals((long)2L, (long)pipes.size());
            Assert.assertEquals((Object)pipe2, (Object)runningPipe.getPipeName());
            for (PipeInfo p : pipes) {
                if (p.getPipeName().equals(pipe1)) {
                    Assert.assertEquals((long)1L, (long)p.getCreateTime());
                    Assert.assertEquals((Object)"demo", (Object)p.getPipeSinkName());
                    continue;
                }
                if (!p.getPipeName().equals(pipe2)) continue;
                Assert.assertEquals((long)2L, (long)p.getCreateTime());
                Assert.assertEquals((Object)"demo", (Object)p.getPipeSinkName());
            }
            Assert.assertEquals((Object)Pipe.PipeStatus.RUNNING, (Object)runningPipe.getStatus());
        }
        catch (Exception e) {
            Assert.fail();
            e.printStackTrace();
        }
    }

    @Test
    public void testMessageLog() {
        String pipeIdentifier1 = SyncPathUtil.getReceiverPipeDirName((String)pipe1, (String)ip1, (long)createdTime1);
        String pipeIdentifier2 = SyncPathUtil.getReceiverPipeDirName((String)pipe2, (String)ip2, (long)createdTime2);
        try {
            SyncLogWriter log = SyncLogWriter.getInstance();
            PipeMessage info = new PipeMessage(PipeMessage.MsgType.INFO, "info");
            PipeMessage warn = new PipeMessage(PipeMessage.MsgType.WARN, "warn");
            PipeMessage error = new PipeMessage(PipeMessage.MsgType.ERROR, "error");
            log.writePipeMsg(pipeIdentifier1, info);
            log.writePipeMsg(pipeIdentifier1, warn);
            log.comsumePipeMsg(pipeIdentifier1);
            log.writePipeMsg(pipeIdentifier1, error);
            log.writePipeMsg(pipeIdentifier1, info);
            log.writePipeMsg(pipeIdentifier1, warn);
            log.writePipeMsg(pipeIdentifier2, error);
            log.comsumePipeMsg(pipeIdentifier2);
            log.close();
            SyncLogReader syncLogReader = new SyncLogReader();
            syncLogReader.recover();
            Map map = syncLogReader.getPipeMessageMap();
            Assert.assertNotNull((Object)map);
            Assert.assertEquals((long)3L, (long)((List)map.get(pipeIdentifier1)).size());
            Assert.assertNull(map.get(pipeIdentifier2));
            Assert.assertEquals((Object)error, ((List)map.get(pipeIdentifier1)).get(0));
            Assert.assertEquals((Object)info, ((List)map.get(pipeIdentifier1)).get(1));
            Assert.assertEquals((Object)warn, ((List)map.get(pipeIdentifier1)).get(2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

