/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.manager;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.sync.PipeException;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.qp.physical.sys.CreatePipePlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.sync.common.SyncInfo;
import org.apache.iotdb.db.sync.sender.pipe.PipeMessage;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SyncInfoTest {
    private static final String pipe1 = "pipe1";
    private static final String pipe2 = "pipe2";
    private static final long createdTime1 = System.currentTimeMillis();
    private static final long createdTime2 = System.currentTimeMillis() + 1L;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOperatePipe() throws Exception {
        try (SyncInfo syncInfo = new SyncInfo();){
            CreatePipeSinkPlan createPipeSinkPlan = new CreatePipeSinkPlan("demo", "iotdb");
            createPipeSinkPlan.addPipeSinkAttribute("ip", "127.0.0.1");
            createPipeSinkPlan.addPipeSinkAttribute("port", "6670");
            try {
                syncInfo.addPipe(new CreatePipePlan(pipe1, "demo"), createdTime1);
                Assert.fail();
            }
            catch (PipeException pipeException) {
                // empty catch block
            }
            syncInfo.addPipeSink(createPipeSinkPlan);
            syncInfo.addPipe(new CreatePipePlan(pipe1, "demo"), createdTime1);
            try {
                syncInfo.addPipe(new CreatePipePlan(pipe2, "demo"), createdTime2);
                Assert.fail();
            }
            catch (PipeException pipeException) {
                // empty catch block
            }
            syncInfo.operatePipe(pipe1, StatementType.DROP_PIPE);
            syncInfo.addPipe(new CreatePipePlan(pipe2, "demo"), createdTime2);
            syncInfo.operatePipe(pipe2, StatementType.STOP_PIPE);
            syncInfo.operatePipe(pipe2, StatementType.START_PIPE);
            Assert.assertEquals((long)2L, (long)syncInfo.getAllPipeInfos().size());
            Assert.assertEquals((long)1L, (long)syncInfo.getAllPipeSink().size());
            PipeMessage info = new PipeMessage(PipeMessage.MsgType.INFO, "info");
            PipeMessage warn = new PipeMessage(PipeMessage.MsgType.WARN, "warn");
            PipeMessage error = new PipeMessage(PipeMessage.MsgType.ERROR, "error");
            syncInfo.writePipeMessage(pipe2, createdTime2, info);
            syncInfo.writePipeMessage(pipe2, createdTime2, warn);
            List messages = syncInfo.getPipeMessages(pipe2, createdTime2, true);
            Assert.assertEquals((long)2L, (long)messages.size());
            Assert.assertEquals((Object)info, messages.get(0));
            Assert.assertEquals((Object)warn, messages.get(1));
            syncInfo.writePipeMessage(pipe2, createdTime2, error);
            messages = syncInfo.getPipeMessages(pipe2, createdTime2, true);
            Assert.assertEquals((long)1L, (long)messages.size());
            Assert.assertEquals((Object)error, messages.get(0));
        }
    }
}

