/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.pipedata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.sync.pipedata.DeletionPipeData;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.SchemaPipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataTest {
    private static final Logger logger = LoggerFactory.getLogger(PipeDataTest.class);
    private static final String pipeLogPath = "target/pipelog";

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
        Files.deleteIfExists(Paths.get(pipeLogPath, new String[0]));
    }

    @Test
    public void testSerializeAndDeserialize() {
        try {
            File f1 = new File(pipeLogPath);
            File f2 = new File(pipeLogPath);
            TsFilePipeData pipeData1 = new TsFilePipeData("1", 1L);
            Deletion deletion = new Deletion(new PartialPath("root.sg1.d1.s1"), 0L, 1L, 5L);
            DeletionPipeData pipeData2 = new DeletionPipeData(deletion, 3L);
            SetStorageGroupPlan plan = new SetStorageGroupPlan(new PartialPath("root.sg1"));
            SchemaPipeData pipeData3 = new SchemaPipeData((PhysicalPlan)plan, 2L);
            DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(f2));
            pipeData1.serialize(outputStream);
            outputStream.flush();
            DataInputStream inputStream = new DataInputStream(new FileInputStream(f1));
            Assert.assertEquals((Object)pipeData1, (Object)PipeData.createPipeData((DataInputStream)inputStream));
            pipeData2.serialize(outputStream);
            outputStream.flush();
            Assert.assertEquals((Object)pipeData2, (Object)PipeData.createPipeData((DataInputStream)inputStream));
            pipeData3.serialize(outputStream);
            outputStream.flush();
            Assert.assertEquals((Object)pipeData3, (Object)PipeData.createPipeData((DataInputStream)inputStream));
            inputStream.close();
            outputStream.close();
            Assert.assertEquals((Object)pipeData1, (Object)PipeData.createPipeData((byte[])pipeData1.serialize()));
            Assert.assertEquals((Object)pipeData2, (Object)PipeData.createPipeData((byte[])pipeData2.serialize()));
            Assert.assertEquals((Object)pipeData3, (Object)PipeData.createPipeData((byte[])pipeData3.serialize()));
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            Assert.fail();
        }
    }
}

