/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.sync.datasource.TsFileOpBlock;
import org.apache.iotdb.db.sync.externalpipe.operation.InsertOperation;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileOpBlockTest {
    public final String TMP_DIR = "target";
    private final String tsFileName1 = "target" + File.separator + "test1.tsfile";
    private final String tsFileName2 = "target" + File.separator + "test2.tsfile";
    private final String modsFileName2 = this.tsFileName2 + ".mods";
    private final String tsFileName3 = "target" + File.separator + "test3.tsfile";
    private final String modsFileName3 = this.tsFileName3 + ".mods";
    public final List<String> fileNameList = new LinkedList<String>();
    public final String DEFAULT_TEMPLATE = "template";

    @Before
    public void prepareTestData() throws Exception {
        this.createTsfile1(this.tsFileName1);
        this.fileNameList.add(this.tsFileName1);
        this.createTsfile2(this.tsFileName2);
        this.fileNameList.add(this.tsFileName2);
        this.creatModsFile2(this.modsFileName2);
        this.fileNameList.add(this.modsFileName2);
        this.createTsfile2(this.tsFileName3);
        this.fileNameList.add(this.tsFileName3);
        this.creatModsFile3(this.modsFileName3);
        this.fileNameList.add(this.modsFileName3);
    }

    @After
    public void removeTestData() throws Exception {
        for (String fileName : this.fileNameList) {
            File file = new File(fileName);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    private void createTsfile1(String tsfilePath) throws Exception {
        File file = new File(tsfilePath);
        if (file.exists()) {
            file.delete();
        }
        Schema schema = new Schema();
        schema.extendTemplate("template", new MeasurementSchema("sensor1", TSDataType.FLOAT, TSEncoding.RLE));
        schema.extendTemplate("template", new MeasurementSchema("sensor2", TSDataType.INT32, TSEncoding.TS_2DIFF));
        schema.extendTemplate("template", new MeasurementSchema("sensor3", TSDataType.INT32, TSEncoding.TS_2DIFF));
        TsFileWriter tsFileWriter = new TsFileWriter(file, schema);
        TSRecord tsRecord = new TSRecord(1617206403001L, "root.lemming.device1");
        FloatDataPoint dPoint1 = new FloatDataPoint("sensor1", 1.1f);
        IntDataPoint dPoint2 = new IntDataPoint("sensor2", 12);
        IntDataPoint dPoint3 = new IntDataPoint("sensor3", 13);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403002L, "root.lemming.device2");
        dPoint2 = new IntDataPoint("sensor2", 22);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403003L, "root.lemming.device3");
        dPoint1 = new FloatDataPoint("sensor1", 3.1f);
        dPoint2 = new IntDataPoint("sensor2", 32);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsFileWriter.close();
    }

    @Test(timeout=10000L)
    public void testOpBlock() throws IOException {
        TsFileOpBlock tsFileOpBlock = new TsFileOpBlock("root", this.tsFileName1, 0L);
        Assert.assertEquals((Object)"root", (Object)tsFileOpBlock.getStorageGroup());
        Assert.assertEquals((long)0L, (long)tsFileOpBlock.getBeginIndex());
        Assert.assertEquals((long)6L, (long)tsFileOpBlock.getDataCount());
        Assert.assertEquals((long)6L, (long)tsFileOpBlock.getNextIndex());
        tsFileOpBlock.setBeginIndex(2L);
        Assert.assertEquals((long)8L, (long)tsFileOpBlock.getNextIndex());
        Operation operation = null;
        int i = 0;
        while ((long)i < tsFileOpBlock.getDataCount()) {
            operation = tsFileOpBlock.getOperation((long)(i + 2), 1L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)1L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i + 2), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i + 3), (long)operation.getEndIndex());
            Assert.assertEquals((Object)true, (Object)(operation instanceof InsertOperation));
            InsertOperation insertOperation = (InsertOperation)operation;
            Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
            ++i;
        }
        InsertOperation insertOperation = (InsertOperation)operation;
        int k = 0;
        Assert.assertEquals((Object)"root.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)k)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)k)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"32", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)k)).right).get(0)).getValue().toString());
        int i2 = 0;
        while ((long)i2 <= tsFileOpBlock.getDataCount() - 3L) {
            operation = tsFileOpBlock.getOperation((long)(i2 + 2), 3L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)3L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i2 + 2), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i2 + 5), (long)operation.getEndIndex());
            ++i2;
        }
        for (long i3 = 6L; i3 < 8L; ++i3) {
            operation = tsFileOpBlock.getOperation(i3, 3L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)(8L - i3), (long)operation.getDataCount());
            Assert.assertEquals((long)i3, (long)operation.getStartIndex());
            Assert.assertEquals((long)8L, (long)operation.getEndIndex());
        }
        tsFileOpBlock.close();
    }

    private void createTsfile2(String tsfilePath) throws Exception {
        File file = new File(tsfilePath);
        if (file.exists()) {
            file.delete();
        }
        Schema schema = new Schema();
        schema.extendTemplate("template", new MeasurementSchema("sensor1", TSDataType.FLOAT, TSEncoding.RLE));
        schema.extendTemplate("template", new MeasurementSchema("sensor2", TSDataType.INT32, TSEncoding.TS_2DIFF));
        schema.extendTemplate("template", new MeasurementSchema("sensor3", TSDataType.INT32, TSEncoding.TS_2DIFF));
        TsFileWriter tsFileWriter = new TsFileWriter(file, schema);
        TSRecord tsRecord = new TSRecord(1617206403001L, "root.lemming.device1");
        FloatDataPoint dPoint1 = new FloatDataPoint("sensor1", 1.1f);
        IntDataPoint dPoint2 = new IntDataPoint("sensor2", 12);
        IntDataPoint dPoint3 = new IntDataPoint("sensor3", 13);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403002L, "root.lemming.device2");
        dPoint2 = new IntDataPoint("sensor2", 22);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403003L, "root.lemming.device3");
        dPoint1 = new FloatDataPoint("sensor1", 3.1f);
        dPoint2 = new IntDataPoint("sensor2", 32);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsRecord = new TSRecord(1617206403004L, "root.lemming.device1");
        dPoint1 = new FloatDataPoint("sensor1", 4.1f);
        dPoint2 = new IntDataPoint("sensor2", 42);
        dPoint3 = new IntDataPoint("sensor3", 43);
        tsRecord.addTuple((DataPoint)dPoint1);
        tsRecord.addTuple((DataPoint)dPoint2);
        tsRecord.addTuple((DataPoint)dPoint3);
        tsFileWriter.write(tsRecord);
        tsFileWriter.flushAllChunkGroups();
        tsFileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creatModsFile2(String modsFilePath) throws IllegalPathException {
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath("root.lemming.device1.sensor1"), 2L, 1L), new Deletion(new PartialPath("root.lemming.device1.sensor1"), 3L, 2L, 5L), new Deletion(new PartialPath("root.lemming.**"), 11L, 1L, Long.MAX_VALUE)};
        try (ModificationFile mFile = new ModificationFile(modsFilePath);){
            for (Modification mod : modifications) {
                mFile.write(mod);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creatModsFile3(String modsFilePath) throws IllegalPathException {
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath("root.lemming.device1.sensor1"), 2L, 1617206403001L), new Deletion(new PartialPath("root.lemming.device2.*"), 3L, 2L, Long.MAX_VALUE)};
        try (ModificationFile mFile = new ModificationFile(modsFilePath);){
            for (Modification mod : modifications) {
                mFile.write(mod);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testOpBlockMods2() throws IOException {
        List modificationList = null;
        try (ModificationFile mFile = new ModificationFile(this.modsFileName2);){
            modificationList = (List)mFile.getModifications();
        }
        TsFileOpBlock tsFileOpBlock = new TsFileOpBlock("root", this.tsFileName2, this.modsFileName2, 0L);
        Assert.assertEquals((Object)"root", (Object)tsFileOpBlock.getStorageGroup());
        Assert.assertEquals((long)0L, (long)tsFileOpBlock.getBeginIndex());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getDataCount());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getNextIndex());
        tsFileOpBlock.setBeginIndex(55L);
        Assert.assertEquals((long)64L, (long)tsFileOpBlock.getNextIndex());
        Assert.assertNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertNull((Object)tsFileOpBlock.getModificationList());
        Operation operation = tsFileOpBlock.getOperation(55L, 1L);
        Assert.assertNotNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertEquals((Object)modificationList, (Object)tsFileOpBlock.getModificationList());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getDataCount());
        int i = 0;
        while ((long)i < tsFileOpBlock.getDataCount()) {
            operation = tsFileOpBlock.getOperation((long)(i + 55), 1L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)1L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i + 55), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i + 56), (long)operation.getEndIndex());
            Assert.assertEquals((Object)true, (Object)(operation instanceof InsertOperation));
            InsertOperation insertOperation = (InsertOperation)operation;
            Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
            ++i;
        }
        operation = tsFileOpBlock.getOperation(55L, 15L);
        Assert.assertEquals((long)9L, (long)operation.getDataCount());
        InsertOperation insertOperation = (InsertOperation)operation;
        int i2 = 0;
        Assert.assertEquals((Object)"root.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 1;
        Assert.assertEquals((Object)"root.lemming.device1.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 2;
        Assert.assertEquals((Object)"root.lemming.device1.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 3;
        Assert.assertEquals((Object)"root.lemming.device2.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 4;
        Assert.assertEquals((Object)"root.lemming.device3.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 5;
        Assert.assertEquals((Object)"root.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        tsFileOpBlock.close();
    }

    @Test(timeout=10000L)
    public void testOpBlockMods3() throws IOException {
        List modificationList = null;
        try (ModificationFile mFile = new ModificationFile(this.modsFileName3);){
            modificationList = (List)mFile.getModifications();
        }
        TsFileOpBlock tsFileOpBlock = new TsFileOpBlock("root", this.tsFileName2, this.modsFileName3, 0L);
        Assert.assertEquals((Object)"root", (Object)tsFileOpBlock.getStorageGroup());
        Assert.assertEquals((long)0L, (long)tsFileOpBlock.getBeginIndex());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getDataCount());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getNextIndex());
        tsFileOpBlock.setBeginIndex(55L);
        Assert.assertEquals((long)64L, (long)tsFileOpBlock.getNextIndex());
        Assert.assertNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertNull((Object)tsFileOpBlock.getModificationList());
        Operation operation = tsFileOpBlock.getOperation(55L, 1L);
        Assert.assertNotNull((Object)tsFileOpBlock.getFullPathToDeletionMap());
        Assert.assertEquals((Object)modificationList, (Object)tsFileOpBlock.getModificationList());
        Assert.assertEquals((long)9L, (long)tsFileOpBlock.getDataCount());
        int i = 0;
        while ((long)i < tsFileOpBlock.getDataCount()) {
            operation = tsFileOpBlock.getOperation((long)(i + 55), 1L);
            Assert.assertEquals((Object)"root", (Object)operation.getStorageGroup());
            Assert.assertEquals((long)1L, (long)operation.getDataCount());
            Assert.assertEquals((long)(i + 55), (long)operation.getStartIndex());
            Assert.assertEquals((long)(i + 56), (long)operation.getEndIndex());
            Assert.assertEquals((Object)true, (Object)(operation instanceof InsertOperation));
            InsertOperation insertOperation = (InsertOperation)operation;
            Assert.assertEquals((long)1L, (long)insertOperation.getDataList().size());
            ++i;
        }
        operation = tsFileOpBlock.getOperation(55L, 20L);
        Assert.assertEquals((long)9L, (long)operation.getDataCount());
        InsertOperation insertOperation = (InsertOperation)operation;
        int i2 = 0;
        Assert.assertEquals((Object)"root.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 1;
        Assert.assertEquals((Object)"root.lemming.device1.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403001L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"12", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 2;
        Assert.assertEquals((Object)"root.lemming.device1.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403001L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"13", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 3;
        Assert.assertEquals((Object)"root.lemming.device2.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals(null, ((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0));
        i2 = 4;
        Assert.assertEquals((Object)"root.lemming.device3.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"3.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 5;
        Assert.assertEquals((Object)"root.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"32", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 6;
        Assert.assertEquals((Object)"root.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"4.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 7;
        Assert.assertEquals((Object)"root.lemming.device1.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"42", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 8;
        Assert.assertEquals((Object)"root.lemming.device1.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"43", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        operation = tsFileOpBlock.getOperation(59L, 20L);
        Assert.assertEquals((long)5L, (long)operation.getDataCount());
        insertOperation = (InsertOperation)operation;
        i2 = 0;
        Assert.assertEquals((Object)"root.lemming.device3.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"3.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 1;
        Assert.assertEquals((Object)"root.lemming.device3.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403003L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"32", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 2;
        Assert.assertEquals((Object)"root.lemming.device1.sensor1", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"4.1", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 3;
        Assert.assertEquals((Object)"root.lemming.device1.sensor2", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"42", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        i2 = 4;
        Assert.assertEquals((Object)"root.lemming.device1.sensor3", (Object)((MeasurementPath)((Pair)insertOperation.getDataList().get((int)i2)).left).getFullPath());
        Assert.assertEquals((long)1617206403004L, (long)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getTimestamp());
        Assert.assertEquals((Object)"43", (Object)((TimeValuePair)((List)((Pair)insertOperation.getDataList().get((int)i2)).right).get(0)).getValue().toString());
        tsFileOpBlock.close();
    }
}

