/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.SerializableIntTVList;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.SerializableTVList;
import org.apache.iotdb.db.query.udf.datastructure.SerializableTVListTest;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class SerializableIntTVListTest
extends SerializableTVListTest {
    private List<Integer> originalList;
    private SerializableIntTVList testList;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.originalList = new ArrayList<Integer>();
        this.testList = (SerializableIntTVList)SerializableTVList.newSerializableTVList((TSDataType)TSDataType.INT32, (long)0L);
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    @Override
    protected void generateData(int index) {
        this.originalList.add(index);
        this.testList.putInt((long)index, index);
    }

    @Override
    protected void serializeAndDeserializeOnce() {
        try {
            this.testList.serialize();
        }
        catch (IOException e) {
            Assert.fail();
        }
        try {
            this.testList.deserialize();
        }
        catch (IOException e) {
            Assert.fail();
        }
        int count = 0;
        while (this.testList.hasCurrent()) {
            Assert.assertEquals((long)count, (long)this.testList.currentTime());
            Assert.assertEquals((float)this.originalList.get(count).intValue(), (float)this.testList.getInt(), (float)0.0f);
            this.testList.next();
            ++count;
        }
        Assert.assertEquals((long)10000L, (long)count);
    }
}

