/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.datastructure;

import java.util.Random;
import org.apache.iotdb.db.query.udf.datastructure.LRUCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCacheTest {
    private static final Logger logger = LoggerFactory.getLogger(LRUCacheTest.class);
    private static final int CACHE_SIZE = 3;
    private static final int DATA_SIZE = 24;
    private LRUCache cache;
    private int PERFORMANCE_CACHE_SIZE = 60;
    private LRUCache performance_cache;
    private int LOOP_COUNT = 50;
    private int PER_LOOP_NUM = 10000000;
    private Random r = new Random();

    @Before
    public void setUp() {
        this.cache = new LRUCache(3);
        this.performance_cache = new LRUCache(this.PERFORMANCE_CACHE_SIZE);
    }

    @Test
    public void testPutAndGetRandomly() {
        this.cache.set(0, 0);
        Assert.assertEquals((long)0L, (long)this.cache.get(0));
        this.cache.set(4, 4);
        Assert.assertEquals((long)4L, (long)this.cache.get(4));
        this.cache.set(10, 10);
        Assert.assertEquals((long)10L, (long)this.cache.get(10));
        Assert.assertEquals((long)0L, (long)this.cache.get(0));
        Assert.assertEquals((long)4L, (long)this.cache.get(4));
        Assert.assertEquals((long)10L, (long)this.cache.get(10));
        this.cache.set(23, 23);
        Assert.assertEquals((long)23L, (long)this.cache.get(23));
        this.cache.set(21, 21);
        Assert.assertEquals((long)21L, (long)this.cache.get(21));
        this.cache.set(18, 18);
        Assert.assertEquals((long)18L, (long)this.cache.get(18));
        Assert.assertEquals((long)23L, (long)this.cache.get(23));
        Assert.assertEquals((long)21L, (long)this.cache.get(21));
        Assert.assertEquals((long)18L, (long)this.cache.get(18));
        Assert.assertEquals((long)0L, (long)this.cache.get(0));
        Assert.assertEquals((long)4L, (long)this.cache.get(4));
        Assert.assertEquals((long)10L, (long)this.cache.get(10));
        this.cache.set(1, 1);
        Assert.assertEquals((long)1L, (long)this.cache.get(1));
        this.cache.set(3, 3);
        Assert.assertEquals((long)3L, (long)this.cache.get(3));
        Assert.assertEquals((long)23L, (long)this.cache.get(23));
        Assert.assertEquals((long)21L, (long)this.cache.get(21));
        Assert.assertEquals((long)18L, (long)this.cache.get(18));
        Assert.assertEquals((long)0L, (long)this.cache.get(0));
        Assert.assertEquals((long)4L, (long)this.cache.get(4));
        Assert.assertEquals((long)10L, (long)this.cache.get(10));
        Assert.assertEquals((long)1L, (long)this.cache.get(1));
        Assert.assertEquals((long)3L, (long)this.cache.get(3));
    }

    @Test
    public void testPutAndGetOrderly() {
        int i;
        for (i = 0; i < 24; ++i) {
            this.cache.set(i, i);
        }
        for (i = 0; i < 24; ++i) {
            Assert.assertEquals((long)i, (long)this.cache.get(i));
        }
        for (i = 0; i < 24; ++i) {
            this.cache.set(i, 24 - i);
        }
        for (i = 0; i < 24; ++i) {
            Assert.assertEquals((long)(24 - i), (long)this.cache.get(i));
        }
        for (i = 23; 0 <= i; --i) {
            this.cache.set(i, i);
        }
        for (i = 0; i < 24; ++i) {
            this.cache.set(i, i);
        }
        for (i = 23; 0 <= i; --i) {
            this.cache.set(i, i);
            this.cache.set(i, i);
            this.cache.set(i, i);
        }
        for (i = 0; i < 24; ++i) {
            this.cache.set(i, i);
        }
    }

    private double loopsForRandom(int data_size) {
        int i;
        long begin = 0L;
        double sum = 0.0;
        int[] random_data = new int[data_size];
        for (i = 0; i < data_size; ++i) {
            random_data[i] = this.r.nextInt(data_size);
        }
        for (i = 0; i < data_size; ++i) {
            this.performance_cache.set(i, i);
        }
        for (i = 0; i < this.LOOP_COUNT; ++i) {
            for (int j = 0; j < this.PER_LOOP_NUM; ++j) {
                if (j == 1000) {
                    begin = System.currentTimeMillis();
                }
                int n = random_data[j % data_size];
                int value = this.performance_cache.get(n);
                this.performance_cache.set(n, value + 1);
            }
            long end = System.currentTimeMillis();
            sum += (double)(end - begin) * 1.0 / 1000.0;
        }
        return sum;
    }

    @Test
    @Ignore
    public void testRandomPerformance() {
        double[] rate = new double[]{0.07, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
        for (int i = 0; i < rate.length; ++i) {
            double sum = this.loopsForRandom((int)((double)this.PERFORMANCE_CACHE_SIZE / rate[i]));
            logger.info("Random LRUCache " + rate[i] + " " + sum / (double)this.LOOP_COUNT);
        }
    }

    private double loopsForScan(int data_size) {
        int i;
        long begin = 0L;
        double sum = 0.0;
        for (i = 0; i < data_size; ++i) {
            this.performance_cache.set(i, i);
        }
        for (i = 0; i < this.LOOP_COUNT; ++i) {
            for (int j = 0; j < this.PER_LOOP_NUM; ++j) {
                if (j == 1000) {
                    begin = System.currentTimeMillis();
                }
                int value = this.performance_cache.get(j % data_size);
                this.performance_cache.set(j % data_size, value + 1);
            }
            long end = System.currentTimeMillis();
            sum += (double)(end - begin) * 1.0 / 1000.0;
        }
        return sum;
    }

    @Test
    @Ignore
    public void testScanPerformance() {
        double[] rate = new double[]{0.07, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
        for (int i = 0; i < rate.length; ++i) {
            double sum = this.loopsForScan((int)((double)this.PERFORMANCE_CACHE_SIZE / rate[i]));
            logger.info("Scan LRUCache " + rate[i] + " " + sum / (double)this.LOOP_COUNT);
        }
    }
}

