/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.dataset.UDTFAlignByTimeDataSet;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UDTFAlignByTimeDataSetTest {
    protected static final int ITERATION_TIMES = 100000;
    protected static final int ADDEND = 500000;
    private static IPlanExecutor queryExecutor;
    private static final Planner processor;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.vehicle"));
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s2"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d2.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d2.s2"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d3.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d3.s2"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        UDTFAlignByTimeDataSetTest.generateData();
        queryExecutor.processNonQuery(processor.parseSQLToPhysicalPlan(String.format("create function udf as '%s'", "org.apache.iotdb.db.query.udf.example.Adder")));
    }

    private static void generateData() throws Exception {
        for (int i = 0; i < 100000; ++i) {
            queryExecutor.processNonQuery(processor.parseSQLToPhysicalPlan(i % 3 != 0 ? String.format("insert into root.vehicle.d1(timestamp,s1,s2) values(%d,%d,%d)", i, i, i) : (i % 2 == 0 ? String.format("insert into root.vehicle.d1(timestamp,s1) values(%d,%d)", i, i) : String.format("insert into root.vehicle.d1(timestamp,s2) values(%d,%d)", i, i))));
            queryExecutor.processNonQuery(processor.parseSQLToPhysicalPlan(String.format("insert into root.vehicle.d2(timestamp,s1,s2) values(%d,%d,%d)", i, i, i)));
            queryExecutor.processNonQuery(processor.parseSQLToPhysicalPlan(String.format("insert into root.vehicle.d3(timestamp,s1,s2) values(%d,%d,%d)", i, i, i)));
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testHasNextAndNextWithoutValueFilter1() {
        try {
            String sqlStr = "select udf(d1.s2, d1.s1), udf(d1.s1, d1.s2), d1.s1, d1.s2, udf(d1.s1, d1.s2), udf(d1.s2, d1.s1), d1.s1, d1.s2 from root.vehicle";
            UDTFPlan queryPlan = (UDTFPlan)processor.parseSQLToPhysicalPlan(sqlStr);
            QueryDataSet dataSet = queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertTrue((boolean)(dataSet instanceof UDTFAlignByTimeDataSet));
            UDTFAlignByTimeDataSet udtfAlignByTimeDataSet = (UDTFAlignByTimeDataSet)dataSet;
            HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 4, 5));
            HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(2, 6));
            HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(3, 7));
            Map path2Index = queryPlan.getPathToIndex();
            ArrayList<Integer> originalIndex2FieldIndex = new ArrayList<Integer>();
            for (int i = 0; i < 8; ++i) {
                Path path = (Path)queryPlan.getPaths().get(i);
                String columnName = path == null ? ((ResultColumn)queryPlan.getResultColumns().get(i)).getExpression().toString() : path.getFullPath();
                originalIndex2FieldIndex.add((Integer)path2Index.get(columnName));
            }
            int count = 0;
            while (udtfAlignByTimeDataSet.hasNext()) {
                RowRecord rowRecord = udtfAlignByTimeDataSet.next();
                List fields = rowRecord.getFields();
                for (int i = 0; i < 8; ++i) {
                    if (s1s2.contains(i)) {
                        if (count % 3 != 0) {
                            Assert.assertEquals((long)(count * 2), (long)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getLongV());
                            continue;
                        }
                        Assert.assertNull(fields.get((Integer)originalIndex2FieldIndex.get(i)));
                        continue;
                    }
                    if (s1.contains(i)) {
                        if (count % 3 != 0 || count % 2 == 0) {
                            Assert.assertEquals((float)count, (float)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getFloatV(), (float)0.0f);
                            continue;
                        }
                        Assert.assertNull(fields.get((Integer)originalIndex2FieldIndex.get(i)));
                        continue;
                    }
                    if (!s2.contains(i)) continue;
                    if (count % 3 != 0 || count % 2 != 0) {
                        Assert.assertEquals((float)count, (float)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getFloatV(), (float)0.0f);
                        continue;
                    }
                    Assert.assertNull(fields.get((Integer)originalIndex2FieldIndex.get(i)));
                }
                ++count;
            }
            Assert.assertEquals((long)100000L, (long)count);
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testHasNextAndNextWithoutValueFilter2() {
        try {
            String sqlStr = "select udf(*, *) from root.vehicle.d1";
            UDTFPlan queryPlan = (UDTFPlan)processor.parseSQLToPhysicalPlan(sqlStr);
            QueryDataSet dataSet = queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertTrue((boolean)(dataSet instanceof UDTFAlignByTimeDataSet));
            UDTFAlignByTimeDataSet udtfAlignByTimeDataSet = (UDTFAlignByTimeDataSet)dataSet;
            Map path2Index = queryPlan.getPathToIndex();
            ArrayList<Integer> originalIndex2FieldIndex = new ArrayList<Integer>();
            for (int i = 0; i < 4; ++i) {
                Path path = (Path)queryPlan.getPaths().get(i);
                String columnName = path == null ? ((ResultColumn)queryPlan.getResultColumns().get(i)).getExpression().toString() : path.getFullPath();
                originalIndex2FieldIndex.add((Integer)path2Index.get(columnName));
            }
            int count = 0;
            while (udtfAlignByTimeDataSet.hasNext()) {
                RowRecord rowRecord = udtfAlignByTimeDataSet.next();
                List fields = rowRecord.getFields();
                for (int i = 0; i < 4; ++i) {
                    Field field = (Field)fields.get((Integer)originalIndex2FieldIndex.get(i));
                    if (field == null) continue;
                    Assert.assertEquals((long)(count * 2), (long)field.getLongV());
                }
                ++count;
            }
            Assert.assertEquals((long)100000L, (long)count);
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testHasNextAndNextWithoutValueFilter3() {
        try {
            String sqlStr = "select *, udf(*, *), *, udf(*, *), * from root.vehicle.d1";
            UDTFPlan queryPlan = (UDTFPlan)processor.parseSQLToPhysicalPlan(sqlStr);
            QueryDataSet dataSet = queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertTrue((boolean)(dataSet instanceof UDTFAlignByTimeDataSet));
            UDTFAlignByTimeDataSet udtfAlignByTimeDataSet = (UDTFAlignByTimeDataSet)dataSet;
            Map path2Index = queryPlan.getPathToIndex();
            ArrayList<Integer> originalIndex2FieldIndex = new ArrayList<Integer>();
            for (int i = 0; i < 14; ++i) {
                Path path = (Path)queryPlan.getPaths().get(i);
                String columnName = path == null ? ((ResultColumn)queryPlan.getResultColumns().get(i)).getExpression().toString() : path.getFullPath();
                originalIndex2FieldIndex.add((Integer)path2Index.get(columnName));
            }
            HashSet<Integer> s1AndS2 = new HashSet<Integer>(Arrays.asList(2, 3, 4, 5, 8, 9, 10, 11));
            HashSet<Integer> s1OrS2 = new HashSet<Integer>(Arrays.asList(0, 1, 6, 7, 12, 13));
            int count = 0;
            while (udtfAlignByTimeDataSet.hasNext()) {
                RowRecord rowRecord = udtfAlignByTimeDataSet.next();
                List fields = rowRecord.getFields();
                for (int i = 0; i < 14; ++i) {
                    Field field;
                    if (s1AndS2.contains(i) && (field = (Field)fields.get((Integer)originalIndex2FieldIndex.get(i))) != null) {
                        Assert.assertEquals((long)(count * 2), (long)field.getLongV());
                    }
                    if (!s1OrS2.contains(i) || (field = (Field)fields.get((Integer)originalIndex2FieldIndex.get(i))) == null) continue;
                    Assert.assertEquals((float)count, (float)field.getFloatV(), (float)0.0f);
                }
                ++count;
            }
            Assert.assertEquals((long)100000L, (long)count);
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testHasNextAndNextWithoutValueFilter4() {
        try {
            String sqlStr = "select udf(*, *, 'addend'='500000'), *, udf(*, *) from root.vehicle.d1";
            UDTFPlan queryPlan = (UDTFPlan)processor.parseSQLToPhysicalPlan(sqlStr);
            QueryDataSet dataSet = queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertTrue((boolean)(dataSet instanceof UDTFAlignByTimeDataSet));
            UDTFAlignByTimeDataSet udtfAlignByTimeDataSet = (UDTFAlignByTimeDataSet)dataSet;
            Map path2Index = queryPlan.getPathToIndex();
            ArrayList<Integer> originalIndex2FieldIndex = new ArrayList<Integer>();
            for (int i = 0; i < 10; ++i) {
                Path path = (Path)queryPlan.getPaths().get(i);
                String columnName = path == null ? ((ResultColumn)queryPlan.getResultColumns().get(i)).getExpression().toString() : path.getFullPath();
                originalIndex2FieldIndex.add((Integer)path2Index.get(columnName));
            }
            HashSet<Integer> s1AndS2WithAddend = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3));
            HashSet<Integer> s1AndS2 = new HashSet<Integer>(Arrays.asList(6, 7, 8, 9));
            HashSet<Integer> s1OrS2 = new HashSet<Integer>(Arrays.asList(4, 5));
            int count = 0;
            while (udtfAlignByTimeDataSet.hasNext()) {
                RowRecord rowRecord = udtfAlignByTimeDataSet.next();
                List fields = rowRecord.getFields();
                for (int i = 0; i < 10; ++i) {
                    Field field;
                    if (s1AndS2WithAddend.contains(i) && (field = (Field)fields.get((Integer)originalIndex2FieldIndex.get(i))) != null) {
                        Assert.assertEquals((long)(count * 2 + 500000), (long)field.getLongV());
                    }
                    if (s1AndS2.contains(i) && (field = (Field)fields.get((Integer)originalIndex2FieldIndex.get(i))) != null) {
                        Assert.assertEquals((long)(count * 2), (long)field.getLongV());
                    }
                    if (!s1OrS2.contains(i) || (field = (Field)fields.get((Integer)originalIndex2FieldIndex.get(i))) == null) continue;
                    Assert.assertEquals((float)count, (float)field.getFloatV(), (float)0.0f);
                }
                ++count;
            }
            Assert.assertEquals((long)100000L, (long)count);
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testHasNextAndNextWithValueFilter1() {
        try {
            String sqlStr = "select udf(d2.s2, d2.s1), udf(d2.s1, d2.s2), d2.s1, d2.s2, udf(d2.s1, d2.s2), udf(d2.s2, d2.s1), d2.s1, d2.s2 from root.vehicle" + String.format(" where d2.s1 >= %d and d2.s2 < %d", 25000, 75000);
            UDTFPlan queryPlan = (UDTFPlan)processor.parseSQLToPhysicalPlan(sqlStr);
            QueryDataSet dataSet = queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertTrue((boolean)(dataSet instanceof UDTFAlignByTimeDataSet));
            UDTFAlignByTimeDataSet udtfAlignByTimeDataSet = (UDTFAlignByTimeDataSet)dataSet;
            HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 4, 5));
            HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(2, 6));
            HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(3, 7));
            Map path2Index = queryPlan.getPathToIndex();
            ArrayList<Integer> originalIndex2FieldIndex = new ArrayList<Integer>();
            for (int i = 0; i < 8; ++i) {
                Path path = (Path)queryPlan.getPaths().get(i);
                String columnName = path == null ? ((ResultColumn)queryPlan.getResultColumns().get(i)).getExpression().toString() : path.getFullPath();
                originalIndex2FieldIndex.add((Integer)path2Index.get(columnName));
            }
            int index = 25000;
            while (udtfAlignByTimeDataSet.hasNext()) {
                RowRecord rowRecord = udtfAlignByTimeDataSet.next();
                List fields = rowRecord.getFields();
                for (int i = 0; i < 8; ++i) {
                    if (s1s2.contains(i)) {
                        Assert.assertEquals((long)(index * 2), (long)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getLongV());
                        continue;
                    }
                    if (s1.contains(i)) {
                        Assert.assertEquals((float)index, (float)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getFloatV(), (float)0.0f);
                        continue;
                    }
                    if (!s2.contains(i)) continue;
                    Assert.assertEquals((float)index, (float)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getFloatV(), (float)0.0f);
                }
                ++index;
            }
            Assert.assertEquals((long)50000L, (long)(index - 25000));
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testHasNextAndNextWithValueFilter2() {
        try {
            String sqlStr = "select udf(*, *, 'addend'='500000'), *, udf(*, *) from root.vehicle.d2" + String.format(" where s1 >= %d and s2 < %d", 25000, 75000);
            UDTFPlan queryPlan = (UDTFPlan)processor.parseSQLToPhysicalPlan(sqlStr);
            QueryDataSet dataSet = queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertTrue((boolean)(dataSet instanceof UDTFAlignByTimeDataSet));
            UDTFAlignByTimeDataSet udtfAlignByTimeDataSet = (UDTFAlignByTimeDataSet)dataSet;
            Map path2Index = queryPlan.getPathToIndex();
            ArrayList<Integer> originalIndex2FieldIndex = new ArrayList<Integer>();
            for (int i = 0; i < 10; ++i) {
                Path path = (Path)queryPlan.getPaths().get(i);
                String columnName = path == null ? ((ResultColumn)queryPlan.getResultColumns().get(i)).getExpression().toString() : path.getFullPath();
                originalIndex2FieldIndex.add((Integer)path2Index.get(columnName));
            }
            HashSet<Integer> s1AndS2WithAddend = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3));
            HashSet<Integer> s1AndS2 = new HashSet<Integer>(Arrays.asList(6, 7, 8, 9));
            HashSet<Integer> s1OrS2 = new HashSet<Integer>(Arrays.asList(4, 5));
            int index = 25000;
            while (udtfAlignByTimeDataSet.hasNext()) {
                RowRecord rowRecord = udtfAlignByTimeDataSet.next();
                List fields = rowRecord.getFields();
                for (int i = 0; i < 10; ++i) {
                    if (s1AndS2WithAddend.contains(i)) {
                        Assert.assertEquals((long)(index * 2 + 500000), (long)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getLongV());
                    }
                    if (s1AndS2.contains(i)) {
                        Assert.assertEquals((long)(index * 2), (long)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getLongV());
                    }
                    if (!s1OrS2.contains(i)) continue;
                    Assert.assertEquals((float)index, (float)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getFloatV(), (float)0.0f);
                }
                ++index;
            }
            Assert.assertEquals((long)50000L, (long)(index - 25000));
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testHasNextAndNextWithValueFilter3() {
        try {
            String sqlStr = "select udf(d1.s2, d1.s1), udf(d1.s1, d1.s2), d1.s1, d1.s2, udf(d1.s1, d1.s2), udf(d1.s2, d1.s1), d1.s1, d1.s2 from root.vehicle" + String.format(" where d3.s1 >= %d and d3.s2 < %d", 30000, 70000);
            UDTFPlan queryPlan = (UDTFPlan)processor.parseSQLToPhysicalPlan(sqlStr);
            QueryDataSet dataSet = queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertTrue((boolean)(dataSet instanceof UDTFAlignByTimeDataSet));
            UDTFAlignByTimeDataSet udtfAlignByTimeDataSet = (UDTFAlignByTimeDataSet)dataSet;
            HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 4, 5));
            HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(2, 6));
            HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(3, 7));
            Map path2Index = queryPlan.getPathToIndex();
            ArrayList<Integer> originalIndex2FieldIndex = new ArrayList<Integer>();
            for (int i = 0; i < 8; ++i) {
                Path path = (Path)queryPlan.getPaths().get(i);
                String columnName = path == null ? ((ResultColumn)queryPlan.getResultColumns().get(i)).getExpression().toString() : path.getFullPath();
                originalIndex2FieldIndex.add((Integer)path2Index.get(columnName));
            }
            int index = 30000;
            while (udtfAlignByTimeDataSet.hasNext()) {
                RowRecord rowRecord = udtfAlignByTimeDataSet.next();
                List fields = rowRecord.getFields();
                for (int i = 0; i < 8; ++i) {
                    if (s1s2.contains(i)) {
                        if (index % 3 != 0) {
                            Assert.assertEquals((long)(index * 2), (long)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getLongV());
                            continue;
                        }
                        Assert.assertNull(fields.get((Integer)originalIndex2FieldIndex.get(i)));
                        continue;
                    }
                    if (s1.contains(i)) {
                        if (index % 3 != 0 || index % 2 == 0) {
                            Assert.assertEquals((float)index, (float)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getFloatV(), (float)0.0f);
                            continue;
                        }
                        Assert.assertNull(fields.get((Integer)originalIndex2FieldIndex.get(i)));
                        continue;
                    }
                    if (!s2.contains(i)) continue;
                    if (index % 3 != 0 || index % 2 != 0) {
                        Assert.assertEquals((float)index, (float)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getFloatV(), (float)0.0f);
                        continue;
                    }
                    Assert.assertNull(fields.get((Integer)originalIndex2FieldIndex.get(i)));
                }
                ++index;
            }
            Assert.assertEquals((long)40000L, (long)(index - 30000));
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testHasNextAndNextWithValueFilter4() {
        try {
            String sqlStr = "select udf(s2, s1), udf(s1, s2), s1, s2, udf(s1, s2), udf(s2, s1), s1, s2 from root.vehicle.d2, root.vehicle.d3" + String.format(" where root.vehicle.d2.s1 >= %d and root.vehicle.d3.s2 < %d", 30000, 70000);
            UDTFPlan queryPlan = (UDTFPlan)processor.parseSQLToPhysicalPlan(sqlStr);
            QueryDataSet dataSet = queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertTrue((boolean)(dataSet instanceof UDTFAlignByTimeDataSet));
            UDTFAlignByTimeDataSet udtfAlignByTimeDataSet = (UDTFAlignByTimeDataSet)dataSet;
            HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 12, 13, 14, 15, 16, 17, 18, 19));
            HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(8, 9, 20, 21));
            HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(10, 11, 22, 23));
            Map path2Index = queryPlan.getPathToIndex();
            ArrayList<Integer> originalIndex2FieldIndex = new ArrayList<Integer>();
            for (int i = 0; i < 24; ++i) {
                Path path = (Path)queryPlan.getPaths().get(i);
                String columnName = path == null ? ((ResultColumn)queryPlan.getResultColumns().get(i)).getExpression().toString() : path.getFullPath();
                originalIndex2FieldIndex.add((Integer)path2Index.get(columnName));
            }
            int index = 30000;
            while (udtfAlignByTimeDataSet.hasNext()) {
                RowRecord rowRecord = udtfAlignByTimeDataSet.next();
                List fields = rowRecord.getFields();
                for (int i = 0; i < 24; ++i) {
                    if (s1s2.contains(i)) {
                        Assert.assertEquals((long)(index * 2), (long)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getLongV());
                    }
                    if (!s1.contains(i) && !s2.contains(i)) continue;
                    Assert.assertEquals((float)index, (float)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getFloatV(), (float)0.0f);
                }
                ++index;
            }
            Assert.assertEquals((long)40000L, (long)(index - 30000));
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testHasNextAndNextWithValueFilter5() {
        try {
            String sqlStr = "select *, udf(*, *), udf(*, *) from root.vehicle.d2, root.vehicle.d3, root.vehicle.d2" + String.format(" where root.vehicle.d2.s1 >= %d and root.vehicle.d3.s2 < %d", 30000, 70000);
            UDTFPlan queryPlan = (UDTFPlan)processor.parseSQLToPhysicalPlan(sqlStr);
            QueryDataSet dataSet = queryExecutor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertTrue((boolean)(dataSet instanceof UDTFAlignByTimeDataSet));
            UDTFAlignByTimeDataSet udtfAlignByTimeDataSet = (UDTFAlignByTimeDataSet)dataSet;
            Map path2Index = queryPlan.getPathToIndex();
            ArrayList<Integer> originalIndex2FieldIndex = new ArrayList<Integer>();
            for (int i = 0; i < 78; ++i) {
                Path path = (Path)queryPlan.getPaths().get(i);
                String columnName = path == null ? ((ResultColumn)queryPlan.getResultColumns().get(i)).getExpression().toString() : path.getFullPath();
                originalIndex2FieldIndex.add((Integer)path2Index.get(columnName));
            }
            int index = 30000;
            while (udtfAlignByTimeDataSet.hasNext()) {
                RowRecord rowRecord = udtfAlignByTimeDataSet.next();
                List fields = rowRecord.getFields();
                for (int i = 0; i < 78; ++i) {
                    Assert.assertEquals((float)(i < 6 ? (float)index : (float)(index * 2)), (float)(i < 6 ? ((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getFloatV() : (float)((Field)fields.get((Integer)originalIndex2FieldIndex.get(i))).getLongV()), (float)0.0f);
                }
                ++index;
            }
            Assert.assertEquals((long)40000L, (long)(index - 30000));
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
    }

    static {
        try {
            queryExecutor = new PlanExecutor();
        }
        catch (QueryProcessException e) {
            Assert.fail((String)e.getMessage());
        }
        processor = new Planner();
    }
}

