/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleDataSetTest {
    private final IPlanExecutor queryExecutor = new PlanExecutor();
    private final Planner processor = new Planner();
    private final String[] sqls = new String[]{"SET STORAGE GROUP TO root.vehicle", "SET STORAGE GROUP TO root.test", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.test.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.test.d0.s1 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.test.d1.`\"s3+xy\"` WITH DATATYPE=TEXT, ENCODING=PLAIN"};

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        for (String sql : this.sqls) {
            this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan(sql));
        }
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void countDevice() throws QueryProcessException, TException, StorageEngineException, QueryFilterOptimizationException, MetadataException, IOException, InterruptedException, SQLException {
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan("count devices");
        QueryDataSet dataSet = this.queryExecutor.processQuery(plan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)(dataSet instanceof SingleDataSet));
        Assert.assertEquals((Object)"[devices]", (Object)dataSet.getPaths().toString());
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((Object)"0\t3", (Object)record.toString());
        }
    }

    @Test
    public void countTimeSeries() throws QueryProcessException, TException, StorageEngineException, QueryFilterOptimizationException, MetadataException, IOException, InterruptedException, SQLException {
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan("count TimeSeries");
        QueryDataSet dataSet = this.queryExecutor.processQuery(plan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)(dataSet instanceof SingleDataSet));
        Assert.assertEquals((Object)"[count]", (Object)dataSet.getPaths().toString());
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((Object)"0\t5", (Object)record.toString());
        }
    }

    @Test
    public void countStorageGroup() throws TException, StorageEngineException, QueryFilterOptimizationException, MetadataException, IOException, InterruptedException, SQLException, QueryProcessException {
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan("count storage group");
        QueryDataSet dataSet = this.queryExecutor.processQuery(plan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)(dataSet instanceof SingleDataSet));
        Assert.assertEquals((Object)"[storage group]", (Object)dataSet.getPaths().toString());
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((Object)"0\t2", (Object)record.toString());
        }
    }

    @Test
    public void countNodes() throws QueryProcessException, TException, StorageEngineException, QueryFilterOptimizationException, MetadataException, IOException, InterruptedException, SQLException {
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan("count nodes root.test.** level=2");
        QueryDataSet dataSet = this.queryExecutor.processQuery(plan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertTrue((boolean)(dataSet instanceof SingleDataSet));
        Assert.assertEquals((Object)"[count]", (Object)dataSet.getPaths().toString());
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((Object)"0\t2", (Object)record.toString());
        }
    }
}

