/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.impl.AvgAggrResult;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.junit.Assert;
import org.junit.Test;

public class AggregateResultTest {
    @Test
    public void avgAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult avgAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"avg", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        AggregateResult avgAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"avg", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        statistics1.update(1L, 1.0);
        statistics1.update(2L, 1.0);
        statistics2.update(1L, 2.0);
        avgAggrResult1.updateResultFromStatistics(statistics1);
        avgAggrResult2.updateResultFromStatistics(statistics2);
        avgAggrResult1.merge(avgAggrResult2);
        Assert.assertEquals((double)1.333, (double)((Double)avgAggrResult1.getResult()), (double)0.01);
        Assert.assertEquals((long)3L, (long)((AvgAggrResult)avgAggrResult1).getCnt());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        avgAggrResult1.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((double)1.333, (double)((Double)result.getResult()), (double)0.01);
    }

    @Test
    public void maxValueAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult maxValueAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"max_value", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        AggregateResult maxValueAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"max_value", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        statistics1.update(1L, 1.0);
        statistics2.update(1L, 2.0);
        maxValueAggrResult1.updateResultFromStatistics(statistics1);
        maxValueAggrResult2.updateResultFromStatistics(statistics2);
        maxValueAggrResult1.merge(maxValueAggrResult2);
        Assert.assertEquals((double)2.0, (double)((Double)maxValueAggrResult1.getResult()), (double)0.01);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        maxValueAggrResult1.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((double)2.0, (double)((Double)result.getResult()), (double)0.01);
    }

    @Test
    public void maxTimeAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult maxTimeAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"max_time", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        AggregateResult maxTimeAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"max_time", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        statistics1.update(1L, 1.0);
        statistics2.update(2L, 1.0);
        maxTimeAggrResult1.updateResultFromStatistics(statistics1);
        maxTimeAggrResult2.updateResultFromStatistics(statistics2);
        maxTimeAggrResult1.merge(maxTimeAggrResult2);
        Assert.assertEquals((long)2L, (long)((Long)maxTimeAggrResult1.getResult()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        maxTimeAggrResult1.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((long)2L, (long)((Long)result.getResult()));
    }

    @Test
    public void minValueAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult minValueAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"min_value", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        AggregateResult minValueAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"min_value", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        statistics1.update(1L, 1.0);
        statistics2.update(1L, 2.0);
        minValueAggrResult1.updateResultFromStatistics(statistics1);
        minValueAggrResult2.updateResultFromStatistics(statistics2);
        minValueAggrResult1.merge(minValueAggrResult2);
        Assert.assertEquals((double)1.0, (double)((Double)minValueAggrResult1.getResult()), (double)0.01);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        minValueAggrResult1.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((double)1.0, (double)((Double)result.getResult()), (double)0.01);
    }

    @Test
    public void ExtremeAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult extremeAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"extreme", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        AggregateResult extremeAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"extreme", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        statistics1.update(1L, 1.0);
        statistics2.update(1L, -2.0);
        extremeAggrResult1.updateResultFromStatistics(statistics1);
        extremeAggrResult2.updateResultFromStatistics(statistics2);
        extremeAggrResult1.merge(extremeAggrResult2);
        Assert.assertEquals((double)-2.0, (double)((Double)extremeAggrResult1.getResult()), (double)0.01);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        extremeAggrResult1.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((double)-2.0, (double)((Double)result.getResult()), (double)0.01);
    }

    @Test
    public void minTimeAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult finalResult = AggregateResultFactory.getAggrResultByName((String)"min_time", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        AggregateResult minTimeAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"min_time", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        AggregateResult minTimeAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"min_time", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        statistics1.update(10L, 1.0);
        statistics2.update(2L, 1.0);
        minTimeAggrResult1.updateResultFromStatistics(statistics1);
        minTimeAggrResult2.updateResultFromStatistics(statistics2);
        finalResult.merge(minTimeAggrResult1);
        finalResult.merge(minTimeAggrResult2);
        Assert.assertEquals((long)2L, (long)((Long)finalResult.getResult()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        finalResult.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((long)2L, (long)((Long)result.getResult()));
    }

    @Test
    public void countAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult countAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"count", (TSDataType)TSDataType.INT64, (boolean)true);
        AggregateResult countAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"count", (TSDataType)TSDataType.INT64, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.INT64);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.INT64);
        statistics1.update(1L, 1L);
        statistics2.update(1L, 1L);
        countAggrResult1.updateResultFromStatistics(statistics1);
        countAggrResult2.updateResultFromStatistics(statistics2);
        countAggrResult1.merge(countAggrResult2);
        Assert.assertEquals((long)2L, (long)((Long)countAggrResult1.getResult()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        countAggrResult1.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((long)2L, (long)((Long)result.getResult()));
    }

    @Test
    public void sumAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult sumAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"sum", (TSDataType)TSDataType.INT32, (boolean)true);
        AggregateResult sumAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"sum", (TSDataType)TSDataType.INT32, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.INT32);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.INT32);
        statistics1.update(1L, 1);
        statistics2.update(1L, 2);
        sumAggrResult1.updateResultFromStatistics(statistics1);
        sumAggrResult2.updateResultFromStatistics(statistics2);
        sumAggrResult1.merge(sumAggrResult2);
        Assert.assertEquals((Object)3.0, (Object)sumAggrResult1.getResult());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        sumAggrResult1.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)3.0, (Object)result.getResult());
    }

    @Test
    public void firstValueAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult firstValueAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"first_value", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        AggregateResult firstValueAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"first_value", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        statistics1.update(1L, 1.0);
        statistics2.update(2L, 2.0);
        firstValueAggrResult1.updateResultFromStatistics(statistics1);
        firstValueAggrResult2.updateResultFromStatistics(statistics2);
        firstValueAggrResult1.merge(firstValueAggrResult2);
        Assert.assertEquals((double)1.0, (double)((Double)firstValueAggrResult1.getResult()), (double)0.01);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        firstValueAggrResult1.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((double)1.0, (double)((Double)result.getResult()), (double)0.01);
    }

    @Test
    public void lastValueAggrResultTest() throws QueryProcessException, IOException {
        AggregateResult lastValueAggrResult1 = AggregateResultFactory.getAggrResultByName((String)"last_value", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        AggregateResult lastValueAggrResult2 = AggregateResultFactory.getAggrResultByName((String)"last_value", (TSDataType)TSDataType.DOUBLE, (boolean)true);
        Statistics statistics1 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        Statistics statistics2 = Statistics.getStatsByType((TSDataType)TSDataType.DOUBLE);
        statistics1.update(1L, 1.0);
        statistics2.update(2L, 2.0);
        lastValueAggrResult1.updateResultFromStatistics(statistics1);
        lastValueAggrResult2.updateResultFromStatistics(statistics2);
        lastValueAggrResult1.merge(lastValueAggrResult2);
        Assert.assertEquals((double)2.0, (double)((Double)lastValueAggrResult1.getResult()), (double)0.01);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        lastValueAggrResult1.serializeTo((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)byteBuffer);
        Assert.assertEquals((double)2.0, (double)((Double)result.getResult()), (double)0.01);
    }
}

