/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class SerializedSizeTest {
    private final String devicePath = "root.test_sg.test_d";

    @Test
    public void testInsertRowPlan() throws IllegalPathException {
        InsertRowPlan insertRowPlan = this.getInsertRowPlan();
        ByteBuffer buffer = ByteBuffer.allocate(insertRowPlan.serializedSize());
        insertRowPlan.serialize(buffer);
        Assert.assertEquals((long)0L, (long)buffer.remaining());
    }

    private InsertRowPlan getInsertRowPlan() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        String[] columns = new String[]{"1.0", "2", "10000", "100", "false", "hh0"};
        return new InsertRowPlan(new PartialPath("root.test_sg.test_d"), time, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, columns);
    }

    @Test
    public void testInsertTabletPlan() throws IllegalPathException {
        InsertTabletPlan insertTabletPlan = this.getInsertTabletPlan();
        ByteBuffer buffer = ByteBuffer.allocate(insertTabletPlan.serializedSize());
        insertTabletPlan.serialize(buffer);
        Assert.assertEquals((long)0L, (long)buffer.remaining());
    }

    private InsertTabletPlan getInsertTabletPlan() throws IllegalPathException {
        long[] times = new long[]{110L, 111L, 112L, 113L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.DOUBLE.ordinal());
        dataTypes.add(TSDataType.FLOAT.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.BOOLEAN.ordinal());
        dataTypes.add(TSDataType.TEXT.ordinal());
        Object[] columns = new Object[]{new double[4], new float[4], new long[4], new int[4], new boolean[4], new Binary[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 1.0 + (double)r;
            ((float[])columns[1])[r] = 2 + r;
            ((long[])columns[2])[r] = 10000 + r;
            ((int[])columns[3])[r] = 100 + r;
            ((boolean[])columns[4])[r] = r % 2 == 0;
            ((Binary[])columns[5])[r] = new Binary("hh" + r);
        }
        BitMap[] bitMaps = new BitMap[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(i % times.length);
        }
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath("root.test_sg.test_d"), new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes);
        insertTabletPlan.setTimes(times);
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setRowCount(times.length);
        insertTabletPlan.setBitMaps(bitMaps);
        return insertTabletPlan;
    }
}

