/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.AlterTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class PhysicalPlanSerializeTest {
    public ByteBuffer serializePlan(PhysicalPlan plan) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            plan.serialize(dataOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public PhysicalPlan testTwoSerializeMethodAndDeserialize(PhysicalPlan plan) throws IOException, IllegalPathException {
        ByteBuffer byteBuffer1 = this.serializePlan(plan);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer1.limit());
        plan.serialize(byteBuffer2);
        byteBuffer2.flip();
        Assert.assertEquals((Object)byteBuffer1, (Object)byteBuffer2);
        return PhysicalPlan.Factory.create((ByteBuffer)byteBuffer1);
    }

    @Test
    public void showTimeSeriesPlanSerializeTest() throws IllegalPathException, IOException {
        ShowTimeSeriesPlan timeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d1.s1"), true, "unit", "10", 0, 0, false);
        ByteBuffer byteBuffer = this.serializePlan((PhysicalPlan)timeSeriesPlan);
        PhysicalPlan result = PhysicalPlan.Factory.create((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)"root.sg.d1.s1", (Object)((ShowTimeSeriesPlan)result).getPath().getFullPath());
        Assert.assertEquals((Object)true, (Object)((ShowTimeSeriesPlan)result).isContains());
        Assert.assertEquals((Object)"unit", (Object)((ShowTimeSeriesPlan)result).getKey());
        Assert.assertEquals((Object)"10", (Object)((ShowTimeSeriesPlan)result).getValue());
        Assert.assertEquals((long)0L, (long)((ShowTimeSeriesPlan)result).getLimit());
        Assert.assertEquals((long)0L, (long)((ShowTimeSeriesPlan)result).getOffset());
        Assert.assertEquals((Object)false, (Object)((ShowTimeSeriesPlan)result).isOrderByHeat());
    }

    @Test
    public void setTTLPlanSerializeTest() throws IllegalPathException, IOException {
        SetTTLPlan setTTLPlan = new SetTTLPlan(new PartialPath("root.sg"), 1000000L);
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)setTTLPlan);
        Assert.assertEquals((Object)Operator.OperatorType.TTL, (Object)result.getOperatorType());
        Assert.assertEquals((Object)"root.sg", (Object)((SetTTLPlan)result).getStorageGroup().getFullPath());
        Assert.assertEquals((long)1000000L, (long)((SetTTLPlan)result).getDataTTL());
    }

    @Test
    public void setStorageGroupPlanTest() throws IllegalPathException, IOException {
        SetStorageGroupPlan setStorageGroupPlan = new SetStorageGroupPlan(new PartialPath("root.sg"));
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)setStorageGroupPlan);
        Assert.assertEquals((Object)Operator.OperatorType.SET_STORAGE_GROUP, (Object)result.getOperatorType());
        Assert.assertEquals((Object)"root.sg", (Object)((SetStorageGroupPlan)result).getPath().getFullPath());
        Assert.assertEquals((Object)result, (Object)setStorageGroupPlan);
    }

    @Test
    public void deleteTimeSeriesPlanSerializeTest() throws IllegalPathException, IOException {
        DeleteTimeSeriesPlan deleteTimeSeriesPlan = new DeleteTimeSeriesPlan(Collections.singletonList(new PartialPath("root.sg.d1.s1")));
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)deleteTimeSeriesPlan);
        Assert.assertEquals((Object)Operator.OperatorType.DELETE_TIMESERIES, (Object)result.getOperatorType());
        Assert.assertEquals((Object)"root.sg.d1.s1", (Object)((PartialPath)result.getPaths().get(0)).getFullPath());
    }

    @Test
    public void deleteStorageGroupPlanSerializeTest() throws IllegalPathException, IOException {
        DeleteStorageGroupPlan deleteStorageGroupPlan = new DeleteStorageGroupPlan(Collections.singletonList(new PartialPath("root.sg")));
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)deleteStorageGroupPlan);
        Assert.assertEquals((Object)Operator.OperatorType.DELETE_STORAGE_GROUP, (Object)result.getOperatorType());
        Assert.assertEquals((Object)"root.sg", (Object)((PartialPath)result.getPaths().get(0)).getFullPath());
    }

    @Test
    public void dataAuthPlanSerializeTest() throws IOException, IllegalPathException {
        DataAuthPlan dataAuthPlan = new DataAuthPlan(Operator.OperatorType.GRANT_WATERMARK_EMBEDDING, Arrays.asList("user1", "user2"));
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)dataAuthPlan);
        Assert.assertEquals(Arrays.asList("user1", "user2"), (Object)((DataAuthPlan)result).getUsers());
    }

    @Test
    public void createTimeSeriesPlanSerializeTest1() throws IOException, IllegalPathException {
        CreateTimeSeriesPlan createTimeSeriesPlan = new CreateTimeSeriesPlan(new PartialPath("root.sg.d1.s1"), TSDataType.DOUBLE, TSEncoding.RLE, CompressionType.SNAPPY, Collections.singletonMap("prop1", "propValue1"), Collections.singletonMap("tag1", "tagValue1"), Collections.singletonMap("attr1", "attrValue1"), "temperature");
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)createTimeSeriesPlan);
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_TIMESERIES, (Object)result.getOperatorType());
        Assert.assertEquals((Object)createTimeSeriesPlan, (Object)result);
    }

    @Test
    public void createTimeSeriesPlanSerializeTest2() throws IOException, IllegalPathException {
        CreateTimeSeriesPlan createTimeSeriesPlan = new CreateTimeSeriesPlan(new PartialPath("root.sg.d1.s1"), TSDataType.DOUBLE, TSEncoding.RLE, CompressionType.SNAPPY, null, null, null, null);
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)createTimeSeriesPlan);
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_TIMESERIES, (Object)result.getOperatorType());
        Assert.assertEquals((Object)createTimeSeriesPlan, (Object)result);
    }

    @Test
    public void createAlignedTimeSeriesPlanSerializeTest() throws IOException, IllegalPathException {
        CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = new CreateAlignedTimeSeriesPlan(new PartialPath("root.sg.d1"), Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.DOUBLE, TSDataType.INT32), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY), null, null, null);
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)createAlignedTimeSeriesPlan);
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_ALIGNED_TIMESERIES, (Object)result.getOperatorType());
        Assert.assertEquals((Object)createAlignedTimeSeriesPlan, (Object)result);
    }

    @Test
    public void createMuSerializeTest1() throws IOException, IllegalPathException {
        CreateMultiTimeSeriesPlan plan = new CreateMultiTimeSeriesPlan();
        plan.setPaths(Arrays.asList(new PartialPath("root.sg.d1.s1"), new PartialPath("root.sg.d1.s2")));
        plan.setDataTypes(Arrays.asList(TSDataType.DOUBLE, TSDataType.INT64));
        plan.setEncodings(Arrays.asList(TSEncoding.GORILLA, TSEncoding.GORILLA));
        plan.setCompressors(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        plan.setProps(Arrays.asList(Collections.singletonMap("prop1", "propValue1"), Collections.singletonMap("prop2", "propValue2")));
        plan.setTags(Arrays.asList(Collections.singletonMap("tag1", "tagValue1"), Collections.singletonMap("tag2", "tagValue2")));
        plan.setAttributes(Arrays.asList(Collections.singletonMap("attr1", "attrValue1"), Collections.singletonMap("attr2", "attrValue2")));
        plan.setAlias(Arrays.asList("temperature", "speed"));
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)plan);
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_MULTI_TIMESERIES, (Object)result.getOperatorType());
        Assert.assertEquals((Object)plan, (Object)result);
    }

    @Test
    public void createMuSerializeTest2() throws IOException, IllegalPathException {
        CreateMultiTimeSeriesPlan plan = new CreateMultiTimeSeriesPlan();
        plan.setPaths(Arrays.asList(new PartialPath("root.sg.d1.s1"), new PartialPath("root.sg.d1.s2")));
        plan.setDataTypes(Arrays.asList(TSDataType.DOUBLE, TSDataType.INT64));
        plan.setEncodings(Arrays.asList(TSEncoding.GORILLA, TSEncoding.GORILLA));
        plan.setCompressors(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        plan.setProps(null);
        plan.setTags(null);
        plan.setAttributes(null);
        plan.setAlias(null);
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)plan);
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_MULTI_TIMESERIES, (Object)result.getOperatorType());
        Assert.assertEquals((Object)plan, (Object)result);
    }

    @Test
    public void createMuSerializeTest3() throws IOException, IllegalPathException {
        CreateMultiTimeSeriesPlan plan = new CreateMultiTimeSeriesPlan();
        plan.setPaths(Arrays.asList(new PartialPath("root.sg.d1.s0"), new PartialPath("root.sg.d1.s1")));
        plan.setDataTypes(Arrays.asList(TSDataType.DOUBLE, TSDataType.INT64, TSDataType.DOUBLE, TSDataType.INT64));
        plan.setEncodings(Arrays.asList(TSEncoding.GORILLA, TSEncoding.GORILLA, TSEncoding.GORILLA, TSEncoding.GORILLA));
        plan.setCompressors(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        plan.setProps(null);
        plan.setTags(null);
        plan.setAttributes(null);
        plan.setAlias(null);
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)plan);
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_MULTI_TIMESERIES, (Object)result.getOperatorType());
        Assert.assertEquals((Object)plan, (Object)result);
    }

    @Test
    public void AlterTimeSeriesPlanSerializeTest() throws IOException, IllegalPathException {
        AlterTimeSeriesPlan alterTimeSeriesPlan = new AlterTimeSeriesPlan(new PartialPath("root.sg.d1.s1"), AlterTimeSeriesOperator.AlterType.RENAME, Collections.singletonMap("root.sg.d1.s1", "root.sg.device1.temperature"), null, null, null);
        ByteBuffer byteBuffer = this.serializePlan((PhysicalPlan)alterTimeSeriesPlan);
        PhysicalPlan result = PhysicalPlan.Factory.create((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)alterTimeSeriesPlan, (Object)result);
    }

    @Test
    public void loadConfigurationPlanSerializeTest() throws QueryProcessException, IOException, IllegalPathException {
        Properties[] properties = new Properties[2];
        properties[0] = new Properties();
        properties[0].setProperty("prop1", "value1");
        properties[1] = null;
        LoadConfigurationPlan loadConfigurationPlan = new LoadConfigurationPlan(LoadConfigurationPlan.LoadConfigurationPlanType.GLOBAL, properties);
        ByteBuffer byteBuffer = this.serializePlan((PhysicalPlan)loadConfigurationPlan);
        PhysicalPlan result = PhysicalPlan.Factory.create((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)Operator.OperatorType.LOAD_CONFIGURATION, (Object)result.getOperatorType());
        Assert.assertEquals((Object)LoadConfigurationPlan.LoadConfigurationPlanType.GLOBAL, (Object)((LoadConfigurationPlan)result).getLoadConfigurationPlanType());
        Assert.assertEquals((Object)properties[0], (Object)((LoadConfigurationPlan)result).getIoTDBProperties());
        Assert.assertEquals((Object)properties[1], (Object)((LoadConfigurationPlan)result).getClusterProperties());
    }

    @Test
    public void authorPlanSerializeTest() throws IOException, AuthException, IllegalPathException {
        AuthorPlan authorPlan = new AuthorPlan(AuthorOperator.AuthorType.CREATE_ROLE, "root", "root", "root", "", null, null);
        PhysicalPlan result = this.testTwoSerializeMethodAndDeserialize((PhysicalPlan)authorPlan);
        Assert.assertEquals((Object)result, (Object)authorPlan);
    }
}

