/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.IOException;
import org.antlr.v4.runtime.RecognitionException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConcatOptimizerTest {
    private Planner processor;

    @Before
    public void before() throws MetadataException {
        this.processor = new Planner();
        IoTDB.configManager.init();
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.laptop.d3.s1"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.schemaProcessor.createTimeseries(new PartialPath("root.laptop.d3.s2"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
    }

    @After
    public void after() throws IOException {
        IoTDB.configManager.clear();
        EnvironmentUtils.cleanAllDir();
    }

    @Test
    public void testConcat1() throws QueryProcessException, RecognitionException {
        String inputSQL = "select s1 from root.laptop.d1";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(inputSQL);
        Assert.assertEquals((Object)"root.laptop.d1.s1", (Object)((PartialPath)plan.getPaths().get(0)).getFullPath());
    }

    @Test
    public void testConcat2() throws QueryProcessException, RecognitionException {
        String inputSQL = "select s1 from root.laptop.*";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(inputSQL);
        Assert.assertEquals((Object)"root.laptop.d1.s1", (Object)((PartialPath)plan.getPaths().get(0)).getFullPath());
        Assert.assertEquals((Object)"root.laptop.d2.s1", (Object)((PartialPath)plan.getPaths().get(1)).getFullPath());
        Assert.assertEquals((Object)"root.laptop.d3.s1", (Object)((PartialPath)plan.getPaths().get(2)).getFullPath());
    }

    @Test
    public void testConcat3() throws QueryProcessException, RecognitionException {
        String inputSQL = "select s1 from root.laptop.d1 where s1 < 10";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(inputSQL);
        SingleSeriesExpression seriesExpression = new SingleSeriesExpression(new Path("root.laptop.d1", "s1"), (Filter)ValueFilter.lt((Comparable)Integer.valueOf(10)));
        Assert.assertEquals((Object)seriesExpression.toString(), (Object)((RawDataQueryPlan)plan).getExpression().toString());
    }

    @Test
    public void testConcatMultipleDeviceInFilter() throws QueryProcessException {
        String inputSQL = "select s1 from root.laptop.* where s1 < 10";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(inputSQL);
        BinaryExpression.AndExpression expression = BinaryExpression.and((IExpression)BinaryExpression.and((IExpression)new SingleSeriesExpression(new Path("root.laptop.d1", "s1"), (Filter)ValueFilter.lt((Comparable)Integer.valueOf(10))), (IExpression)new SingleSeriesExpression(new Path("root.laptop.d2", "s1"), (Filter)ValueFilter.lt((Comparable)Integer.valueOf(10)))), (IExpression)new SingleSeriesExpression(new Path("root.laptop.d3", "s1"), (Filter)ValueFilter.lt((Comparable)Integer.valueOf(10))));
        Assert.assertEquals((Object)expression.toString(), (Object)((RawDataQueryPlan)plan).getExpression().toString());
    }
}

