/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.storagegroup.DataRegionTest;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.execution.QueryState;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.mpp.plan.scheduler.StandaloneScheduler;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StandaloneSchedulerTest {
    private static final IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
    static LocalConfigNode configNode;

    @Before
    public void setUp() throws Exception {
        conf.setMppMode(true);
        conf.setDataNodeId(0);
        configNode = LocalConfigNode.getInstance();
        configNode.init();
        WALManager.getInstance().start();
        FlushManager.getInstance().start();
        StorageEngineV2.getInstance().start();
    }

    @After
    public void tearDown() throws Exception {
        configNode.clear();
        WALManager.getInstance().stop();
        StorageEngineV2.getInstance().stop();
        FlushManager.getInstance().stop();
        EnvironmentUtils.cleanAllDir();
        conf.setDataNodeId(-1);
        conf.setMppMode(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTimeseries() throws MetadataException {
        CreateTimeSeriesNode createTimeSeriesNode = new CreateTimeSeriesNode(new PlanNodeId("0"), new PartialPath("root.ln.wf01.wt01.status"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY, (Map)new HashMap<String, String>(){
            {
                this.put("MAX_POINT_NUMBER", "3");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("tag1", "v1");
                this.put("tag2", "v2");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
                this.put("attr2", "a2");
            }
        }, "meter1");
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet(TConsensusGroupType.SchemaRegion);
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId("2", 3), (PlanNode)createTimeSeriesNode);
        FragmentInstance fragmentInstance = new FragmentInstance(planFragment, planFragment.getId().genFragmentInstanceId(), (Filter)new GroupByFilter(1L, 2L, 3L, 4L), QueryType.WRITE, conf.getQueryTimeoutThreshold());
        fragmentInstance.setDataRegionAndHost(regionReplicaSet);
        configNode.getBelongedSchemaRegionIdWithAutoCreate(new PartialPath("root.ln.wf01.wt01.status"));
        MPPQueryContext context = new MPPQueryContext("", new QueryId("query1"), new SessionInfo(1L, "fakeUsername", "fakeZoneId"), new TEndPoint(), new TEndPoint());
        ExecutorService executor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"Test");
        QueryStateMachine stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        Assert.assertFalse((boolean)stateMachine.getState().isDone());
        StandaloneScheduler standaloneScheduler = new StandaloneScheduler(context, stateMachine, Collections.singletonList(fragmentInstance), QueryType.WRITE, null, null);
        try {
            standaloneScheduler.start();
            Assert.assertEquals((Object)QueryState.FINISHED, (Object)stateMachine.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            standaloneScheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAlignedTimeseries() throws MetadataException {
        CreateAlignedTimeSeriesNode createAlignedTimeSeriesNode = new CreateAlignedTimeSeriesNode(new PlanNodeId("0"), new PartialPath("root.ln.wf01.GPS"), (List)new ArrayList<String>(){
            {
                this.add("latitude");
                this.add("longitude");
            }
        }, (List)new ArrayList<TSDataType>(){
            {
                this.add(TSDataType.FLOAT);
                this.add(TSDataType.FLOAT);
            }
        }, (List)new ArrayList<TSEncoding>(){
            {
                this.add(TSEncoding.PLAIN);
                this.add(TSEncoding.PLAIN);
            }
        }, (List)new ArrayList<CompressionType>(){
            {
                this.add(CompressionType.SNAPPY);
                this.add(CompressionType.SNAPPY);
            }
        }, (List)new ArrayList<String>(){
            {
                this.add("meter1");
                this.add(null);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("tag1", "t1");
                    }
                });
                this.add(null);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("tag1", "t1");
                    }
                });
                this.add(null);
            }
        });
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet(TConsensusGroupType.SchemaRegion);
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId("2", 3), (PlanNode)createAlignedTimeSeriesNode);
        FragmentInstance fragmentInstance = new FragmentInstance(planFragment, planFragment.getId().genFragmentInstanceId(), (Filter)new GroupByFilter(1L, 2L, 3L, 4L), QueryType.WRITE, conf.getQueryTimeoutThreshold());
        fragmentInstance.setDataRegionAndHost(regionReplicaSet);
        configNode.getBelongedSchemaRegionIdWithAutoCreate(new PartialPath("root.ln.wf01.GPS"));
        MPPQueryContext context = new MPPQueryContext("", new QueryId("query1"), new SessionInfo(1L, "fakeUsername", "fakeZoneId"), new TEndPoint(), new TEndPoint());
        ExecutorService executor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"Test");
        QueryStateMachine stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        Assert.assertFalse((boolean)stateMachine.getState().isDone());
        StandaloneScheduler standaloneScheduler = new StandaloneScheduler(context, stateMachine, Collections.singletonList(fragmentInstance), QueryType.WRITE, null, null);
        try {
            standaloneScheduler.start();
            Assert.assertEquals((Object)QueryState.FINISHED, (Object)stateMachine.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            standaloneScheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateMultiTimeSeries() throws MetadataException {
        CreateMultiTimeSeriesNode createMultiTimeSeriesNode = new CreateMultiTimeSeriesNode(new PlanNodeId("0"), (List)new ArrayList<PartialPath>(){
            {
                this.add(new PartialPath("root.ln.d3.s1"));
                this.add(new PartialPath("root.ln.d3.s2"));
            }
        }, (List)new ArrayList<TSDataType>(){
            {
                this.add(TSDataType.FLOAT);
                this.add(TSDataType.FLOAT);
            }
        }, (List)new ArrayList<TSEncoding>(){
            {
                this.add(TSEncoding.PLAIN);
                this.add(TSEncoding.PLAIN);
            }
        }, (List)new ArrayList<CompressionType>(){
            {
                this.add(CompressionType.SNAPPY);
                this.add(CompressionType.SNAPPY);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("MAX_POINT_NUMBER", "3");
                    }
                });
                this.add(null);
            }
        }, (List)new ArrayList<String>(){
            {
                this.add("meter1");
                this.add(null);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("tag1", "t1");
                    }
                });
                this.add(null);
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("tag1", "t1");
                    }
                });
                this.add(null);
            }
        });
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet(TConsensusGroupType.SchemaRegion);
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId("2", 3), (PlanNode)createMultiTimeSeriesNode);
        FragmentInstance fragmentInstance = new FragmentInstance(planFragment, planFragment.getId().genFragmentInstanceId(), (Filter)new GroupByFilter(1L, 2L, 3L, 4L), QueryType.WRITE, conf.getQueryTimeoutThreshold());
        fragmentInstance.setDataRegionAndHost(regionReplicaSet);
        configNode.getBelongedSchemaRegionIdWithAutoCreate(new PartialPath("root.ln.d3"));
        MPPQueryContext context = new MPPQueryContext("", new QueryId("query1"), new SessionInfo(1L, "fakeUsername", "fakeZoneId"), new TEndPoint(), new TEndPoint());
        ExecutorService executor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"Test");
        QueryStateMachine stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        Assert.assertFalse((boolean)stateMachine.getState().isDone());
        StandaloneScheduler standaloneScheduler = new StandaloneScheduler(context, stateMachine, Collections.singletonList(fragmentInstance), QueryType.WRITE, null, null);
        try {
            standaloneScheduler.start();
            Assert.assertEquals((Object)QueryState.FINISHED, (Object)stateMachine.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            standaloneScheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertRow() throws DataRegionException, MetadataException {
        String deviceId = "root.vehicle.d0";
        String measurementId = "s0";
        TSRecord record = new TSRecord(10000L, deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)measurementId, (String)String.valueOf(1000)));
        InsertRowNode insertRowNode = DataRegionTest.buildInsertRowNodeByTSRecord(record);
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet(TConsensusGroupType.DataRegion);
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId("2", 3), (PlanNode)insertRowNode);
        FragmentInstance fragmentInstance = new FragmentInstance(planFragment, planFragment.getId().genFragmentInstanceId(), (Filter)new GroupByFilter(1L, 2L, 3L, 4L), QueryType.WRITE, conf.getQueryTimeoutThreshold());
        fragmentInstance.setDataRegionAndHost(regionReplicaSet);
        configNode.getBelongedSchemaRegionIdWithAutoCreate(new PartialPath(deviceId));
        configNode.getBelongedDataRegionIdWithAutoCreate(new PartialPath(deviceId));
        MPPQueryContext context = new MPPQueryContext("", new QueryId("query1"), new SessionInfo(1L, "fakeUsername", "fakeZoneId"), new TEndPoint(), new TEndPoint());
        ExecutorService executor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"Test");
        QueryStateMachine stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        Assert.assertFalse((boolean)stateMachine.getState().isDone());
        StandaloneScheduler standaloneScheduler = new StandaloneScheduler(context, stateMachine, Collections.singletonList(fragmentInstance), QueryType.WRITE, null, null);
        try {
            standaloneScheduler.start();
            Assert.assertEquals((Object)QueryState.FINISHED, (Object)stateMachine.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            standaloneScheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertTablet() throws DataRegionException, MetadataException {
        PartialPath deviceId = new PartialPath("root.vehicle.d0");
        String[] measurements = new String[]{"s0", "s1"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
        MeasurementSchema[] measurementSchemas = new MeasurementSchema[]{new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN)};
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new QueryId("test_write").genPlanNodeId(), deviceId, false, measurements, dataTypes, times, null, columns, times.length);
        TRegionReplicaSet regionReplicaSet = this.genRegionReplicaSet(TConsensusGroupType.DataRegion);
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId("2", 3), (PlanNode)insertTabletNode);
        FragmentInstance fragmentInstance = new FragmentInstance(planFragment, planFragment.getId().genFragmentInstanceId(), (Filter)new GroupByFilter(1L, 2L, 3L, 4L), QueryType.WRITE, conf.getQueryTimeoutThreshold());
        fragmentInstance.setDataRegionAndHost(regionReplicaSet);
        configNode.getBelongedSchemaRegionIdWithAutoCreate(deviceId);
        configNode.getBelongedDataRegionIdWithAutoCreate(deviceId);
        MPPQueryContext context = new MPPQueryContext("", new QueryId("query1"), new SessionInfo(1L, "fakeUsername", "fakeZoneId"), new TEndPoint(), new TEndPoint());
        ExecutorService executor = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"Test");
        QueryStateMachine stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        Assert.assertFalse((boolean)stateMachine.getState().isDone());
        StandaloneScheduler standaloneScheduler = new StandaloneScheduler(context, stateMachine, Collections.singletonList(fragmentInstance), QueryType.WRITE, null, null);
        try {
            standaloneScheduler.start();
            Assert.assertEquals((Object)QueryState.FINISHED, (Object)stateMachine.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            standaloneScheduler.stop();
        }
    }

    private TRegionReplicaSet genRegionReplicaSet(TConsensusGroupType type) {
        ArrayList<TDataNodeLocation> dataNodeList = new ArrayList<TDataNodeLocation>();
        dataNodeList.add(new TDataNodeLocation().setClientRpcEndPoint(new TEndPoint(conf.getRpcAddress(), conf.getRpcPort())).setInternalEndPoint(new TEndPoint(conf.getInternalAddress(), conf.getInternalPort())).setMPPDataExchangeEndPoint(new TEndPoint(conf.getInternalAddress(), conf.getMppDataExchangePort())).setDataRegionConsensusEndPoint(new TEndPoint(conf.getInternalAddress(), conf.getDataRegionConsensusPort())).setSchemaRegionConsensusEndPoint(new TEndPoint(conf.getInternalAddress(), conf.getSchemaRegionConsensusPort())));
        return new TRegionReplicaSet(new TConsensusGroupId(type, 0), dataNodeList);
    }
}

