/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.write;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WritePlanNodeSplitTest {
    long prevTimePartitionInterval;
    boolean prevEnableTimePartition;
    Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>> dataPartitionMap;
    private Map<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>> schemaPartitionMap;
    SeriesPartitionExecutor partitionExecutor;
    String executorClassName;
    int seriesSlotPartitionNum;

    @Before
    public void setUp() {
        this.prevTimePartitionInterval = StorageEngineV2.getTimePartitionInterval();
        this.prevEnableTimePartition = StorageEngineV2.isEnablePartition();
        StorageEngineV2.setTimePartitionInterval((long)100L);
        StorageEngineV2.setEnablePartition((boolean)true);
        this.executorClassName = IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass();
        this.seriesSlotPartitionNum = IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum();
        this.partitionExecutor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)this.executorClassName, (int)this.seriesSlotPartitionNum);
        this.initDataPartitionMap();
        this.initSchemaPartitionMap();
    }

    private void initDataPartitionMap() {
        int t;
        HashMap<TTimePartitionSlot, List<TRegionReplicaSet>> timePartitionSlotMap;
        int i;
        this.dataPartitionMap = new HashMap<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>>();
        HashMap seriesPartitionSlotMap = new HashMap();
        for (i = 0; i < this.seriesSlotPartitionNum; ++i) {
            timePartitionSlotMap = new HashMap<TTimePartitionSlot, List<TRegionReplicaSet>>();
            for (t = 0; t < 5; ++t) {
                timePartitionSlotMap.put(new TTimePartitionSlot((long)t * StorageEngineV2.getTimePartitionInterval()), Collections.singletonList(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, t), null)));
            }
            seriesPartitionSlotMap.put(new TSeriesPartitionSlot(i), timePartitionSlotMap);
        }
        this.dataPartitionMap.put("root.sg1", seriesPartitionSlotMap);
        seriesPartitionSlotMap = new HashMap();
        for (i = 0; i < this.seriesSlotPartitionNum; ++i) {
            timePartitionSlotMap = new HashMap();
            for (t = 0; t < 5; ++t) {
                timePartitionSlotMap.put(new TTimePartitionSlot((long)t * StorageEngineV2.getTimePartitionInterval()), Collections.singletonList(new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 5), null)));
            }
            seriesPartitionSlotMap.put(new TSeriesPartitionSlot(i), timePartitionSlotMap);
        }
        this.dataPartitionMap.put("root.sg2", seriesPartitionSlotMap);
    }

    private void initSchemaPartitionMap() {
        this.schemaPartitionMap = new HashMap<String, Map<TSeriesPartitionSlot, TRegionReplicaSet>>();
        HashMap<TSeriesPartitionSlot, TRegionReplicaSet> seriesPartitionSlotMap = new HashMap<TSeriesPartitionSlot, TRegionReplicaSet>();
        for (int i = 0; i < this.seriesSlotPartitionNum; ++i) {
            seriesPartitionSlotMap.put(new TSeriesPartitionSlot(i), new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, i % 5), null));
        }
        this.schemaPartitionMap.put("root.sg1", seriesPartitionSlotMap);
    }

    protected DataPartition getDataPartition(List<DataPartitionQueryParam> dataPartitionQueryParamList) {
        HashMap<String, Map> result = new HashMap<String, Map>();
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParamList) {
            String devicePath = dataPartitionQueryParam.getDevicePath();
            Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>> seriesPartitionSlotMap = null;
            Map seriesPartitionSlotMapResult = null;
            if (devicePath.startsWith("root.sg1")) {
                seriesPartitionSlotMap = this.dataPartitionMap.get("root.sg1");
                seriesPartitionSlotMapResult = result.computeIfAbsent("root.sg1", k -> new HashMap());
            } else if (devicePath.startsWith("root.sg2")) {
                seriesPartitionSlotMap = this.dataPartitionMap.get("root.sg2");
                seriesPartitionSlotMapResult = result.computeIfAbsent("root.sg2", k -> new HashMap());
            }
            TSeriesPartitionSlot seriesPartitionSlot = this.partitionExecutor.getSeriesPartitionSlot(dataPartitionQueryParam.getDevicePath());
            Map<TTimePartitionSlot, List<TRegionReplicaSet>> timePartitionSlotMap = seriesPartitionSlotMap.get(seriesPartitionSlot);
            Map timePartitionSlotMapResult = seriesPartitionSlotMapResult.computeIfAbsent(seriesPartitionSlot, k -> new HashMap());
            for (TTimePartitionSlot timePartitionSlot : dataPartitionQueryParam.getTimePartitionSlotList()) {
                timePartitionSlotMapResult.put(timePartitionSlot, timePartitionSlotMap.get(timePartitionSlot));
            }
        }
        return new DataPartition(result, this.executorClassName, this.seriesSlotPartitionNum);
    }

    @Test
    public void testSplitInsertTablet() throws IllegalPathException {
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId("plan node 1"));
        insertTabletNode.setDevicePath(new PartialPath("root.sg1.d1"));
        insertTabletNode.setTimes(new long[]{1L, 60L, 120L, 180L, 270L, 290L, 360L, 375L, 440L, 470L});
        insertTabletNode.setDataTypes(new TSDataType[]{TSDataType.INT32});
        insertTabletNode.setColumns(new Object[]{new int[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100}});
        DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDevicePath(insertTabletNode.getDevicePath().getFullPath());
        dataPartitionQueryParam.setTimePartitionSlotList(insertTabletNode.getTimePartitionSlots());
        DataPartition dataPartition = this.getDataPartition(Collections.singletonList(dataPartitionQueryParam));
        Analysis analysis = new Analysis();
        analysis.setDataPartitionInfo(dataPartition);
        List insertTabletNodeList = insertTabletNode.splitByPartition(analysis);
        Assert.assertEquals((long)5L, (long)insertTabletNodeList.size());
        for (WritePlanNode insertNode : insertTabletNodeList) {
            Assert.assertEquals((long)((InsertTabletNode)insertNode).getTimes().length, (long)2L);
        }
        insertTabletNode = new InsertTabletNode(new PlanNodeId("plan node 2"));
        insertTabletNode.setDevicePath(new PartialPath("root.sg2.d1"));
        insertTabletNode.setTimes(new long[]{1L, 60L, 120L, 180L, 270L, 290L, 360L, 375L, 440L, 470L});
        insertTabletNode.setDataTypes(new TSDataType[]{TSDataType.INT32});
        insertTabletNode.setColumns(new Object[]{new int[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100}});
        dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDevicePath(insertTabletNode.getDevicePath().getFullPath());
        dataPartitionQueryParam.setTimePartitionSlotList(insertTabletNode.getTimePartitionSlots());
        dataPartition = this.getDataPartition(Collections.singletonList(dataPartitionQueryParam));
        analysis = new Analysis();
        analysis.setDataPartitionInfo(dataPartition);
        insertTabletNodeList = insertTabletNode.splitByPartition(analysis);
        Assert.assertEquals((long)5L, (long)insertTabletNodeList.size());
        for (WritePlanNode insertNode : insertTabletNodeList) {
            Assert.assertEquals((long)((InsertTabletNode)insertNode).getTimes().length, (long)2L);
        }
    }

    @Test
    public void testInsertMultiTablets() throws IllegalPathException {
        InsertMultiTabletsNode insertMultiTabletsNode = new InsertMultiTabletsNode(new PlanNodeId("plan node 3"));
        for (int i = 0; i < 5; ++i) {
            Object insertTabletNode = new InsertTabletNode(new PlanNodeId("plan node 3"));
            insertTabletNode.setDevicePath(new PartialPath(String.format("root.sg1.d%d", i)));
            insertTabletNode.setTimes(new long[]{1L, 60L, 120L, 180L, 270L, 290L, 360L, 375L, 440L, 470L});
            insertTabletNode.setDataTypes(new TSDataType[]{TSDataType.INT32});
            insertTabletNode.setColumns(new Object[]{new int[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100}});
            insertMultiTabletsNode.addInsertTabletNode((InsertTabletNode)insertTabletNode, Integer.valueOf(2 * i));
            insertTabletNode = new InsertTabletNode(new PlanNodeId("plan node 3"));
            insertTabletNode.setDevicePath(new PartialPath(String.format("root.sg2.d%d", i)));
            insertTabletNode.setTimes(new long[]{1L, 60L, 120L, 180L, 270L, 290L, 360L, 375L, 440L, 470L});
            insertTabletNode.setDataTypes(new TSDataType[]{TSDataType.INT32});
            insertTabletNode.setColumns(new Object[]{new int[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100}});
            insertMultiTabletsNode.addInsertTabletNode((InsertTabletNode)insertTabletNode, Integer.valueOf(2 * i));
        }
        ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
        for (InsertTabletNode insertTabletNode : insertMultiTabletsNode.getInsertTabletNodeList()) {
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(insertTabletNode.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(insertTabletNode.getTimePartitionSlots());
            dataPartitionQueryParams.add(dataPartitionQueryParam);
        }
        DataPartition dataPartition = this.getDataPartition(dataPartitionQueryParams);
        Analysis analysis = new Analysis();
        analysis.setDataPartitionInfo(dataPartition);
        List insertTabletNodeList = insertMultiTabletsNode.splitByPartition(analysis);
        Assert.assertEquals((long)6L, (long)insertTabletNodeList.size());
    }

    @Test
    public void testInsertRowsNode() throws IllegalPathException {
        InsertRowsNode insertRowsNode = new InsertRowsNode(new PlanNodeId("plan node 3"));
        for (int i = 0; i < 5; ++i) {
            Object insertRowNode = new InsertRowNode(new PlanNodeId("plan node 3"));
            insertRowNode.setDevicePath(new PartialPath(String.format("root.sg1.d%d", i)));
            insertRowNode.setTime((long)i * StorageEngineV2.getTimePartitionInterval());
            insertRowsNode.addOneInsertRowNode((InsertRowNode)insertRowNode, 2 * i);
            insertRowNode = new InsertRowNode(new PlanNodeId("plan node 3"));
            insertRowNode.setDevicePath(new PartialPath(String.format("root.sg2.d%d", i)));
            insertRowNode.setTime(1L);
            insertRowsNode.addOneInsertRowNode((InsertRowNode)insertRowNode, 2 * i + 1);
        }
        ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
        for (InsertRowNode insertRowNode : insertRowsNode.getInsertRowNodeList()) {
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(insertRowNode.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(insertRowNode.getTimePartitionSlots());
            dataPartitionQueryParams.add(dataPartitionQueryParam);
        }
        DataPartition dataPartition = this.getDataPartition(dataPartitionQueryParams);
        Analysis analysis = new Analysis();
        analysis.setDataPartitionInfo(dataPartition);
        List insertTabletNodeList = insertRowsNode.splitByPartition(analysis);
        Assert.assertEquals((long)6L, (long)insertTabletNodeList.size());
    }

    @After
    public void tearDown() {
        StorageEngineV2.setTimePartitionInterval((long)this.prevTimePartitionInterval);
        StorageEngineV2.setEnablePartition((boolean)this.prevEnableTimePartition);
    }
}

