/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.write;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.utils.WALByteBufferForTest;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;

public class InsertTabletNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        InsertTabletNode insertTabletNode = this.getInsertTabletNode();
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        insertTabletNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PlanNodeType.INSERT_TABLET.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((Object)insertTabletNode, (Object)InsertTabletNode.deserialize((ByteBuffer)byteBuffer));
        insertTabletNode = this.getInsertTabletNodeWithSchema();
        byteBuffer = ByteBuffer.allocate(10000);
        insertTabletNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((long)PlanNodeType.INSERT_TABLET.getNodeType(), (long)byteBuffer.getShort());
        Assert.assertEquals((Object)insertTabletNode, (Object)InsertTabletNode.deserialize((ByteBuffer)byteBuffer));
    }

    @Test
    public void testSerializeAndDeserializeForWAL() throws IllegalPathException, IOException {
        InsertTabletNode insertTabletNode = this.getInsertTabletNodeWithSchema();
        int serializedSize = insertTabletNode.serializedSize();
        byte[] bytes = new byte[serializedSize];
        WALByteBufferForTest walBuffer = new WALByteBufferForTest(ByteBuffer.wrap(bytes));
        insertTabletNode.serializeToWAL((IWALByteBufferView)walBuffer);
        Assert.assertFalse((boolean)walBuffer.getBuffer().hasRemaining());
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        Assert.assertEquals((long)PlanNodeType.INSERT_TABLET.getNodeType(), (long)dataInputStream.readShort());
        InsertTabletNode tmpNode = InsertTabletNode.deserializeFromWAL((DataInputStream)dataInputStream);
        tmpNode.setPlanNodeId(insertTabletNode.getPlanNodeId());
        tmpNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN)});
        Assert.assertEquals((Object)insertTabletNode, (Object)tmpNode);
    }

    private InsertTabletNode getInsertTabletNode() throws IllegalPathException {
        long[] times = new long[]{110L, 111L, 112L, 113L};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN};
        Object[] columns = new Object[]{new double[4], new float[4], new long[4], new int[4], new boolean[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 1.0;
            ((float[])columns[1])[r] = 2.0f;
            ((long[])columns[2])[r] = 10000L;
            ((int[])columns[3])[r] = 100;
            ((boolean[])columns[4])[r] = false;
        }
        InsertTabletNode tabletNode = new InsertTabletNode(new PlanNodeId("plannode 1"), new PartialPath("root.isp.d1"), false, new String[]{"s1", "s2", "s3", "s4", "s5"}, dataTypes, times, null, columns, times.length);
        return tabletNode;
    }

    private InsertTabletNode getInsertTabletNodeWithSchema() throws IllegalPathException {
        long[] times = new long[]{110L, 111L, 112L, 113L};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN};
        Object[] columns = new Object[]{new double[4], new float[4], new long[4], new int[4], new boolean[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 1.0;
            ((float[])columns[1])[r] = 2.0f;
            ((long[])columns[2])[r] = 10000L;
            ((int[])columns[3])[r] = 100;
            ((boolean[])columns[4])[r] = false;
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId("plannode 1"), new PartialPath("root.isp.d1"), false, new String[]{"s1", "s2", "s3", "s4", "s5"}, dataTypes, times, null, columns, times.length);
        insertTabletNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN)});
        return insertTabletNode;
    }
}

