/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.source;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.compress.utils.Sets;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.read.filter.operator.In;
import org.junit.Assert;
import org.junit.Test;

public class SeriesAggregationScanNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws QueryProcessException, IllegalPathException {
        ArrayList<AggregationDescriptor> aggregationDescriptorList = new ArrayList<AggregationDescriptor>();
        aggregationDescriptorList.add(new AggregationDescriptor(AggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1")))));
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(1L, 100L, 1L, 1L, true, true, true);
        SeriesAggregationScanNode seriesAggregationScanNode = new SeriesAggregationScanNode(new PlanNodeId("TestSeriesAggregateScanNode"), new MeasurementPath("root.sg.d1.s1", TSDataType.BOOLEAN), aggregationDescriptorList, Ordering.ASC, (Filter)new In((Set)Sets.newHashSet((Object[])new String[]{"s1", "s2"}), FilterType.VALUE_FILTER, true), groupByTimeParameter, null);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
        seriesAggregationScanNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)seriesAggregationScanNode);
    }
}

