/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.process;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.junit.Assert;
import org.junit.Test;

public class TimeJoinNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        SeriesScanNode seriesScanNode1 = new SeriesScanNode(new PlanNodeId("TestSeriesScanNode"), new MeasurementPath("root.sg.d1.s1", TSDataType.INT32), Ordering.DESC, (Filter)TimeFilter.gt((long)100L), null, 100, 100, null);
        SeriesScanNode seriesScanNode2 = new SeriesScanNode(new PlanNodeId("TestSeriesScanNode"), new MeasurementPath("root.sg.d1.s2", TSDataType.INT32), Ordering.DESC, null, (Filter)ValueFilter.gt((Comparable)Integer.valueOf(100)), 100, 100, null);
        TimeJoinNode timeJoinNode = new TimeJoinNode(new PlanNodeId("TestTimeJoinNode"), Ordering.ASC);
        timeJoinNode.addChild((PlanNode)seriesScanNode1);
        timeJoinNode.addChild((PlanNode)seriesScanNode2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
        timeJoinNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)timeJoinNode);
    }
}

