/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.process;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SortNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.junit.Assert;
import org.junit.Test;

public class SortNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        SeriesScanNode seriesScanNode = new SeriesScanNode(new PlanNodeId("TestSeriesScanNode"), new MeasurementPath("root.sg.d1.s1", TSDataType.INT32), Ordering.DESC, (Filter)new GroupByFilter(1L, 2L, 3L, 4L), null, 100, 100, null);
        SortNode sortNode = new SortNode(new PlanNodeId("TestSortNode"), (PlanNode)seriesScanNode, Ordering.ASC);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2048);
        sortNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)sortNode);
    }
}

