/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.process;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.compress.utils.Sets;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;
import org.apache.iotdb.tsfile.read.filter.operator.In;
import org.junit.Assert;
import org.junit.Test;

public class AggregationNodeSerdeTest {
    @Test
    public void testSerializeAndDeserialize() throws IllegalPathException {
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(1L, 100L, 1L, 1L, false, false, false);
        SeriesAggregationScanNode seriesAggregationScanNode = new SeriesAggregationScanNode(new PlanNodeId("TestSeriesAggregateScanNode"), new MeasurementPath("root.sg.d1.s1", TSDataType.BOOLEAN), Collections.singletonList(new AggregationDescriptor(AggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.INTERMEDIATE, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))))), Ordering.ASC, (Filter)new In((Set)Sets.newHashSet((Object[])new String[]{"s1", "s2"}), FilterType.VALUE_FILTER, true), groupByTimeParameter, null);
        AggregationNode aggregationNode = new AggregationNode(new PlanNodeId("TestAggregateNode"), Collections.singletonList(seriesAggregationScanNode), Collections.singletonList(new AggregationDescriptor(AggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath("root.sg.d1.s1"))))), groupByTimeParameter, Ordering.ASC);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        aggregationNode.serialize(byteBuffer);
        byteBuffer.flip();
        Assert.assertEquals((Object)PlanNodeDeserializeHelper.deserialize(byteBuffer), (Object)aggregationNode);
    }

    @Test
    public void getDeduplicatedDescriptorsTest1() {
        PartialPath seriesPath1 = new PartialPath(new String[]{"root", "sg", "d1", "s1"});
        ArrayList<AggregationType> aggregationTypeList = new ArrayList<AggregationType>();
        aggregationTypeList.add(AggregationType.COUNT);
        aggregationTypeList.add(AggregationType.AVG);
        aggregationTypeList.add(AggregationType.SUM);
        ArrayList<AggregationDescriptor> descriptorList = new ArrayList<AggregationDescriptor>();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        List deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        aggregationTypeList = new ArrayList();
        aggregationTypeList.add(AggregationType.COUNT);
        aggregationTypeList.add(AggregationType.SUM);
        aggregationTypeList.add(AggregationType.AVG);
        descriptorList = new ArrayList();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        aggregationTypeList = new ArrayList();
        aggregationTypeList.add(AggregationType.AVG);
        aggregationTypeList.add(AggregationType.COUNT);
        aggregationTypeList.add(AggregationType.SUM);
        descriptorList = new ArrayList();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        descriptorList = new ArrayList();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)3L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)AggregationType.COUNT, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
        Assert.assertEquals((Object)AggregationType.SUM, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(2)).getAggregationType());
    }

    @Test
    public void getDeduplicatedDescriptorsTest2() {
        PartialPath seriesPath1 = new PartialPath(new String[]{"root", "sg", "d1", "s1"});
        ArrayList<AggregationType> aggregationTypeList = new ArrayList<AggregationType>();
        aggregationTypeList.add(AggregationType.FIRST_VALUE);
        aggregationTypeList.add(AggregationType.MIN_TIME);
        ArrayList<AggregationDescriptor> descriptorList = new ArrayList<AggregationDescriptor>();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        List deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.FIRST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        aggregationTypeList = new ArrayList();
        aggregationTypeList.add(AggregationType.MIN_TIME);
        aggregationTypeList.add(AggregationType.FIRST_VALUE);
        descriptorList = new ArrayList();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.FIRST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        descriptorList = new ArrayList();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.MIN_TIME, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)AggregationType.FIRST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
    }

    @Test
    public void getDeduplicatedDescriptorsTest3() {
        PartialPath seriesPath1 = new PartialPath(new String[]{"root", "sg", "d1", "s1"});
        ArrayList<AggregationType> aggregationTypeList = new ArrayList<AggregationType>();
        aggregationTypeList.add(AggregationType.LAST_VALUE);
        aggregationTypeList.add(AggregationType.MAX_TIME);
        ArrayList<AggregationDescriptor> descriptorList = new ArrayList<AggregationDescriptor>();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        List deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.LAST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        aggregationTypeList = new ArrayList();
        aggregationTypeList.add(AggregationType.MAX_TIME);
        aggregationTypeList.add(AggregationType.LAST_VALUE);
        descriptorList = new ArrayList();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)1L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.LAST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        descriptorList = new ArrayList();
        for (AggregationType aggregationType : aggregationTypeList) {
            descriptorList.add(new AggregationDescriptor(aggregationType.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        }
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.MAX_TIME, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)AggregationType.LAST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
    }

    @Test
    public void getDeduplicatedDescriptorsTest4() {
        PartialPath seriesPath1 = new PartialPath(new String[]{"root", "sg", "d1", "s1"});
        PartialPath seriesPath2 = new PartialPath(new String[]{"root", "sg", "d1", "s2"});
        ArrayList<AggregationDescriptor> descriptorList = new ArrayList<AggregationDescriptor>();
        descriptorList.add(new AggregationDescriptor(AggregationType.AVG.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        descriptorList.add(new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath2))));
        List deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.AVG, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)AggregationType.COUNT, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
        descriptorList = new ArrayList();
        descriptorList.add(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        descriptorList.add(new AggregationDescriptor(AggregationType.MIN_TIME.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath2))));
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.FIRST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)AggregationType.MIN_TIME, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
        descriptorList = new ArrayList();
        descriptorList.add(new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath1))));
        descriptorList.add(new AggregationDescriptor(AggregationType.MAX_TIME.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(seriesPath2))));
        deduplicatedDescriptors = AggregationNode.getDeduplicatedDescriptors(descriptorList);
        Assert.assertEquals((long)2L, (long)deduplicatedDescriptors.size());
        Assert.assertEquals((Object)AggregationType.LAST_VALUE, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(0)).getAggregationType());
        Assert.assertEquals((Object)AggregationType.MAX_TIME, (Object)((AggregationDescriptor)deduplicatedDescriptors.get(1)).getAggregationType());
    }
}

