/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.metadata.read;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;
import org.junit.Assert;
import org.junit.Test;

public class SchemaFetchScanNodeTest {
    @Test
    public void testSerialization() throws IllegalPathException {
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg.**.*"));
        SchemaFetchScanNode schemaFetchScanNode = new SchemaFetchScanNode(new PlanNodeId("0"), new PartialPath("root.sg"), patternTree, Collections.emptyMap());
        ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
        schemaFetchScanNode.serialize(byteBuffer);
        byteBuffer.flip();
        SchemaFetchScanNode recoveredNode = (SchemaFetchScanNode)PlanNodeType.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)"root.sg", (Object)recoveredNode.getStorageGroup().getFullPath());
        Assert.assertEquals((Object)"root.sg.**.*", (Object)((PartialPath)recoveredNode.getPatternTree().getAllPathPatterns().get(0)).getFullPath());
    }
}

