/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.metadata.read;

import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.DevicesCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.LevelTimeSeriesCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.junit.Assert;
import org.junit.Test;

public class SchemaCountNodeSerdeTest {
    @Test
    public void testDevicesCountSerializeAndDeserialize() throws IllegalPathException {
        CountSchemaMergeNode countMergeNode = new CountSchemaMergeNode(new PlanNodeId("countMerge"));
        ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId("exchange"));
        DevicesCountNode devicesCountNode = new DevicesCountNode(new PlanNodeId("devicesCount"), new PartialPath("root.sg.device0"), true);
        FragmentSinkNode fragmentSinkNode = new FragmentSinkNode(new PlanNodeId("fragmentSink"));
        fragmentSinkNode.addChild((PlanNode)devicesCountNode);
        fragmentSinkNode.setDownStream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        exchangeNode.addChild((PlanNode)countMergeNode);
        exchangeNode.setRemoteSourceNode(fragmentSinkNode);
        exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        exchangeNode.serialize(byteBuffer);
        byteBuffer.flip();
        ExchangeNode exchangeNode1 = (ExchangeNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
        Assert.assertEquals((Object)exchangeNode, (Object)exchangeNode1);
    }

    @Test
    public void testTimeSeriesCountSerializeAndDeserialize() throws IllegalPathException {
        CountSchemaMergeNode countMergeNode = new CountSchemaMergeNode(new PlanNodeId("countMerge"));
        ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId("exchange"));
        LevelTimeSeriesCountNode levelTimeSeriesCountNode = new LevelTimeSeriesCountNode(new PlanNodeId("timeseriesCount"), new PartialPath("root.sg.device0"), true, 10, null, null, false);
        FragmentSinkNode fragmentSinkNode = new FragmentSinkNode(new PlanNodeId("fragmentSink"));
        fragmentSinkNode.addChild((PlanNode)levelTimeSeriesCountNode);
        fragmentSinkNode.setDownStream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        exchangeNode.addChild((PlanNode)countMergeNode);
        exchangeNode.setRemoteSourceNode(fragmentSinkNode);
        exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        exchangeNode.serialize(byteBuffer);
        byteBuffer.flip();
        ExchangeNode exchangeNode1 = (ExchangeNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
        Assert.assertEquals((Object)exchangeNode, (Object)exchangeNode1);
    }
}

