/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.node.metadata.read;

import java.nio.ByteBuffer;
import java.util.HashSet;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNodeType;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodeManagementMemoryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsConvertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.junit.Assert;
import org.junit.Test;

public class NodeManagementMemoryMergeNodeSerdeTest {
    @Test
    public void testNodePathsSerializeAndDeserialize() throws IllegalPathException {
        NodeManagementMemoryMergeNode memorySourceNode = this.createNodeManagementMemoryMergeNode();
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        memorySourceNode.serialize(byteBuffer);
        byteBuffer.flip();
        NodeManagementMemoryMergeNode memorySourceNode1 = (NodeManagementMemoryMergeNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
        Assert.assertEquals((Object)memorySourceNode, (Object)memorySourceNode1);
    }

    @Test
    public void testNodeConvertSerializeAndDeserialize() throws IllegalPathException {
        NodeManagementMemoryMergeNode memorySourceNode = this.createNodeManagementMemoryMergeNode();
        NodePathsConvertNode node = new NodePathsConvertNode(new PlanNodeId("nodePathConvert"));
        node.addChild((PlanNode)memorySourceNode);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        node.serialize(byteBuffer);
        byteBuffer.flip();
        NodePathsConvertNode node1 = (NodePathsConvertNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
        Assert.assertEquals((Object)node, (Object)node1);
    }

    @Test
    public void testNodeCountSerializeAndDeserialize() throws IllegalPathException {
        NodeManagementMemoryMergeNode memorySourceNode = this.createNodeManagementMemoryMergeNode();
        NodePathsCountNode node = new NodePathsCountNode(new PlanNodeId("nodePathCount"));
        node.addChild((PlanNode)memorySourceNode);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        node.serialize(byteBuffer);
        byteBuffer.flip();
        NodePathsCountNode node1 = (NodePathsCountNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
        Assert.assertEquals((Object)node, (Object)node1);
    }

    private NodeManagementMemoryMergeNode createNodeManagementMemoryMergeNode() throws IllegalPathException {
        HashSet<TSchemaNode> data = new HashSet<TSchemaNode>();
        data.add(new TSchemaNode("root.ln", MNodeType.STORAGE_GROUP.getNodeType()));
        data.add(new TSchemaNode("root.abc", MNodeType.STORAGE_GROUP.getNodeType()));
        NodeManagementMemoryMergeNode memorySourceNode = new NodeManagementMemoryMergeNode(new PlanNodeId("nodeManagementMerge"), data);
        SchemaQueryMergeNode schemaMergeNode = new SchemaQueryMergeNode(new PlanNodeId("schemaMerge"));
        ExchangeNode exchangeNode = new ExchangeNode(new PlanNodeId("exchange"));
        NodePathsSchemaScanNode childPathsSchemaScanNode = new NodePathsSchemaScanNode(new PlanNodeId("NodePathsScan"), new PartialPath("root.ln"), -1);
        FragmentSinkNode fragmentSinkNode = new FragmentSinkNode(new PlanNodeId("fragmentSink"));
        fragmentSinkNode.addChild((PlanNode)childPathsSchemaScanNode);
        fragmentSinkNode.setDownStream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        exchangeNode.addChild((PlanNode)schemaMergeNode);
        exchangeNode.setRemoteSourceNode(fragmentSinkNode);
        exchangeNode.setUpstream(new TEndPoint("127.0.0.1", 6667), new FragmentInstanceId(new PlanFragmentId("q", 1), "ds"), new PlanNodeId("test"));
        memorySourceNode.addChild((PlanNode)exchangeNode);
        return memorySourceNode;
    }
}

