/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.plan.distribution.Util;
import org.apache.iotdb.db.mpp.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.mpp.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationSourceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByLevelDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class AggregationDistributionTest {
    @Test
    public void testTimeJoinAggregationSinglePerRegion() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_time_join_aggregation");
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC);
        String d1s1Path = "root.sg.d1.s1";
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT));
        String d2s1Path = "root.sg.d22.s1";
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d2s1Path, AggregationType.COUNT));
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)timeJoinNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d2s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
    }

    private void verifyAggregationStep(Map<String, AggregationStep> expected, PlanNode root) {
        if (root == null) {
            return;
        }
        if (root instanceof SeriesAggregationSourceNode) {
            SeriesAggregationSourceNode handle = (SeriesAggregationSourceNode)root;
            List descriptorList = handle.getAggregationDescriptorList();
            descriptorList.forEach(d -> Assert.assertEquals(expected.get(handle.getPartitionPath().getFullPath()), (Object)d.getStep()));
        }
        root.getChildren().forEach(child -> this.verifyAggregationStep(expected, (PlanNode)child));
    }

    @Test
    public void testTimeJoinAggregationWithSlidingWindow() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_time_join_agg_with_sliding");
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC);
        String d1s1Path = "root.sg.d1.s1";
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT));
        String d3s1Path = "root.sg.d333.s1";
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d3s1Path, AggregationType.COUNT));
        SlidingWindowAggregationNode slidingWindowAggregationNode = this.genSlidingWindowAggregationNode(queryId, Arrays.asList(new PartialPath(d1s1Path), new PartialPath(d3s1Path)), AggregationType.COUNT, AggregationStep.PARTIAL, null);
        slidingWindowAggregationNode.addChild((PlanNode)timeJoinNode);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)slidingWindowAggregationNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        AggregationNode aggregationNode = (AggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0);
        aggregationNode.getAggregationDescriptorList().forEach(d -> Assert.assertEquals((Object)AggregationStep.INTERMEDIATE, (Object)d.getStep()));
    }

    @Test
    public void testTimeJoinAggregationMultiPerRegion() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_time_join_aggregation");
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC);
        String d1s1Path = "root.sg.d1.s1";
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT));
        String d3s1Path = "root.sg.d333.s1";
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d3s1Path, AggregationType.COUNT));
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)timeJoinNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
    }

    @Test
    public void testTimeJoinAggregationMultiPerRegion2() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_time_join_aggregation");
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC);
        String d3s1Path = "root.sg.d333.s1";
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d3s1Path, AggregationType.COUNT));
        String d4s1Path = "root.sg.d4444.s1";
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d4s1Path, AggregationType.COUNT));
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)timeJoinNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d4s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
    }

    @Test
    public void testGroupByLevelWithTwoChildren() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_children");
        String d1s1Path = "root.sg.d1.s1";
        String d2s1Path = "root.sg.d22.s1";
        String groupedPath = "root.sg.*.s1";
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Arrays.asList(this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d2s1Path, AggregationType.COUNT)), Collections.singletonList(new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d1s1Path)), new TimeSeriesOperand(new PartialPath(d2s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPath)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d2s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
    }

    @Test
    public void testAggregationWithMultiGroupByLevelNode() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_children");
        String d3s1Path = "root.sg.d333.s1";
        String d4s1Path = "root.sg.d4444.s1";
        String groupedPath = "root.sg.*.s1";
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Arrays.asList(this.genAggregationSourceNode(queryId, d3s1Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d4s1Path, AggregationType.COUNT)), Collections.singletonList(new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d3s1Path)), new TimeSeriesOperand(new PartialPath(d4s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPath)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d4s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPath, Arrays.asList(groupedPath, d3s1Path, d4s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPath, Arrays.asList(d3s1Path, d4s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0));
    }

    @Test
    public void testGroupByLevelNodeWithSlidingWindow() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_with_sliding_window");
        String d3s1Path = "root.sg.d333.s1";
        String d4s1Path = "root.sg.d4444.s1";
        String groupedPath = "root.sg.*.s1";
        SlidingWindowAggregationNode slidingWindowAggregationNode = this.genSlidingWindowAggregationNode(queryId, Arrays.asList(new PartialPath(d3s1Path), new PartialPath(d4s1Path)), AggregationType.COUNT, AggregationStep.PARTIAL, null);
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC);
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d3s1Path, AggregationType.COUNT));
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d4s1Path, AggregationType.COUNT));
        slidingWindowAggregationNode.addChild((PlanNode)timeJoinNode);
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Collections.singletonList(slidingWindowAggregationNode), Collections.singletonList(new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d3s1Path)), new TimeSeriesOperand(new PartialPath(d4s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPath)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d3s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d4s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPath, Arrays.asList(groupedPath, d3s1Path, d4s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPath, Arrays.asList(d3s1Path, d4s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0));
        this.verifySlidingWindowDescriptor(Arrays.asList(d3s1Path, d4s1Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
        this.verifySlidingWindowDescriptor(Arrays.asList(d3s1Path, d4s1Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
    }

    @Test
    public void testGroupByLevelTwoSeries() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_series");
        String d1s1Path = "root.sg.d1.s1";
        String d1s2Path = "root.sg.d1.s2";
        String groupedPathS1 = "root.sg.*.s1";
        String groupedPathS2 = "root.sg.*.s2";
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Arrays.asList(this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d1s2Path, AggregationType.COUNT)), Arrays.asList(new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(d1s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS1))), new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(d1s2Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS2)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)2L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d1s2Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPathS1, Arrays.asList(groupedPathS1, d1s1Path));
        expectedDescriptorValue.put(groupedPathS2, Arrays.asList(groupedPathS2, d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPathS1, Collections.singletonList(d1s1Path));
        expectedDescriptorValue2.put(groupedPathS2, Collections.singletonList(d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0));
    }

    @Test
    public void testGroupByLevel2Series2Devices3Regions() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_series");
        String d1s1Path = "root.sg.d1.s1";
        String d1s2Path = "root.sg.d1.s2";
        String d2s1Path = "root.sg.d22.s1";
        String groupedPathS1 = "root.sg.*.s1";
        String groupedPathS2 = "root.sg.*.s2";
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Arrays.asList(this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d1s2Path, AggregationType.COUNT), this.genAggregationSourceNode(queryId, d2s1Path, AggregationType.COUNT)), Arrays.asList(new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d1s1Path)), new TimeSeriesOperand(new PartialPath(d2s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS1))), new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(d1s2Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS2)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d1s2Path, AggregationStep.PARTIAL);
        expectedStep.put(d2s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPathS1, Arrays.asList(groupedPathS1, d1s1Path, d2s1Path));
        expectedDescriptorValue.put(groupedPathS2, Arrays.asList(groupedPathS2, d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPathS1, Collections.singletonList(d1s1Path));
        expectedDescriptorValue2.put(groupedPathS2, Collections.singletonList(d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(2)).getFragment().getPlanNodeTree().getChildren().get(0));
    }

    @Test
    public void testGroupByLevelWithSliding2Series2Devices3Regions() throws IllegalPathException {
        QueryId queryId = new QueryId("test_group_by_level_two_series");
        String d1s1Path = "root.sg.d1.s1";
        String d1s2Path = "root.sg.d1.s2";
        String d2s1Path = "root.sg.d22.s1";
        String groupedPathS1 = "root.sg.*.s1";
        String groupedPathS2 = "root.sg.*.s2";
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC);
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d1s1Path, AggregationType.COUNT));
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d1s2Path, AggregationType.COUNT));
        timeJoinNode.addChild((PlanNode)this.genAggregationSourceNode(queryId, d2s1Path, AggregationType.COUNT));
        SlidingWindowAggregationNode slidingWindowAggregationNode = this.genSlidingWindowAggregationNode(queryId, Arrays.asList(new PartialPath(d1s1Path), new PartialPath(d1s2Path), new PartialPath(d2s1Path)), AggregationType.COUNT, AggregationStep.PARTIAL, null);
        slidingWindowAggregationNode.addChild((PlanNode)timeJoinNode);
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(new PlanNodeId("TestGroupByLevelNode"), Collections.singletonList(slidingWindowAggregationNode), Arrays.asList(new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(new PartialPath(d1s1Path)), new TimeSeriesOperand(new PartialPath(d2s1Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS1))), new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(d1s2Path))), (Expression)new TimeSeriesOperand(new PartialPath(groupedPathS2)))), null, Ordering.ASC);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)groupByLevelNode));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
        HashMap<String, AggregationStep> expectedStep = new HashMap<String, AggregationStep>();
        expectedStep.put(d1s1Path, AggregationStep.PARTIAL);
        expectedStep.put(d1s2Path, AggregationStep.PARTIAL);
        expectedStep.put(d2s1Path, AggregationStep.PARTIAL);
        List fragmentInstances = plan.getInstances();
        fragmentInstances.forEach(f -> this.verifyAggregationStep(expectedStep, f.getFragment().getPlanNodeTree()));
        HashMap<String, List<String>> expectedDescriptorValue = new HashMap<String, List<String>>();
        expectedDescriptorValue.put(groupedPathS1, Arrays.asList(groupedPathS1, d1s1Path));
        expectedDescriptorValue.put(groupedPathS2, Arrays.asList(groupedPathS2, d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue2 = new HashMap<String, List<String>>();
        expectedDescriptorValue2.put(groupedPathS1, Collections.singletonList(d2s1Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue2, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0));
        HashMap<String, List<String>> expectedDescriptorValue3 = new HashMap<String, List<String>>();
        expectedDescriptorValue3.put(groupedPathS1, Collections.singletonList(d1s1Path));
        expectedDescriptorValue3.put(groupedPathS2, Collections.singletonList(d1s2Path));
        this.verifyGroupByLevelDescriptor(expectedDescriptorValue3, (GroupByLevelNode)((FragmentInstance)fragmentInstances.get(2)).getFragment().getPlanNodeTree().getChildren().get(0));
        this.verifySlidingWindowDescriptor(Arrays.asList(d1s1Path, d1s2Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(0)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
        this.verifySlidingWindowDescriptor(Collections.singletonList(d2s1Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(1)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
        this.verifySlidingWindowDescriptor(Arrays.asList(d1s1Path, d1s2Path), (SlidingWindowAggregationNode)((PlanNode)((FragmentInstance)fragmentInstances.get(2)).getFragment().getPlanNodeTree().getChildren().get(0)).getChildren().get(0));
    }

    @Test
    public void testAggregation1Series1Region() throws IllegalPathException {
        QueryId queryId = new QueryId("test_aggregation_1_series_1_region");
        String d2s1Path = "root.sg.d22.s1";
        SeriesAggregationSourceNode root = this.genAggregationSourceNode(queryId, d2s1Path, AggregationType.COUNT);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)root));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)1L, (long)plan.getInstances().size());
        Assert.assertEquals((Object)root, ((FragmentInstance)plan.getInstances().get(0)).getFragment().getPlanNodeTree().getChildren().get(0));
    }

    private void verifyGroupByLevelDescriptor(Map<String, List<String>> expected, GroupByLevelNode node) {
        List descriptors = node.getGroupByLevelDescriptors();
        Assert.assertEquals((long)expected.size(), (long)descriptors.size());
        for (GroupByLevelDescriptor descriptor : descriptors) {
            String outputExpression = descriptor.getOutputExpression().getExpressionString();
            Assert.assertEquals((long)expected.get(outputExpression).size(), (long)descriptor.getInputExpressions().size());
            for (Expression inputExpression : descriptor.getInputExpressions()) {
                Assert.assertTrue((boolean)expected.get(outputExpression).contains(inputExpression.getExpressionString()));
            }
        }
    }

    private void verifySlidingWindowDescriptor(List<String> expected, SlidingWindowAggregationNode node) {
        List descriptorList = node.getAggregationDescriptorList();
        Assert.assertEquals((long)expected.size(), (long)descriptorList.size());
        HashMap verification = new HashMap();
        descriptorList.forEach(d -> verification.put(((Expression)d.getInputExpressions().get(0)).getExpressionString(), 1));
        Assert.assertEquals((long)expected.size(), (long)verification.size());
        expected.forEach(v -> Assert.assertEquals((long)1L, (long)((Integer)verification.get(v)).intValue()));
    }

    private SlidingWindowAggregationNode genSlidingWindowAggregationNode(QueryId queryId, List<PartialPath> paths, AggregationType type, AggregationStep step, GroupByTimeParameter groupByTimeParameter) {
        return new SlidingWindowAggregationNode(queryId.genPlanNodeId(), paths.stream().map(path -> new AggregationDescriptor(type.name().toLowerCase(), step, Collections.singletonList(new TimeSeriesOperand(path)))).collect(Collectors.toList()), groupByTimeParameter, Ordering.ASC);
    }

    private SeriesAggregationSourceNode genAggregationSourceNode(QueryId queryId, String path, AggregationType type) throws IllegalPathException {
        ArrayList<AggregationDescriptor> descriptors = new ArrayList<AggregationDescriptor>();
        descriptors.add(new AggregationDescriptor(type.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(new PartialPath(path)))));
        return new SeriesAggregationScanNode(queryId.genPlanNodeId(), new MeasurementPath(path, TSDataType.INT32), descriptors);
    }

    @Test
    public void testParallelPlanWithAlignedSeries() throws IllegalPathException {
        QueryId queryId = new QueryId("test_query_aligned");
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC);
        timeJoinNode.addChild((PlanNode)new AlignedSeriesScanNode(queryId.genPlanNodeId(), new AlignedPath("root.sg.d1", Arrays.asList("s1", "s2")), Ordering.ASC));
        timeJoinNode.addChild((PlanNode)new SeriesScanNode(queryId.genPlanNodeId(), new MeasurementPath("root.sg.d333.s1", TSDataType.INT32), Ordering.ASC));
        LimitNode root = new LimitNode(queryId.genPlanNodeId(), (PlanNode)timeJoinNode, 10);
        Analysis analysis = Util.constructAnalysis();
        MPPQueryContext context = new MPPQueryContext("", queryId, null, new TEndPoint(), new TEndPoint());
        DistributionPlanner planner = new DistributionPlanner(analysis, new LogicalQueryPlan(context, (PlanNode)root));
        DistributedQueryPlan plan = planner.planFragments();
        Assert.assertEquals((long)3L, (long)plan.getInstances().size());
    }
}

