/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.last.LastQueryNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedLastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByLevelDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class QueryLogicalPlanUtil {
    public static final List<String> querySQLs = new ArrayList<String>();
    public static final Map<String, PlanNode> sqlToPlanMap = new HashMap<String, PlanNode>();
    public static final Map<String, PartialPath> schemaMap = new HashMap<String, PartialPath>();

    private static /* synthetic */ void lambda$static$6(Filter timeFilter, PlanNode node) {
        ((SeriesAggregationScanNode)node).setTimeFilter(timeFilter);
    }

    private static /* synthetic */ void lambda$static$5(Filter timeFilter, PlanNode node) {
        ((SeriesAggregationScanNode)node).setTimeFilter(timeFilter);
    }

    private static /* synthetic */ void lambda$static$4(Filter timeFilter, PlanNode node) {
        if (node instanceof SeriesAggregationScanNode) {
            ((SeriesAggregationScanNode)node).setTimeFilter(timeFilter);
        } else {
            ((AlignedSeriesAggregationScanNode)node).setTimeFilter(timeFilter);
        }
    }

    private static /* synthetic */ void lambda$static$3(Filter timeFilter, PlanNode node) {
        if (node instanceof SeriesAggregationScanNode) {
            ((SeriesAggregationScanNode)node).setTimeFilter(timeFilter);
        } else {
            ((AlignedSeriesAggregationScanNode)node).setTimeFilter(timeFilter);
        }
    }

    static {
        try {
            schemaMap.put("root.sg.d1.s1", (PartialPath)new MeasurementPath("root.sg.d1.s1", TSDataType.INT32));
            schemaMap.put("root.sg.d1.s2", (PartialPath)new MeasurementPath("root.sg.d1.s2", TSDataType.DOUBLE));
            schemaMap.put("root.sg.d1.s3", (PartialPath)new MeasurementPath("root.sg.d1.s3", TSDataType.BOOLEAN));
            schemaMap.put("root.sg.d2.s1", (PartialPath)new MeasurementPath("root.sg.d2.s1", TSDataType.INT32));
            schemaMap.put("root.sg.d2.s2", (PartialPath)new MeasurementPath("root.sg.d2.s2", TSDataType.DOUBLE));
            schemaMap.put("root.sg.d2.s4", (PartialPath)new MeasurementPath("root.sg.d2.s4", TSDataType.TEXT));
            schemaMap.put("root.sg.*.s1", (PartialPath)new MeasurementPath("root.sg.*.s1", TSDataType.INT32));
            schemaMap.put("root.sg.*.s2", (PartialPath)new MeasurementPath("root.sg.*.s2", TSDataType.DOUBLE));
            schemaMap.put("root.sg.*.*.s1", (PartialPath)new MeasurementPath("root.sg.*.*.s1", TSDataType.INT32));
            schemaMap.put("root.sg.*.*.s2", (PartialPath)new MeasurementPath("root.sg.*.*.s2", TSDataType.DOUBLE));
            MeasurementPath aS1 = new MeasurementPath("root.sg.d2.a.s1", TSDataType.INT32);
            MeasurementPath aS2 = new MeasurementPath("root.sg.d2.a.s2", TSDataType.DOUBLE);
            AlignedPath alignedPath = new AlignedPath("root.sg.d2.a", Arrays.asList("s1", "s2"), Arrays.asList(aS1.getMeasurementSchema(), aS2.getMeasurementSchema()));
            aS1.setUnderAlignedEntity(true);
            aS2.setUnderAlignedEntity(true);
            schemaMap.put("root.sg.d2.a.s1", (PartialPath)aS1);
            schemaMap.put("root.sg.d2.a.s2", (PartialPath)aS2);
            schemaMap.put("root.sg.d2.a", (PartialPath)alignedPath);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
        }
        String sql = "SELECT last * FROM root.sg.** WHERE time > 100 ORDER BY timeseries ASC";
        QueryId queryId = new QueryId("test");
        ArrayList<Object> sourceNodeList = new ArrayList<Object>();
        sourceNodeList.add(new LastQueryScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s1")));
        sourceNodeList.add(new LastQueryScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s2")));
        sourceNodeList.add(new LastQueryScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s3")));
        sourceNodeList.add(new AlignedLastQueryScanNode(queryId.genPlanNodeId(), new AlignedPath((MeasurementPath)schemaMap.get("root.sg.d2.a.s1"))));
        sourceNodeList.add(new AlignedLastQueryScanNode(queryId.genPlanNodeId(), new AlignedPath((MeasurementPath)schemaMap.get("root.sg.d2.a.s2"))));
        sourceNodeList.add(new LastQueryScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1")));
        sourceNodeList.add(new LastQueryScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s2")));
        sourceNodeList.add(new LastQueryScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s4")));
        LastQueryNode lastQueryNode = new LastQueryNode(queryId.genPlanNodeId(), sourceNodeList, (Filter)TimeFilter.gt((long)100L), new OrderByParameter(Collections.singletonList(new SortItem(SortKey.TIMESERIES, Ordering.ASC))));
        querySQLs.add(sql);
        sqlToPlanMap.put(sql, (PlanNode)lastQueryNode);
        sql = "SELECT ** FROM root.sg.d2 LIMIT 10 OFFSET 10";
        queryId = new QueryId("test");
        sourceNodeList = new ArrayList();
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1"), Ordering.ASC));
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s2"), Ordering.ASC));
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s4"), Ordering.ASC));
        sourceNodeList.add(new AlignedSeriesScanNode(queryId.genPlanNodeId(), (AlignedPath)schemaMap.get("root.sg.d2.a"), Ordering.ASC));
        TimeJoinNode timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC, sourceNodeList);
        OffsetNode offsetNode = new OffsetNode(queryId.genPlanNodeId(), (PlanNode)timeJoinNode, 10);
        LimitNode limitNode = new LimitNode(queryId.genPlanNodeId(), (PlanNode)offsetNode, 10);
        querySQLs.add(sql);
        sqlToPlanMap.put(sql, (PlanNode)limitNode);
        sql = "SELECT s1 FROM root.sg.* WHERE time > 100 and s2 > 10 ORDER BY TIME DESC LIMIT 100 OFFSET 100 SLIMIT 1 SOFFSET 1";
        queryId = new QueryId("test");
        sourceNodeList = new ArrayList();
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1"), Ordering.DESC));
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s2"), Ordering.DESC));
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s2"), Ordering.DESC));
        sourceNodeList.forEach(planNode -> ((SeriesScanNode)planNode).setTimeFilter((Filter)TimeFilter.gt((long)100L)));
        timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.DESC, sourceNodeList);
        GreaterThanExpression valueFilter1 = new GreaterThanExpression((Expression)new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT32, "10"));
        GreaterThanExpression valueFilter2 = new GreaterThanExpression((Expression)new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2")), (Expression)new ConstantOperand(TSDataType.INT32, "10"));
        LogicAndExpression predicate = new LogicAndExpression((Expression)valueFilter1, (Expression)valueFilter2);
        FilterNode filterNode = new FilterNode(queryId.genPlanNodeId(), (PlanNode)timeJoinNode, new Expression[]{new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1"))}, (Expression)predicate, false, (ZoneId)ZonedDateTime.now().getOffset(), Ordering.DESC);
        OffsetNode offsetNode2 = new OffsetNode(queryId.genPlanNodeId(), (PlanNode)filterNode, 100);
        LimitNode limitNode2 = new LimitNode(queryId.genPlanNodeId(), (PlanNode)offsetNode2, 100);
        querySQLs.add(sql);
        sqlToPlanMap.put(sql, (PlanNode)limitNode2);
        sql = "SELECT * FROM root.sg.* WHERE time > 100 and s1 > 10 ORDER BY TIME DESC LIMIT 100 OFFSET 100 ALIGN BY DEVICE";
        queryId = new QueryId("test");
        ArrayList<SeriesScanNode> sourceNodeList1 = new ArrayList<SeriesScanNode>();
        sourceNodeList1.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s3"), Ordering.DESC));
        sourceNodeList1.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s1"), Ordering.DESC));
        sourceNodeList1.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s2"), Ordering.DESC));
        sourceNodeList1.forEach(planNode -> ((SeriesScanNode)planNode).setTimeFilter((Filter)TimeFilter.gt((long)100L)));
        TimeJoinNode timeJoinNode1 = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.DESC, sourceNodeList1);
        GreaterThanExpression predicate1 = new GreaterThanExpression((Expression)new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1")), (Expression)new ConstantOperand(TSDataType.INT64, "10"));
        FilterNode filterNode1 = new FilterNode(queryId.genPlanNodeId(), (PlanNode)timeJoinNode1, new Expression[]{new TimeSeriesOperand(schemaMap.get("root.sg.d1.s3")), new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2"))}, (Expression)predicate1, false, (ZoneId)ZonedDateTime.now().getOffset(), Ordering.DESC);
        ArrayList<SeriesScanNode> sourceNodeList2 = new ArrayList<SeriesScanNode>();
        sourceNodeList2.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1"), Ordering.DESC));
        sourceNodeList2.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s2"), Ordering.DESC));
        sourceNodeList2.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s4"), Ordering.DESC));
        sourceNodeList2.forEach(planNode -> ((SeriesScanNode)planNode).setTimeFilter((Filter)TimeFilter.gt((long)100L)));
        TimeJoinNode timeJoinNode2 = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.DESC, sourceNodeList2);
        GreaterThanExpression predicate2 = new GreaterThanExpression((Expression)new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")), (Expression)new ConstantOperand(TSDataType.INT32, "10"));
        FilterNode filterNode2 = new FilterNode(queryId.genPlanNodeId(), (PlanNode)timeJoinNode2, new Expression[]{new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2")), new TimeSeriesOperand(schemaMap.get("root.sg.d2.s4"))}, (Expression)predicate2, false, (ZoneId)ZonedDateTime.now().getOffset(), Ordering.DESC);
        HashMap<String, List<Integer>> deviceToMeasurementIndexesMap = new HashMap<String, List<Integer>>();
        deviceToMeasurementIndexesMap.put("root.sg.d1", Arrays.asList(1, 2, 3));
        deviceToMeasurementIndexesMap.put("root.sg.d2", Arrays.asList(2, 3, 4));
        DeviceViewNode deviceViewNode = new DeviceViewNode(queryId.genPlanNodeId(), new OrderByParameter(Arrays.asList(new SortItem(SortKey.DEVICE, Ordering.ASC), new SortItem(SortKey.TIME, Ordering.DESC))), Arrays.asList("Device", "s3", "s1", "s2", "s4"), deviceToMeasurementIndexesMap);
        deviceViewNode.addChildDeviceNode("root.sg.d1", (PlanNode)filterNode1);
        deviceViewNode.addChildDeviceNode("root.sg.d2", (PlanNode)filterNode2);
        OffsetNode offsetNode3 = new OffsetNode(queryId.genPlanNodeId(), (PlanNode)deviceViewNode, 100);
        LimitNode limitNode3 = new LimitNode(queryId.genPlanNodeId(), (PlanNode)offsetNode3, 100);
        querySQLs.add(sql);
        sqlToPlanMap.put(sql, (PlanNode)limitNode3);
        sql = "SELECT last_value(s1), first_value(s1), sum(s2) FROM root.sg.** WHERE time > 100 LIMIT 10 OFFSET 10";
        queryId = new QueryId("test");
        sourceNodeList = new ArrayList();
        TimeFilter.TimeGt timeFilter = TimeFilter.gt((long)100L);
        try {
            sourceNodeList.add(new AlignedSeriesAggregationScanNode(queryId.genPlanNodeId(), new AlignedPath("root.sg.d2.a", Arrays.asList("s2", "s1"), ((AlignedPath)schemaMap.get("root.sg.d2.a")).getSchemaList()), Arrays.asList(new AggregationDescriptor(AggregationType.SUM.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.a.s2")))), new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.a.s1"))))), Ordering.ASC, null));
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
        }
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s2"), Collections.singletonList(new AggregationDescriptor(AggregationType.SUM.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2"))))), Ordering.ASC, null));
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s2"), Collections.singletonList(new AggregationDescriptor(AggregationType.SUM.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2"))))), Ordering.ASC, null));
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s1"), Collections.singletonList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))))), Ordering.ASC, null));
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1"), Collections.singletonList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1"))))), Ordering.ASC, null));
        sourceNodeList.add(new AlignedSeriesAggregationScanNode(queryId.genPlanNodeId(), new AlignedPath((MeasurementPath)schemaMap.get("root.sg.d2.a.s1")), Collections.singletonList(new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.a.s1"))))), Ordering.DESC, null));
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1"), Collections.singletonList(new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1"))))), Ordering.DESC, null));
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s1"), Collections.singletonList(new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))))), Ordering.DESC, null));
        sourceNodeList.forEach(arg_0 -> QueryLogicalPlanUtil.lambda$static$3((Filter)timeFilter, arg_0));
        TimeJoinNode timeJoinNode3 = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.ASC, sourceNodeList);
        OffsetNode offsetNode4 = new OffsetNode(queryId.genPlanNodeId(), (PlanNode)timeJoinNode3, 10);
        LimitNode limitNode4 = new LimitNode(queryId.genPlanNodeId(), (PlanNode)offsetNode4, 10);
        querySQLs.add(sql);
        sqlToPlanMap.put(sql, (PlanNode)limitNode4);
        sql = "SELECT count(s1), max_value(s2), last_value(s1) FROM root.sg.** WHERE time > 100 GROUP BY LEVEL = 1 ORDER BY TIME DESC LIMIT 100 OFFSET 100";
        queryId = new QueryId("test");
        sourceNodeList = new ArrayList();
        timeFilter = TimeFilter.gt((long)100L);
        try {
            sourceNodeList.add(new AlignedSeriesAggregationScanNode(queryId.genPlanNodeId(), new AlignedPath("root.sg.d2.a", Arrays.asList("s2", "s1"), ((AlignedPath)schemaMap.get("root.sg.d2.a")).getSchemaList()), Arrays.asList(new AggregationDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.a.s2")))), new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.a.s1")))), new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.a.s1"))))), Ordering.DESC, null));
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
        }
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s2"), Collections.singletonList(new AggregationDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2"))))), Ordering.DESC, null));
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s2"), Collections.singletonList(new AggregationDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2"))))), Ordering.DESC, null));
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1"), Arrays.asList(new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")))), new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1"))))), Ordering.DESC, null));
        sourceNodeList.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s1"), Arrays.asList(new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1")))), new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))))), Ordering.DESC, null));
        sourceNodeList.forEach(arg_0 -> QueryLogicalPlanUtil.lambda$static$4((Filter)timeFilter, arg_0));
        GroupByLevelNode groupByLevelNode = new GroupByLevelNode(queryId.genPlanNodeId(), sourceNodeList, Arrays.asList(new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))), (Expression)new TimeSeriesOperand(schemaMap.get("root.sg.*.s1"))), new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.a.s1"))), (Expression)new TimeSeriesOperand(schemaMap.get("root.sg.*.*.s1"))), new GroupByLevelDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2")), new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2"))), (Expression)new TimeSeriesOperand(schemaMap.get("root.sg.*.s2"))), new GroupByLevelDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.a.s2"))), (Expression)new TimeSeriesOperand(schemaMap.get("root.sg.*.*.s2"))), new GroupByLevelDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))), (Expression)new TimeSeriesOperand(schemaMap.get("root.sg.*.s1"))), new GroupByLevelDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.a.s1"))), (Expression)new TimeSeriesOperand(schemaMap.get("root.sg.*.*.s1")))), null, Ordering.DESC);
        offsetNode4 = new OffsetNode(queryId.genPlanNodeId(), (PlanNode)groupByLevelNode, 100);
        limitNode4 = new LimitNode(queryId.genPlanNodeId(), (PlanNode)offsetNode4, 100);
        querySQLs.add(sql);
        sqlToPlanMap.put(sql, (PlanNode)limitNode4);
        sql = "SELECT count(s1), max_value(s2), last_value(s1) FROM root.sg.* WHERE time > 100 ORDER BY TIME DESC LIMIT 100 OFFSET 100 ALIGN BY DEVICE";
        queryId = new QueryId("test");
        TimeFilter.TimeGt timeFilter2 = TimeFilter.gt((long)100L);
        ArrayList<SeriesAggregationScanNode> sourceNodeList12 = new ArrayList<SeriesAggregationScanNode>();
        sourceNodeList12.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s2"), Collections.singletonList(new AggregationDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2"))))), Ordering.DESC, null));
        sourceNodeList12.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s1"), Arrays.asList(new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1")))), new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))))), Ordering.DESC, null));
        sourceNodeList12.forEach(arg_0 -> QueryLogicalPlanUtil.lambda$static$5((Filter)timeFilter2, arg_0));
        TimeJoinNode timeJoinNode12 = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.DESC, sourceNodeList12);
        ArrayList<SeriesAggregationScanNode> sourceNodeList22 = new ArrayList<SeriesAggregationScanNode>();
        sourceNodeList22.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s2"), Collections.singletonList(new AggregationDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2"))))), Ordering.DESC, null));
        sourceNodeList22.add(new SeriesAggregationScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1"), Arrays.asList(new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")))), new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1"))))), Ordering.DESC, null));
        sourceNodeList22.forEach(arg_0 -> QueryLogicalPlanUtil.lambda$static$6((Filter)timeFilter2, arg_0));
        TimeJoinNode timeJoinNode22 = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.DESC, sourceNodeList22);
        HashMap<String, List<Integer>> deviceToMeasurementIndexesMap2 = new HashMap<String, List<Integer>>();
        deviceToMeasurementIndexesMap2.put("root.sg.d1", Arrays.asList(2, 1, 3));
        deviceToMeasurementIndexesMap2.put("root.sg.d2", Arrays.asList(2, 1, 3));
        DeviceViewNode deviceViewNode2 = new DeviceViewNode(queryId.genPlanNodeId(), new OrderByParameter(Arrays.asList(new SortItem(SortKey.DEVICE, Ordering.ASC), new SortItem(SortKey.TIME, Ordering.DESC))), Arrays.asList("Device", "count(s1)", "max_value(s2)", "last_value(s1)"), deviceToMeasurementIndexesMap2);
        deviceViewNode2.addChildDeviceNode("root.sg.d1", (PlanNode)timeJoinNode12);
        deviceViewNode2.addChildDeviceNode("root.sg.d2", (PlanNode)timeJoinNode22);
        OffsetNode offsetNode5 = new OffsetNode(queryId.genPlanNodeId(), (PlanNode)deviceViewNode2, 100);
        LimitNode limitNode5 = new LimitNode(queryId.genPlanNodeId(), (PlanNode)offsetNode5, 100);
        querySQLs.add(sql);
        sqlToPlanMap.put(sql, (PlanNode)limitNode5);
        sql = "SELECT count(s1), max_value(s2), last_value(s1) FROM root.sg.* WHERE time > 100 and s2 > 10 GROUP BY LEVEL = 1 ORDER BY TIME DESC LIMIT 100 OFFSET 100";
        queryId = new QueryId("test");
        sourceNodeList = new ArrayList();
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1"), Ordering.DESC));
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s1"), Ordering.DESC));
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s2"), Ordering.DESC));
        sourceNodeList.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s2"), Ordering.DESC));
        sourceNodeList.forEach(planNode -> ((SeriesScanNode)planNode).setTimeFilter((Filter)TimeFilter.gt((long)100L)));
        timeJoinNode = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.DESC, sourceNodeList);
        valueFilter1 = new GreaterThanExpression((Expression)new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT32, "10"));
        valueFilter2 = new GreaterThanExpression((Expression)new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2")), (Expression)new ConstantOperand(TSDataType.INT32, "10"));
        predicate = new LogicAndExpression((Expression)valueFilter1, (Expression)valueFilter2);
        filterNode = new FilterNode(queryId.genPlanNodeId(), (PlanNode)timeJoinNode, new Expression[]{new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2")), new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2"))}, (Expression)predicate, false, (ZoneId)ZonedDateTime.now().getOffset(), Ordering.DESC);
        AggregationNode aggregationNode = new AggregationNode(queryId.genPlanNodeId(), Collections.singletonList(filterNode), Arrays.asList(new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")))), new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1")))), new AggregationDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2")))), new AggregationDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2")))), new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")))), new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))))), null, Ordering.DESC);
        GroupByLevelNode groupByLevelNode2 = new GroupByLevelNode(queryId.genPlanNodeId(), Collections.singletonList(aggregationNode), Arrays.asList(new GroupByLevelDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))), (Expression)new TimeSeriesOperand(schemaMap.get("root.sg.*.s1"))), new GroupByLevelDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2")), new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2"))), (Expression)new TimeSeriesOperand(schemaMap.get("root.sg.*.s2"))), new GroupByLevelDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.FINAL, Arrays.asList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))), (Expression)new TimeSeriesOperand(schemaMap.get("root.sg.*.s1")))), null, Ordering.DESC);
        OffsetNode offsetNode6 = new OffsetNode(queryId.genPlanNodeId(), (PlanNode)groupByLevelNode2, 100);
        LimitNode limitNode6 = new LimitNode(queryId.genPlanNodeId(), (PlanNode)offsetNode6, 100);
        querySQLs.add(sql);
        sqlToPlanMap.put(sql, (PlanNode)limitNode6);
        sql = "SELECT count(s1), max_value(s2), last_value(s1) FROM root.sg.* WHERE time > 100 and s2 > 10 ORDER BY TIME DESC LIMIT 100 OFFSET 100 ALIGN BY DEVICE";
        queryId = new QueryId("test");
        sourceNodeList1 = new ArrayList();
        sourceNodeList1.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s1"), Ordering.DESC));
        sourceNodeList1.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d1.s2"), Ordering.DESC));
        sourceNodeList1.forEach(planNode -> ((SeriesScanNode)planNode).setTimeFilter((Filter)TimeFilter.gt((long)100L)));
        timeJoinNode1 = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.DESC, sourceNodeList1);
        predicate1 = new GreaterThanExpression((Expression)new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2")), (Expression)new ConstantOperand(TSDataType.INT64, "10"));
        filterNode1 = new FilterNode(queryId.genPlanNodeId(), (PlanNode)timeJoinNode1, new Expression[]{new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2"))}, (Expression)predicate1, false, (ZoneId)ZonedDateTime.now().getOffset(), Ordering.DESC);
        AggregationNode aggregationNode1 = new AggregationNode(queryId.genPlanNodeId(), Collections.singletonList(filterNode1), Arrays.asList(new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1")))), new AggregationDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s2")))), new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d1.s1"))))), null, Ordering.DESC);
        ArrayList<SeriesScanNode> sourceNodeList23 = new ArrayList<SeriesScanNode>();
        sourceNodeList23.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s1"), Ordering.DESC));
        sourceNodeList23.add(new SeriesScanNode(queryId.genPlanNodeId(), (MeasurementPath)schemaMap.get("root.sg.d2.s2"), Ordering.DESC));
        sourceNodeList23.forEach(planNode -> ((SeriesScanNode)planNode).setTimeFilter((Filter)TimeFilter.gt((long)100L)));
        TimeJoinNode timeJoinNode23 = new TimeJoinNode(queryId.genPlanNodeId(), Ordering.DESC, sourceNodeList23);
        GreaterThanExpression predicate22 = new GreaterThanExpression((Expression)new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2")), (Expression)new ConstantOperand(TSDataType.INT32, "10"));
        FilterNode filterNode22 = new FilterNode(queryId.genPlanNodeId(), (PlanNode)timeJoinNode23, new Expression[]{new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")), new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2"))}, (Expression)predicate22, false, (ZoneId)ZonedDateTime.now().getOffset(), Ordering.DESC);
        AggregationNode aggregationNode2 = new AggregationNode(queryId.genPlanNodeId(), Collections.singletonList(filterNode22), Arrays.asList(new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1")))), new AggregationDescriptor(AggregationType.MAX_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s2")))), new AggregationDescriptor(AggregationType.LAST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand(schemaMap.get("root.sg.d2.s1"))))), null, Ordering.DESC);
        HashMap<String, List<Integer>> deviceToMeasurementIndexesMap3 = new HashMap<String, List<Integer>>();
        deviceToMeasurementIndexesMap3.put("root.sg.d1", Arrays.asList(1, 2, 3));
        deviceToMeasurementIndexesMap3.put("root.sg.d2", Arrays.asList(1, 2, 3));
        DeviceViewNode deviceViewNode3 = new DeviceViewNode(queryId.genPlanNodeId(), new OrderByParameter(Arrays.asList(new SortItem(SortKey.DEVICE, Ordering.ASC), new SortItem(SortKey.TIME, Ordering.DESC))), Arrays.asList("Device", "count(s1)", "max_value(s2)", "last_value(s1)"), deviceToMeasurementIndexesMap3);
        deviceViewNode3.addChildDeviceNode("root.sg.d1", (PlanNode)aggregationNode1);
        deviceViewNode3.addChildDeviceNode("root.sg.d2", (PlanNode)aggregationNode2);
        OffsetNode offsetNode7 = new OffsetNode(queryId.genPlanNodeId(), (PlanNode)deviceViewNode3, 100);
        LimitNode limitNode7 = new LimitNode(queryId.genPlanNodeId(), (PlanNode)offsetNode7, 100);
        querySQLs.add(sql);
        sqlToPlanMap.put(sql, (PlanNode)limitNode7);
    }
}

