/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.plan;

import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.Analyzer;
import org.apache.iotdb.db.mpp.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.plan.QueryLogicalPlanUtil;
import org.apache.iotdb.db.mpp.plan.plan.node.PlanNodeDeserializeHelper;
import org.apache.iotdb.db.mpp.plan.planner.LogicalPlanner;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.DevicesSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodeManagementMemoryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsConvertNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsCountNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.NodePathsSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryOrderByHeatNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.TimeSeriesSchemaScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class LogicalPlannerTest {
    @Test
    public void testQueryPlan() {
        for (String sql : QueryLogicalPlanUtil.querySQLs) {
            Assert.assertEquals((Object)QueryLogicalPlanUtil.sqlToPlanMap.get(sql), (Object)this.parseSQLToPlanNode(sql));
            System.out.printf("\"%s\" TEST PASSED\n", sql);
        }
    }

    @Test
    public void testCreateTimeseriesPlan() {
        String sql = "CREATE TIMESERIES root.ln.wf01.wt01.status(\u72b6\u6001) BOOLEAN ENCODING=PLAIN COMPRESSOR=SNAPPY TAGS('tag1'='v1', 'tag2'='v2') ATTRIBUTES('attr1'='v1', 'attr2'='v2')";
        try {
            CreateTimeSeriesNode createTimeSeriesNode = (CreateTimeSeriesNode)this.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)createTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01.status"), (Object)createTimeSeriesNode.getPath());
            Assert.assertEquals((Object)"\u72b6\u6001", (Object)createTimeSeriesNode.getAlias());
            Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)createTimeSeriesNode.getDataType());
            Assert.assertEquals((Object)TSEncoding.PLAIN, (Object)createTimeSeriesNode.getEncoding());
            Assert.assertEquals((Object)CompressionType.SNAPPY, (Object)createTimeSeriesNode.getCompressor());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag1", "v1");
                    this.put("tag2", "v2");
                }
            }, (Object)createTimeSeriesNode.getTags());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("attr1", "v1");
                    this.put("attr2", "v2");
                }
            }, (Object)createTimeSeriesNode.getAttributes());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCreateAlignedTimeseriesPlan() {
        String sql = "CREATE ALIGNED TIMESERIES root.ln.wf01.GPS(latitude(meter1) FLOAT encoding=PLAIN compressor=SNAPPY tags('tag1'='t1') attributes('attr1'='a1'), longitude FLOAT encoding=PLAIN compressor=SNAPPY)";
        try {
            CreateAlignedTimeSeriesNode createAlignedTimeSeriesNode = (CreateAlignedTimeSeriesNode)this.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)createAlignedTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.GPS"), (Object)createAlignedTimeSeriesNode.getDevicePath());
            Assert.assertEquals((Object)new ArrayList<String>(){
                {
                    this.add("meter1");
                    this.add(null);
                }
            }, (Object)createAlignedTimeSeriesNode.getAliasList());
            Assert.assertEquals((Object)new ArrayList<TSDataType>(){
                {
                    this.add(TSDataType.FLOAT);
                    this.add(TSDataType.FLOAT);
                }
            }, (Object)createAlignedTimeSeriesNode.getDataTypes());
            Assert.assertEquals((Object)new ArrayList<TSEncoding>(){
                {
                    this.add(TSEncoding.PLAIN);
                    this.add(TSEncoding.PLAIN);
                }
            }, (Object)createAlignedTimeSeriesNode.getEncodings());
            Assert.assertEquals((Object)new ArrayList<CompressionType>(){
                {
                    this.add(CompressionType.SNAPPY);
                    this.add(CompressionType.SNAPPY);
                }
            }, (Object)createAlignedTimeSeriesNode.getCompressors());
            Assert.assertEquals((Object)new ArrayList<Map<String, String>>(){
                {
                    this.add(new HashMap<String, String>(){
                        {
                            this.put("attr1", "a1");
                        }
                    });
                    this.add(null);
                }
            }, (Object)createAlignedTimeSeriesNode.getAttributesList());
            Assert.assertEquals((Object)new ArrayList<Map<String, String>>(){
                {
                    this.add(new HashMap<String, String>(){
                        {
                            this.put("tag1", "t1");
                        }
                    });
                    this.add(null);
                }
            }, (Object)createAlignedTimeSeriesNode.getTagsList());
            ByteBuffer byteBuffer = ByteBuffer.allocate(1000);
            createAlignedTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            CreateAlignedTimeSeriesNode createAlignedTimeSeriesNode1 = (CreateAlignedTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertTrue((boolean)createAlignedTimeSeriesNode.equals((Object)createAlignedTimeSeriesNode1));
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCreateMultiTimeSeriesPlan() {
        try {
            TSCreateMultiTimeseriesReq req = new TSCreateMultiTimeseriesReq();
            req.setPaths((List)new ArrayList<String>(){
                {
                    this.add("root.sg1.d2.s1");
                    this.add("root.sg1.d2.s2");
                }
            });
            req.setMeasurementAliasList((List)new ArrayList<String>(){
                {
                    this.add("meter1");
                    this.add(null);
                }
            });
            req.setDataTypes((List)new ArrayList<Integer>(){
                {
                    this.add(TSDataType.FLOAT.ordinal());
                    this.add(TSDataType.FLOAT.ordinal());
                }
            });
            req.setEncodings((List)new ArrayList<Integer>(){
                {
                    this.add(TSEncoding.PLAIN.ordinal());
                    this.add(TSEncoding.PLAIN.ordinal());
                }
            });
            req.setCompressors((List)new ArrayList<Integer>(){
                {
                    this.add(CompressionType.SNAPPY.ordinal());
                    this.add(CompressionType.SNAPPY.ordinal());
                }
            });
            req.setAttributesList((List)new ArrayList<Map<String, String>>(){
                {
                    this.add(new HashMap<String, String>(){
                        {
                            this.put("attr1", "a1");
                        }
                    });
                    this.add(null);
                }
            });
            req.setTagsList((List)new ArrayList<Map<String, String>>(){
                {
                    this.add(new HashMap<String, String>(){
                        {
                            this.put("tag1", "t1");
                        }
                    });
                    this.add(null);
                }
            });
            CreateMultiTimeSeriesStatement createMultiTimeSeriesStatement = (CreateMultiTimeSeriesStatement)StatementGenerator.createStatement((TSCreateMultiTimeseriesReq)req);
            MPPQueryContext context = new MPPQueryContext(new QueryId("test_query"));
            Analyzer analyzer = new Analyzer(context, (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
            Analysis analysis = analyzer.analyze((Statement)createMultiTimeSeriesStatement);
            LogicalPlanner planner = new LogicalPlanner(context, new ArrayList());
            CreateMultiTimeSeriesNode createMultiTimeSeriesNode = (CreateMultiTimeSeriesNode)planner.plan(analysis).getRootNode();
            ByteBuffer byteBuffer = ByteBuffer.allocate(1000);
            createMultiTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            CreateMultiTimeSeriesNode createMultiTimeSeriesNode1 = (CreateMultiTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertEquals((Object)createMultiTimeSeriesNode, (Object)createMultiTimeSeriesNode1);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testAlterTimeseriesPlan() {
        AlterTimeSeriesNode alterTimeSeriesNode1;
        ByteBuffer byteBuffer;
        AlterTimeSeriesNode alterTimeSeriesNode;
        String sql = "ALTER timeseries root.turbine.d1.s1 RENAME 'tag1' TO 'newTag1'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)this.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.RENAME, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag1", "newTag1");
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertTrue((boolean)alterTimeSeriesNode.equals((Object)alterTimeSeriesNode1));
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 SET 'newTag1'='newV1', 'attr1'='newV1'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)this.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.SET, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("newTag1", "newV1");
                    this.put("attr1", "newV1");
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertTrue((boolean)alterTimeSeriesNode.equals((Object)alterTimeSeriesNode1));
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 DROP 'tag1', 'tag2'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)this.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.DROP, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag1", null);
                    this.put("tag2", null);
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertTrue((boolean)alterTimeSeriesNode.equals((Object)alterTimeSeriesNode1));
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 ADD TAGS 'tag3'='v3', 'tag4'='v4'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)this.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.ADD_TAGS, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag3", "v3");
                    this.put("tag4", "v4");
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertTrue((boolean)alterTimeSeriesNode.equals((Object)alterTimeSeriesNode1));
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 ADD ATTRIBUTES 'attr3'='v3', 'attr4'='v4'";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)this.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.ADD_ATTRIBUTES, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("attr3", "v3");
                    this.put("attr4", "v4");
                }
            }, (Object)alterTimeSeriesNode.getAlterMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertTrue((boolean)alterTimeSeriesNode.equals((Object)alterTimeSeriesNode1));
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        sql = "ALTER timeseries root.turbine.d1.s1 UPSERT ALIAS='newAlias' TAGS('tag2'='newV2', 'tag3'='v3') ATTRIBUTES('attr3'='v3', 'attr4'='v4')";
        try {
            alterTimeSeriesNode = (AlterTimeSeriesNode)this.parseSQLToPlanNode(sql);
            Assert.assertNotNull((Object)alterTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.turbine.d1.s1"), (Object)alterTimeSeriesNode.getPath());
            Assert.assertEquals((Object)AlterTimeSeriesStatement.AlterType.UPSERT, (Object)alterTimeSeriesNode.getAlterType());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("tag2", "newV2");
                    this.put("tag3", "v3");
                }
            }, (Object)alterTimeSeriesNode.getTagsMap());
            Assert.assertEquals((Object)new HashMap<String, String>(){
                {
                    this.put("attr3", "v3");
                    this.put("attr4", "v4");
                }
            }, (Object)alterTimeSeriesNode.getAttributesMap());
            byteBuffer = ByteBuffer.allocate(1000);
            alterTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            alterTimeSeriesNode1 = (AlterTimeSeriesNode)PlanNodeDeserializeHelper.deserialize(byteBuffer);
            Assert.assertTrue((boolean)alterTimeSeriesNode.equals((Object)alterTimeSeriesNode1));
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowTimeSeries() {
        String sql = "SHOW LATEST TIMESERIES root.ln.wf01.wt01.status WHERE 'tagK' = 'tagV' limit 20 offset 10";
        try {
            LimitNode limitNode = (LimitNode)this.parseSQLToPlanNode(sql);
            OffsetNode offsetNode = (OffsetNode)limitNode.getChild();
            SchemaQueryOrderByHeatNode schemaQueryOrderByHeatNode = (SchemaQueryOrderByHeatNode)offsetNode.getChild();
            SchemaQueryMergeNode metaMergeNode = (SchemaQueryMergeNode)schemaQueryOrderByHeatNode.getChildren().get(0);
            metaMergeNode.getChildren().forEach(n -> System.out.println(n.toString()));
            TimeSeriesSchemaScanNode showTimeSeriesNode = (TimeSeriesSchemaScanNode)metaMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)showTimeSeriesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01.status"), (Object)showTimeSeriesNode.getPath());
            Assert.assertEquals((Object)"root.ln.wf01.wt01", (Object)showTimeSeriesNode.getPath().getDevice());
            Assert.assertTrue((boolean)showTimeSeriesNode.isOrderByHeat());
            Assert.assertFalse((boolean)showTimeSeriesNode.isContains());
            Assert.assertEquals((Object)"tagK", (Object)showTimeSeriesNode.getKey());
            Assert.assertEquals((Object)"tagV", (Object)showTimeSeriesNode.getValue());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode.getLimit());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode.getOffset());
            Assert.assertFalse((boolean)showTimeSeriesNode.isHasLimit());
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            showTimeSeriesNode.serialize(byteBuffer);
            byteBuffer.flip();
            TimeSeriesSchemaScanNode showTimeSeriesNode2 = (TimeSeriesSchemaScanNode)PlanNodeType.deserialize((ByteBuffer)byteBuffer);
            Assert.assertNotNull((Object)showTimeSeriesNode2);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01.status"), (Object)showTimeSeriesNode2.getPath());
            Assert.assertEquals((Object)"root.ln.wf01.wt01", (Object)showTimeSeriesNode2.getPath().getDevice());
            Assert.assertTrue((boolean)showTimeSeriesNode2.isOrderByHeat());
            Assert.assertFalse((boolean)showTimeSeriesNode2.isContains());
            Assert.assertEquals((Object)"tagK", (Object)showTimeSeriesNode2.getKey());
            Assert.assertEquals((Object)"tagV", (Object)showTimeSeriesNode2.getValue());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode2.getLimit());
            Assert.assertEquals((long)0L, (long)showTimeSeriesNode2.getOffset());
            Assert.assertFalse((boolean)showTimeSeriesNode2.isHasLimit());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowDevices() {
        String sql = "SHOW DEVICES root.ln.wf01.wt01 WITH STORAGE GROUP limit 20 offset 10";
        try {
            LimitNode limitNode = (LimitNode)this.parseSQLToPlanNode(sql);
            OffsetNode offsetNode = (OffsetNode)limitNode.getChild();
            SchemaQueryMergeNode metaMergeNode = (SchemaQueryMergeNode)offsetNode.getChild();
            DevicesSchemaScanNode showDevicesNode = (DevicesSchemaScanNode)metaMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)showDevicesNode);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01"), (Object)showDevicesNode.getPath());
            Assert.assertTrue((boolean)showDevicesNode.isHasSgCol());
            Assert.assertEquals((long)30L, (long)showDevicesNode.getLimit());
            Assert.assertEquals((long)0L, (long)showDevicesNode.getOffset());
            Assert.assertTrue((boolean)showDevicesNode.isHasLimit());
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            showDevicesNode.serialize(byteBuffer);
            byteBuffer.flip();
            DevicesSchemaScanNode showDevicesNode2 = (DevicesSchemaScanNode)PlanNodeType.deserialize((ByteBuffer)byteBuffer);
            Assert.assertNotNull((Object)showDevicesNode2);
            Assert.assertEquals((Object)new PartialPath("root.ln.wf01.wt01"), (Object)showDevicesNode2.getPath());
            Assert.assertEquals((long)30L, (long)showDevicesNode2.getLimit());
            Assert.assertEquals((long)0L, (long)showDevicesNode2.getOffset());
            Assert.assertTrue((boolean)showDevicesNode2.isHasLimit());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCountNodes() {
        String sql = "COUNT NODES root.ln LEVEL=1";
        try {
            NodePathsCountNode nodePathsCountNode = (NodePathsCountNode)this.parseSQLToPlanNode(sql);
            NodeManagementMemoryMergeNode nodeManagementMemoryMergeNode = (NodeManagementMemoryMergeNode)nodePathsCountNode.getChildren().get(0);
            SchemaQueryMergeNode schemaQueryMergeNode = (SchemaQueryMergeNode)nodeManagementMemoryMergeNode.getChildren().get(0);
            NodePathsSchemaScanNode nodePathsSchemaScanNode = (NodePathsSchemaScanNode)schemaQueryMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)nodePathsSchemaScanNode);
            Assert.assertEquals((Object)new PartialPath("root.ln"), (Object)nodePathsSchemaScanNode.getPrefixPath());
            Assert.assertEquals((long)1L, (long)nodePathsSchemaScanNode.getLevel());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowChildPaths() {
        String sql = "SHOW CHILD PATHS root.ln";
        try {
            NodeManagementMemoryMergeNode memorySourceNode = (NodeManagementMemoryMergeNode)this.parseSQLToPlanNode(sql);
            SchemaQueryMergeNode schemaQueryMergeNode = (SchemaQueryMergeNode)memorySourceNode.getChildren().get(0);
            NodePathsSchemaScanNode nodePathsSchemaScanNode = (NodePathsSchemaScanNode)schemaQueryMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)nodePathsSchemaScanNode);
            Assert.assertEquals((Object)new PartialPath("root.ln"), (Object)nodePathsSchemaScanNode.getPrefixPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testShowChildNodes() {
        String sql = "SHOW CHILD NODES root.ln";
        try {
            NodePathsConvertNode nodePathsConvertNode = (NodePathsConvertNode)this.parseSQLToPlanNode(sql);
            NodeManagementMemoryMergeNode memorySourceNode = (NodeManagementMemoryMergeNode)nodePathsConvertNode.getChildren().get(0);
            SchemaQueryMergeNode schemaQueryMergeNode = (SchemaQueryMergeNode)memorySourceNode.getChildren().get(0);
            NodePathsSchemaScanNode nodePathsSchemaScanNode = (NodePathsSchemaScanNode)schemaQueryMergeNode.getChildren().get(0);
            Assert.assertNotNull((Object)nodePathsConvertNode);
            Assert.assertEquals((Object)new PartialPath("root.ln"), (Object)nodePathsSchemaScanNode.getPrefixPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private PlanNode parseSQLToPlanNode(String sql) {
        PlanNode planNode = null;
        try {
            Statement statement = StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
            MPPQueryContext context = new MPPQueryContext(new QueryId("test_query"));
            Analyzer analyzer = new Analyzer(context, (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
            Analysis analysis = analyzer.analyze(statement);
            LogicalPlanner planner = new LogicalPlanner(context, new ArrayList());
            planNode = planner.plan(analysis).getRootNode();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return planNode;
    }
}

