/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.plan.analyze.cache.PartitionCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionCacheTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final SeriesPartitionExecutor partitionExecutor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)config.getSeriesPartitionExecutorClass(), (int)config.getSeriesPartitionSlotNum());
    private static final Set<String> storageGroups = new HashSet<String>();
    private static final Map<String, Map<TSeriesPartitionSlot, TConsensusGroupId>> schemaPartitionTable = new HashMap<String, Map<TSeriesPartitionSlot, TConsensusGroupId>>();
    private static final Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>>> dataPartitionTable = new HashMap<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>>>();
    private static final Map<TConsensusGroupId, TRegionReplicaSet> consensusGroupIdToRegionReplicaSet = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
    private static final String STORAGE_GROUP_PREFIX = "root.sg";
    private static final Integer STORAGE_GROUP_NUMBER = 5;
    private static final String DEVICE_PREFIX = "d";
    private static final Integer DEVICE_PER_STORAGE_GROUP = 10;
    private static final Integer TIME_PARTITION_PER_STORAGE_GROUP = 10;
    private PartitionCache partitionCache;

    private static String getStorageGroupName(int storageGroupNumber) {
        return STORAGE_GROUP_PREFIX + storageGroupNumber;
    }

    private static String getDeviceName(String storageGroupName, int deviceNumber) {
        return storageGroupName + "." + DEVICE_PREFIX + deviceNumber;
    }

    @Before
    public void setUp() throws Exception {
        this.partitionCache = new PartitionCache();
        this.partitionCache.updateStorageCache(storageGroups);
        this.partitionCache.updateSchemaPartitionCache(schemaPartitionTable);
        this.partitionCache.updateDataPartitionCache(dataPartitionTable);
        this.partitionCache.updateGroupIdToReplicaSetMap(100L, consensusGroupIdToRegionReplicaSet);
    }

    @After
    public void tearDown() throws Exception {
        this.partitionCache.invalidAllCache();
    }

    @Test
    public void testStorageGroupCache() {
        Map deviceToStorageGroupMap;
        Map storageGroupToDeviceMap;
        List<List> existedDevicesInOneStorageGroup = Arrays.asList(Arrays.asList("root.sg1.d1", "root.sg1.d2"), Arrays.asList("root.sg2.d1", "root.sg2.d2"));
        for (List list : existedDevicesInOneStorageGroup) {
            storageGroupToDeviceMap = this.partitionCache.getStorageGroupToDevice(list, false, false);
            Assert.assertEquals((long)1L, (long)storageGroupToDeviceMap.size());
            for (Object devices : storageGroupToDeviceMap.values()) {
                Assert.assertEquals((long)2L, (long)devices.size());
            }
            deviceToStorageGroupMap = this.partitionCache.getDeviceToStorageGroup(list, false, false);
            Assert.assertEquals((long)2L, (long)deviceToStorageGroupMap.size());
        }
        List<List> existedDevicesInMultiStorageGroup = Arrays.asList(Arrays.asList("root.sg1.d1", "root.sg2.d2"), Arrays.asList("root.sg1.d1", "root.sg2.d2"));
        for (List list : existedDevicesInMultiStorageGroup) {
            storageGroupToDeviceMap = this.partitionCache.getStorageGroupToDevice(list, false, false);
            Assert.assertEquals((long)2L, (long)storageGroupToDeviceMap.size());
            for (List devices : storageGroupToDeviceMap.values()) {
                Assert.assertEquals((long)1L, (long)devices.size());
            }
            deviceToStorageGroupMap = this.partitionCache.getDeviceToStorageGroup(list, false, false);
            Assert.assertEquals((long)2L, (long)deviceToStorageGroupMap.size());
        }
        List<List> list = Arrays.asList(Arrays.asList("root.sg5.d1", "root.sg5.d2"), Arrays.asList("root.sg.d1", "root.sg.d2"), Arrays.asList("root.sg3.**", "root.sg4.**"));
        for (List searchDevices : list) {
            storageGroupToDeviceMap = this.partitionCache.getStorageGroupToDevice(searchDevices, false, false);
            Assert.assertEquals((long)0L, (long)storageGroupToDeviceMap.size());
            deviceToStorageGroupMap = this.partitionCache.getDeviceToStorageGroup(searchDevices, false, false);
            Assert.assertEquals((long)0L, (long)deviceToStorageGroupMap.size());
        }
        this.partitionCache.invalidAllCache();
        List<String> list2 = Collections.singletonList("root.sg1.d1");
        storageGroupToDeviceMap = this.partitionCache.getStorageGroupToDevice(list2, false, false);
        Assert.assertEquals((long)0L, (long)storageGroupToDeviceMap.size());
        deviceToStorageGroupMap = this.partitionCache.getDeviceToStorageGroup(list2, false, false);
        Assert.assertEquals((long)0L, (long)deviceToStorageGroupMap.size());
    }

    @Test
    public void testRegionReplicaSetCache() {
        Assert.assertFalse((boolean)this.partitionCache.updateGroupIdToReplicaSetMap(0L, consensusGroupIdToRegionReplicaSet));
        for (int storageGroupNumber = 0; storageGroupNumber < STORAGE_GROUP_NUMBER; ++storageGroupNumber) {
            for (int deviceNumber = 0; deviceNumber < DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                TConsensusGroupId schemaConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.SchemaRegion, (storageGroupNumber * DEVICE_PER_STORAGE_GROUP + deviceNumber) * TIME_PARTITION_PER_STORAGE_GROUP);
                this.checkRegionReplicaSet(schemaConsensusGroupId);
                for (int timePartitionSlotNumber = 0; timePartitionSlotNumber < TIME_PARTITION_PER_STORAGE_GROUP; ++timePartitionSlotNumber) {
                    TConsensusGroupId dataConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, (storageGroupNumber * DEVICE_PER_STORAGE_GROUP + deviceNumber) * TIME_PARTITION_PER_STORAGE_GROUP + timePartitionSlotNumber + 1);
                    this.checkRegionReplicaSet(dataConsensusGroupId);
                }
            }
        }
    }

    private void checkRegionReplicaSet(TConsensusGroupId consensusGroupId) {
        try {
            Assert.assertNotNull((Object)this.partitionCache.getRegionReplicaSet(consensusGroupId));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSchemaRegionCache() {
        int storageGroupNumber;
        String deviceName;
        SchemaPartition schemaPartition;
        HashMap<Object, List<String>> searchMap;
        for (int storageGroupNumber2 = 0; storageGroupNumber2 < STORAGE_GROUP_NUMBER; ++storageGroupNumber2) {
            String storageGroupName = PartitionCacheTest.getStorageGroupName(storageGroupNumber2);
            for (int deviceNumber = 0; deviceNumber < DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                String deviceName2 = PartitionCacheTest.getDeviceName(storageGroupName, deviceNumber);
                TSeriesPartitionSlot seriesPartitionSlot = partitionExecutor.getSeriesPartitionSlot(deviceName2);
                searchMap = new HashMap<Object, List<String>>();
                searchMap.put(storageGroupName, Collections.singletonList(deviceName2));
                schemaPartition = this.partitionCache.getSchemaPartition(searchMap);
                Assert.assertNotNull((Object)schemaPartition);
                Map result = schemaPartition.getSchemaPartitionMap();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)1L, (long)result.size());
                Assert.assertNotNull(result.get(storageGroupName));
                Assert.assertEquals((long)1L, (long)((Map)result.get(storageGroupName)).size());
                Assert.assertNotNull(((Map)result.get(storageGroupName)).get(seriesPartitionSlot));
            }
        }
        List<String> missedStorageGroupNames = Arrays.asList(STORAGE_GROUP_PREFIX, "root.*");
        for (String missedStorageGroupName : missedStorageGroupNames) {
            for (int deviceNumber = 0; deviceNumber < DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                deviceName = PartitionCacheTest.getDeviceName(missedStorageGroupName, deviceNumber);
                searchMap = new HashMap();
                searchMap.put(missedStorageGroupName, Collections.singletonList(deviceName));
                schemaPartition = this.partitionCache.getSchemaPartition(searchMap);
                Assert.assertNull((Object)schemaPartition);
            }
        }
        for (storageGroupNumber = 0; storageGroupNumber < STORAGE_GROUP_NUMBER; ++storageGroupNumber) {
            String storageGroupName = PartitionCacheTest.getStorageGroupName(storageGroupNumber);
            for (int deviceNumber = DEVICE_PER_STORAGE_GROUP.intValue(); deviceNumber < 2 * DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                deviceName = PartitionCacheTest.getDeviceName(storageGroupName, deviceNumber);
                searchMap = new HashMap();
                searchMap.put(storageGroupName, Collections.singletonList(deviceName));
                schemaPartition = this.partitionCache.getSchemaPartition(searchMap);
                Assert.assertNull((Object)schemaPartition);
            }
        }
        this.partitionCache.invalidAllSchemaPartitionCache();
        for (storageGroupNumber = 0; storageGroupNumber < STORAGE_GROUP_NUMBER; ++storageGroupNumber) {
            String storageGroupName = PartitionCacheTest.getStorageGroupName(storageGroupNumber);
            for (int deviceNumber = 0; deviceNumber < DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                deviceName = PartitionCacheTest.getDeviceName(storageGroupName, deviceNumber);
                searchMap = new HashMap();
                searchMap.put(storageGroupName, Collections.singletonList(deviceName));
                schemaPartition = this.partitionCache.getSchemaPartition(searchMap);
                Assert.assertNull((Object)schemaPartition);
            }
        }
    }

    @Test
    public void testDataPartitionCache() {
        int storageGroupNumber;
        String deviceName;
        DataPartition dataPartition;
        Map<String, List<DataPartitionQueryParam>> searchMap;
        for (int storageGroupNumber2 = 0; storageGroupNumber2 < STORAGE_GROUP_NUMBER; ++storageGroupNumber2) {
            String storageGroupName = PartitionCacheTest.getStorageGroupName(storageGroupNumber2);
            for (int deviceNumber = 0; deviceNumber < DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                String deviceName2 = PartitionCacheTest.getDeviceName(storageGroupName, deviceNumber);
                TSeriesPartitionSlot seriesPartitionSlot = partitionExecutor.getSeriesPartitionSlot(deviceName2);
                searchMap = this.getStorageGroupToQueryParamsMap(storageGroupName, deviceName2, false);
                dataPartition = this.partitionCache.getDataPartition(searchMap);
                Assert.assertNotNull((Object)dataPartition);
                Assert.assertNotNull((Object)dataPartition.getDataPartitionMap());
                Map result = dataPartition.getDataPartitionMap();
                Assert.assertEquals((long)1L, (long)result.size());
                Assert.assertNotNull(result.get(storageGroupName));
                Map timePartitionSlotListMap = (Map)((Map)result.get(storageGroupName)).get(seriesPartitionSlot);
                Assert.assertNotNull((Object)timePartitionSlotListMap);
                for (int timePartitionSlotNumber = 0; timePartitionSlotNumber < TIME_PARTITION_PER_STORAGE_GROUP; ++timePartitionSlotNumber) {
                    TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot((long)timePartitionSlotNumber);
                    Assert.assertNotNull(timePartitionSlotListMap.get(timePartitionSlot));
                }
            }
        }
        List<String> missedStorageGroupNames = Arrays.asList(STORAGE_GROUP_PREFIX, "root.*");
        for (String missedStorageGroupName : missedStorageGroupNames) {
            for (int deviceNumber = 0; deviceNumber < DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                deviceName = PartitionCacheTest.getDeviceName(missedStorageGroupName, deviceNumber);
                searchMap = this.getStorageGroupToQueryParamsMap(missedStorageGroupName, deviceName, false);
                dataPartition = this.partitionCache.getDataPartition(searchMap);
                Assert.assertNull((Object)dataPartition);
            }
        }
        for (storageGroupNumber = 0; storageGroupNumber < STORAGE_GROUP_NUMBER; ++storageGroupNumber) {
            String storageGroupName = PartitionCacheTest.getStorageGroupName(storageGroupNumber);
            for (int deviceNumber = DEVICE_PER_STORAGE_GROUP.intValue(); deviceNumber < 2 * DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                deviceName = PartitionCacheTest.getDeviceName(storageGroupName, deviceNumber);
                searchMap = this.getStorageGroupToQueryParamsMap(storageGroupName, deviceName, false);
                dataPartition = this.partitionCache.getDataPartition(searchMap);
                Assert.assertNull((Object)dataPartition);
            }
        }
        for (storageGroupNumber = 0; storageGroupNumber < STORAGE_GROUP_NUMBER; ++storageGroupNumber) {
            String storageGroupName = PartitionCacheTest.getStorageGroupName(storageGroupNumber);
            for (int deviceNumber = 0; deviceNumber < DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                deviceName = PartitionCacheTest.getDeviceName(storageGroupName, deviceNumber);
                searchMap = this.getStorageGroupToQueryParamsMap(storageGroupName, deviceName, true);
                dataPartition = this.partitionCache.getDataPartition(searchMap);
                Assert.assertNull((Object)dataPartition);
            }
        }
        this.partitionCache.invalidAllDataPartitionCache();
        for (storageGroupNumber = 0; storageGroupNumber < STORAGE_GROUP_NUMBER; ++storageGroupNumber) {
            String storageGroupName = PartitionCacheTest.getStorageGroupName(storageGroupNumber);
            for (int deviceNumber = 0; deviceNumber < DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                deviceName = PartitionCacheTest.getDeviceName(storageGroupName, deviceNumber);
                searchMap = this.getStorageGroupToQueryParamsMap(storageGroupName, deviceName, false);
                dataPartition = this.partitionCache.getDataPartition(searchMap);
                Assert.assertNull((Object)dataPartition);
            }
        }
    }

    private Map<String, List<DataPartitionQueryParam>> getStorageGroupToQueryParamsMap(String storageGroupName, String deviceName, boolean timePartitionSlotMissed) {
        HashMap<String, List<DataPartitionQueryParam>> storageGroupToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
        ArrayList<TTimePartitionSlot> timePartitionSlotList = new ArrayList<TTimePartitionSlot>();
        int startTime = 0;
        if (timePartitionSlotMissed) {
            startTime = TIME_PARTITION_PER_STORAGE_GROUP;
        }
        for (int timePartitionSlotNumber = startTime; timePartitionSlotNumber < startTime + TIME_PARTITION_PER_STORAGE_GROUP; ++timePartitionSlotNumber) {
            TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot((long)timePartitionSlotNumber);
            timePartitionSlotList.add(timePartitionSlot);
        }
        DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDevicePath(deviceName);
        dataPartitionQueryParam.setTimePartitionSlotList(timePartitionSlotList);
        storageGroupToQueryParamsMap.put(storageGroupName, Collections.singletonList(dataPartitionQueryParam));
        return storageGroupToQueryParamsMap;
    }

    static {
        for (int storageGroupNumber = 0; storageGroupNumber < STORAGE_GROUP_NUMBER; ++storageGroupNumber) {
            String storageGroupName = PartitionCacheTest.getStorageGroupName(storageGroupNumber);
            storageGroups.add(storageGroupName);
            if (!schemaPartitionTable.containsKey(storageGroupName)) {
                schemaPartitionTable.put(storageGroupName, new HashMap());
            }
            if (!dataPartitionTable.containsKey(storageGroupName)) {
                dataPartitionTable.put(storageGroupName, new HashMap());
            }
            for (int deviceNumber = 0; deviceNumber < DEVICE_PER_STORAGE_GROUP; ++deviceNumber) {
                String deviceName = PartitionCacheTest.getDeviceName(storageGroupName, deviceNumber);
                TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot(partitionExecutor.getSeriesPartitionSlot(deviceName));
                TConsensusGroupId schemaConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.SchemaRegion, (storageGroupNumber * DEVICE_PER_STORAGE_GROUP + deviceNumber) * TIME_PARTITION_PER_STORAGE_GROUP);
                schemaPartitionTable.get(storageGroupName).put(seriesPartitionSlot, schemaConsensusGroupId);
                ArrayList dataNodeLocations = new ArrayList();
                TRegionReplicaSet schemaRegionReplicaSet = new TRegionReplicaSet(schemaConsensusGroupId, dataNodeLocations);
                consensusGroupIdToRegionReplicaSet.put(schemaConsensusGroupId, schemaRegionReplicaSet);
                dataPartitionTable.get(storageGroupName).put(seriesPartitionSlot, new HashMap());
                for (int timePartitionSlotNumber = 0; timePartitionSlotNumber < TIME_PARTITION_PER_STORAGE_GROUP; ++timePartitionSlotNumber) {
                    TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot((long)timePartitionSlotNumber);
                    TConsensusGroupId dataConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, (storageGroupNumber * DEVICE_PER_STORAGE_GROUP + deviceNumber) * TIME_PARTITION_PER_STORAGE_GROUP + timePartitionSlotNumber + 1);
                    dataPartitionTable.get(storageGroupName).get(seriesPartitionSlot).put(timePartitionSlot, Collections.singletonList(dataConsensusGroupId));
                    TRegionReplicaSet dataRegionReplicaSet = new TRegionReplicaSet(schemaConsensusGroupId, dataNodeLocations);
                    consensusGroupIdToRegionReplicaSet.put(dataConsensusGroupId, dataRegionReplicaSet);
                }
            }
        }
    }
}

