/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.Analyzer;
import org.apache.iotdb.db.mpp.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class AnalyzeTest {
    @Test
    public void testRawDataQuery() {
    }

    @Test
    public void testTimeFilterRewrite() throws IllegalPathException {
        String[] sqls = new String[]{"select s1 from root.sg.d1 where time>1 and time<3", "select s1 from root.sg.d1 where time>1 and time<3 or time>100", "select s1 from root.sg.d1 where time>1 or time<3", "select s1 from root.sg.d1 where time>1 and time<3 and s1>1", "select s1 from root.sg.d1 where time>1 and time<3 or s1>1", "select s1 from root.sg.d1 where time>1 or time<3 or time >5", "select s1 from root.sg.d1 where time>1 and time<3 and s1>1 and time>4", "select s1 from root.sg.d1 where time>1 and time<3 or time >4 and time>5", "select s1 from root.sg.d1 where time>1 or time<3 and s1>1", "select s1 from root.sg.d1 where time>1 or time<3 or s1>1", "select s1 from root.sg.d1 where time>1 or s1>1 and time<3", "select s1 from root.sg.d1 where time>1 or s1>1 or time<3"};
        Expression[] predicates = new Expression[]{null, null, null, new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")), new LogicOrExpression((Expression)new LogicAndExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3"))), (Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1"))), null, new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")), null, new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LogicAndExpression((Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3")), (Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")))), new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LogicOrExpression((Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3")), (Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")))), new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LogicAndExpression((Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")), (Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3")))), new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "1")), (Expression)new LogicOrExpression((Expression)new GreaterThanExpression((Expression)new TimeSeriesOperand(new PartialPath("s1")), (Expression)new ConstantOperand(TSDataType.INT32, "1")), (Expression)new LessThanExpression((Expression)new TimestampOperand(), (Expression)new ConstantOperand(TSDataType.INT64, "3"))))};
        for (int i = 0; i < sqls.length; ++i) {
            Analysis analysis = this.analyzeSQL(sqls[i]);
            QueryStatement queryStatement = (QueryStatement)analysis.getStatement();
            if (predicates[i] == null) {
                Assert.assertNull((Object)queryStatement.getWhereCondition());
                continue;
            }
            Assert.assertEquals((Object)predicates[i], (Object)queryStatement.getWhereCondition().getPredicate());
        }
    }

    private Analysis analyzeSQL(String sql) {
        try {
            Statement statement = StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset());
            MPPQueryContext context = new MPPQueryContext(new QueryId("test_query"));
            Analyzer analyzer = new Analyzer(context, (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
            return analyzer.analyze(statement);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
            Assert.fail();
            return null;
        }
    }
}

